'''OpenGL extension NV.vdpau_interop2

This module customises the behaviour of the 
OpenGL.raw.GL.NV.vdpau_interop2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows VDPAU video surfaces to be used
	either with frame or field structures for texturing and rendering.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/vdpau_interop2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.vdpau_interop2 import *
from OpenGL.raw.GL.NV.vdpau_interop2 import _EXTENSION_NAME

def glInitVdpauInterop2NV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glVDPAURegisterVideoSurfaceWithPictureStructureNV.textureNames size not checked against numTextureNames
glVDPAURegisterVideoSurfaceWithPictureStructureNV=wrapper.wrapper(glVDPAURegisterVideoSurfaceWithPictureStructureNV).setInputArraySize(
    'textureNames', None
)
### END AUTOGENERATED SECTION