/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

public class FkSecondPass
implements SecondPass {
    private ToOne value;
    private Ejb3JoinColumn[] columns;
    private boolean unique;
    private ExtendedMappings mappings;
    private String path;
    private String entityClassName;

    FkSecondPass(ToOne value, Ejb3JoinColumn[] columns, boolean unique, String entityClassName, String path, ExtendedMappings mappings) {
        this.mappings = mappings;
        this.value = value;
        this.columns = columns;
        this.unique = unique;
        this.entityClassName = entityClassName;
        this.path = entityClassName != null ? path.substring(entityClassName.length() + 1) : path;
    }

    public ToOne getValue() {
        return this.value;
    }

    public boolean isInPrimaryKey() {
        if (this.entityClassName == null) {
            return false;
        }
        Property property = this.mappings.getClass(this.entityClassName).getIdentifierProperty();
        return property != null && this.path != null && this.path.startsWith(property.getName());
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.value instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)this.value;
            PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
            if (ref == null) {
                throw new AnnotationException("@OneToOne or @ManyToOne on " + StringHelper.qualify((String)this.entityClassName, (String)this.path) + " references an unknown entity: " + manyToOne.getReferencedEntityName());
            }
            BinderHelper.createSyntheticPropertyReference(this.columns, ref, null, (Value)manyToOne, false, this.mappings);
            TableBinder.bindFk(ref, null, this.columns, (SimpleValue)manyToOne, this.unique, this.mappings);
            if (!manyToOne.isIgnoreNotFound()) {
                manyToOne.createPropertyRefConstraints(persistentClasses);
            }
        } else if (this.value instanceof OneToOne) {
            ((OneToOne)this.value).createForeignKey();
        } else {
            throw new AssertionFailure("FkSecondPass for a wrong value type: " + this.value.getClass().getName());
        }
    }
}

