/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Frame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverCommand;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowDriverWebsiteCommand
implements ICommand {
    private final IApplication _app;
    private final ISQLDriver _sqlDriver;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowDriverWebsiteCommand.class);
    private Frame _frame;

    public ShowDriverWebsiteCommand(IApplication app, ISQLDriver sqlDriver) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (sqlDriver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._app = app;
        this._sqlDriver = sqlDriver;
    }

    @Override
    public void execute() {
        Object[] args;
        String msg;
        String url = this._sqlDriver.getWebSiteUrl();
        if ((url == null || "".equals(url)) && Dialogs.showYesNo(this._frame, msg = s_stringMgr.getString("ShowDriverWebsiteCommand.comfirm", args = new Object[]{this._sqlDriver.getName()}))) {
            new ModifyDriverCommand(this._app, this._sqlDriver).execute();
            url = this._sqlDriver.getUrl();
        }
        if (url != null && !"".equals(url)) {
            this._app.openURL(url);
        }
    }
}

