/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.IScriptFileManager;

public class ScriptFileManager
implements IScriptFileManager {
    private static final ILogger s_log = LoggerController.createLogger(ScriptFileManager.class);
    private final HashSet<String> scriptFiles = new HashSet();
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();

    @Override
    public String getOutputFilenameForSession(ISession session, int number) throws IOException {
        String sessionUserName = session.getAlias().getUserName();
        File tempSessionFile = File.createTempFile(sessionUserName + "-" + number + "-session-for-diff-", ".sql");
        this.scriptFiles.add(tempSessionFile.getAbsolutePath());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Created temporary script filename for session:  " + tempSessionFile.getAbsolutePath()));
        }
        return tempSessionFile.getAbsolutePath();
    }

    @Override
    public void cleanupScriptFiles() {
        for (String scriptFile : this.scriptFiles) {
            FileWrapper fileWrapper = this.fileWrapperFactory.create(scriptFile);
            if (fileWrapper.exists()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Attempting to delete previously created temporary script file: " + scriptFile));
                }
                fileWrapper.delete();
                continue;
            }
            if (!s_log.isDebugEnabled()) continue;
            s_log.debug((Object)("Previously created temporary script file did not exist: " + scriptFile));
        }
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        this.fileWrapperFactory = fileWrapperFactory;
    }
}

