/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.AssistanceIconPanel;
import org.fife.rsta.ui.RComboBoxModel;
import org.fife.rsta.ui.search.AbstractSearchDialog;
import org.fife.rsta.ui.search.FindReplaceButtonsEnableResult;
import org.fife.ui.FSATextField;
import org.fife.ui.RScrollPane;
import org.fife.ui.StatusBar;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextfilechooser.RDirectoryChooser;
import org.fife.ui.search.FindInFilesEvent;
import org.fife.ui.search.FindInFilesListener;
import org.fife.ui.search.FindInFilesSearchContext;
import org.fife.ui.search.FindInFilesTable;
import org.fife.ui.search.FindInFilesThread;
import org.fife.ui.search.MatchData;
import org.fife.ui.search.ResultsComponent;

public class FindInFilesDialog
extends AbstractSearchDialog {
    protected JComboBox inFilesComboBox;
    protected FSATextField inFolderTextField;
    protected JCheckBox subfoldersCheckBox;
    protected JButton findButton;
    private JButton browseButton;
    private JRadioButton matchingLinesRadioButton;
    private JRadioButton fileCountsOnlyRadioButton;
    protected JCheckBox verboseCheckBox;
    private StatusBar statusBar;
    private ResultsComponent resultsComponent;
    private String lastSearchString;
    private String lastInFilesString;
    private EventListenerList eventListenerList;
    private FindInFilesThread workerThread;
    private FindInFilesDocumentListener docListener;
    private String defaultStatusText;
    private String searchingCompleteString;
    private static final String MSG = "org.fife.ui.search.Search";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.search.Search");

    public FindInFilesDialog(Frame owner) {
        super(owner);
        this.setTitle(this.getString2("FindInFilesDialogTitle"));
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.docListener = new FindInFilesDocumentListener();
        FindInFilesFocusAdapter focusAdapter = new FindInFilesFocusAdapter();
        FindInFilesKeyListener keyListener = new FindInFilesKeyListener();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        JTextComponent textField = FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo);
        textField.addFocusListener(focusAdapter);
        textField.addKeyListener(keyListener);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFilesComboBox = new JComboBox(new RComboBoxModel());
        this.inFilesComboBox.setEditable(true);
        textField = FindInFilesDialog.getTextComponent(this.inFilesComboBox);
        textField.addFocusListener(focusAdapter);
        textField.addKeyListener(keyListener);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFolderTextField = new FSATextField();
        this.inFolderTextField.setText(System.getProperty("user.home"));
        this.inFolderTextField.addFocusListener((FocusListener)focusAdapter);
        this.inFolderTextField.getDocument().addDocumentListener(this.docListener);
        JPanel inputPanel = this.createInputPanel();
        Box conditionsPanel = Box.createVerticalBox();
        conditionsPanel.setBorder(this.createTitledBorder(this.getString2("Conditions")));
        conditionsPanel.add(this.caseCheckBox);
        conditionsPanel.add(this.wholeWordCheckBox);
        conditionsPanel.add(this.regexCheckBox);
        Box detailEtcPanel = this.createDetailsPanel();
        Box bottomLeftPanel = new Box(2);
        bottomLeftPanel.add(conditionsPanel);
        bottomLeftPanel.add(Box.createHorizontalStrut(10));
        bottomLeftPanel.add(detailEtcPanel);
        bottomLeftPanel.add(Box.createHorizontalGlue());
        Box leftPanel = Box.createVerticalBox();
        leftPanel.add(inputPanel);
        leftPanel.add(bottomLeftPanel);
        JPanel rightPanel2 = new JPanel(new GridLayout(3, 1, 5, 5));
        this.findButton = UIUtil.newButton((ResourceBundle)this.getBundle(), (String)"Find");
        this.findButton.setActionCommand("FindInFiles");
        this.findButton.addActionListener((ActionListener)((Object)this));
        this.browseButton = UIUtil.newButton((ResourceBundle)msg, (String)"Browse");
        this.browseButton.setActionCommand("Browse");
        this.browseButton.addActionListener((ActionListener)((Object)this));
        this.cancelButton = UIUtil.newButton((ResourceBundle)msg, (String)"Close");
        this.cancelButton.setActionCommand("Close");
        this.cancelButton.addActionListener((ActionListener)((Object)this));
        rightPanel2.add(this.findButton);
        rightPanel2.add(this.browseButton);
        rightPanel2.add(this.cancelButton);
        JPanel rightPanel = new JPanel(new BorderLayout());
        if (orientation.isLeftToRight()) {
            rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        } else {
            rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        rightPanel.add((Component)rightPanel2, "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add(leftPanel);
        topPanel.add((Component)rightPanel, "After");
        Box extraOptionsPanel = this.createExtraOptionsPanel();
        JPanel resultsPanel = new JPanel(new GridLayout(1, 1, 3, 3));
        Border empty5Border = UIUtil.getEmpty5Border();
        resultsPanel.setBorder(BorderFactory.createCompoundBorder(empty5Border, BorderFactory.createCompoundBorder(this.createTitledBorder(this.getString2("Results")), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        this.resultsComponent = this.createResultsComponent();
        RScrollPane resultsScrollPane = new RScrollPane((Component)((JComponent)((Object)this.resultsComponent)));
        resultsScrollPane.setHorizontalScrollBarPolicy(32);
        resultsScrollPane.setVerticalScrollBarPolicy(22);
        resultsPanel.add((Component)resultsScrollPane);
        this.statusBar = new StatusBar();
        this.eventListenerList = new EventListenerList();
        this.defaultStatusText = this.getString2("DefaultStatusText");
        this.searchingCompleteString = this.getString2("SearchingComplete");
        this.setStatusText(this.defaultStatusText);
        Box temp = Box.createVerticalBox();
        temp.setBorder(empty5Border);
        temp.add(topPanel);
        temp.add(Box.createVerticalStrut(5));
        if (extraOptionsPanel != null) {
            temp.add(extraOptionsPanel);
        }
        contentPane.add((Component)temp, "North");
        contentPane.add(resultsPanel);
        contentPane.add((Component)this.statusBar, "South");
        this.getRootPane().setDefaultButton(this.findButton);
        this.setModal(false);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("FindInFiles".equals(command)) {
            String item = FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo).getText();
            this.findTextCombo.addItem((Object)item);
            this.context.setSearchFor(this.getSearchString());
            item = FindInFilesDialog.getTextComponent(this.inFilesComboBox).getText();
            this.inFilesComboBox.addItem(item);
            this.doFindInFiles();
        } else if ("Browse".equals(command)) {
            RDirectoryChooser chooser = new RDirectoryChooser((Dialog)((Object)this));
            String dirName = this.inFolderTextField.getText().trim();
            if (dirName.length() > 0) {
                File dir = new File(dirName);
                chooser.setChosenDirectory(dir);
            }
            chooser.setVisible(true);
            String directory = chooser.getChosenDirectory();
            if (directory != null) {
                this.inFolderTextField.setFileSystemAware(false);
                this.inFolderTextField.setText(directory);
                this.inFolderTextField.setFileSystemAware(true);
            }
        } else if ("Close".equals(command)) {
            FindInFilesThread workerThread = this.getWorkerThread();
            if (workerThread != null) {
                workerThread.interrupt();
                this.setSearching(false);
            } else {
                this.setVisible(false);
            }
        } else if ("Subfolders".equals(command)) {
            boolean search = this.subfoldersCheckBox.isSelected();
            ((FindInFilesSearchContext)this.context).setSearchSubfolders(search);
        } else if ("Verbose".equals(command)) {
            boolean verbose = this.verboseCheckBox.isSelected();
            ((FindInFilesSearchContext)this.context).setVerbose(verbose);
        } else {
            super.actionPerformed(e);
        }
    }

    void addMatchData(final MatchData matchData) {
        final String dirName = this.inFolderTextField.getText();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindInFilesDialog.this.getResultsComponent().addMatchData(matchData, dirName);
            }
        });
    }

    public void addFindInFilesListener(FindInFilesListener listener) {
        this.eventListenerList.add(FindInFilesListener.class, listener);
    }

    public void addInFilesComboBoxFilter(String filter) {
        this.inFilesComboBox.addItem(filter);
    }

    void clearSearchResults() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getResultsComponent().clear();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindInFilesDialog.this.getResultsComponent().clear();
                }
            });
        }
    }

    protected Box createDetailsPanel() {
        Box detailPanel = Box.createVerticalBox();
        detailPanel.setBorder(this.createTitledBorder(this.getString2("ReportDetail")));
        this.matchingLinesRadioButton = new JRadioButton(this.getString2("MatchingLines"));
        this.matchingLinesRadioButton.setMnemonic((int)this.getString2("MatchingLinesMnemonic").charAt(0));
        this.matchingLinesRadioButton.setSelected(true);
        detailPanel.add(this.matchingLinesRadioButton);
        this.fileCountsOnlyRadioButton = new JRadioButton(this.getString2("FileCounts"));
        this.fileCountsOnlyRadioButton.setMnemonic((int)this.getString2("FileCountsMnemonic").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.matchingLinesRadioButton);
        bg.add(this.fileCountsOnlyRadioButton);
        detailPanel.add(this.fileCountsOnlyRadioButton);
        Box panel = Box.createVerticalBox();
        this.subfoldersCheckBox = new JCheckBox(this.getString2("SearchSubfolders"));
        this.subfoldersCheckBox.setMnemonic((int)this.getString2("SearchSubfoldersMnemonic").charAt(0));
        this.subfoldersCheckBox.setActionCommand("Subfolders");
        this.subfoldersCheckBox.addActionListener((ActionListener)((Object)this));
        panel.add(detailPanel);
        panel.add(this.subfoldersCheckBox);
        return panel;
    }

    protected Box createExtraOptionsPanel() {
        Box temp = new Box(2);
        this.verboseCheckBox = new JCheckBox(this.getString2("Verbose"));
        this.verboseCheckBox.setActionCommand("Verbose");
        this.verboseCheckBox.addActionListener((ActionListener)((Object)this));
        this.verboseCheckBox.setMnemonic((int)this.getString2("VerboseMnemonic").charAt(0));
        temp.add(this.verboseCheckBox);
        temp.add(Box.createHorizontalGlue());
        return temp;
    }

    protected JPanel createInputPanel() {
        JPanel inputPanel = new JPanel(new SpringLayout());
        JLabel findLabel = UIUtil.newLabel((ResourceBundle)this.getBundle(), (String)"FindWhat", (Component)this.findTextCombo);
        JLabel inLabel = new JLabel(this.getString2("InFiles"));
        inLabel.setLabelFor(this.inFilesComboBox);
        inLabel.setDisplayedMnemonic((int)this.getString2("InFilesMnemonic").charAt(0));
        JLabel dirLabel = new JLabel(this.getString2("InDirectory"));
        dirLabel.setLabelFor((Component)this.inFolderTextField);
        dirLabel.setDisplayedMnemonic((int)this.getString2("InDirectoryMnemonic").charAt(0));
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.findTextCombo);
        AssistanceIconPanel aip = new AssistanceIconPanel((JComponent)this.findTextCombo);
        temp.add((Component)aip, "Before");
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add(this.inFilesComboBox);
        temp2.add(Box.createHorizontalStrut(8), "Before");
        JPanel temp3 = new JPanel(new BorderLayout());
        temp3.add((Component)this.inFolderTextField);
        temp3.add(Box.createHorizontalStrut(8), "Before");
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        if (orientation.isLeftToRight()) {
            inputPanel.add(findLabel);
            inputPanel.add(temp);
            inputPanel.add(inLabel);
            inputPanel.add(temp2);
            inputPanel.add(dirLabel);
            inputPanel.add(temp3);
        } else {
            inputPanel.add(temp);
            inputPanel.add(findLabel);
            inputPanel.add(temp2);
            inputPanel.add(inLabel);
            inputPanel.add(temp3);
            inputPanel.add(dirLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)inputPanel, (int)3, (int)2, (int)0, (int)0, (int)5, (int)5);
        return inputPanel;
    }

    protected ResultsComponent createResultsComponent() {
        FindInFilesTable table = new FindInFilesTable();
        table.addMouseListener(new FindInFilesDialogMouseListener(table));
        return table;
    }

    protected SearchContext createDefaultSearchContext() {
        return new FindInFilesSearchContext();
    }

    protected FindInFilesThread createWorkerThread(File directory) {
        return new FindInFilesThread(this, directory);
    }

    private void doFindInFiles() {
        String dirPath = this.inFolderTextField.getText();
        File directory = new File(dirPath);
        if (!directory.isDirectory()) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getString2("ErrorDirNotExist") + dirPath, this.getString2("ErrorDialogTitle"), 0);
            this.inFolderTextField.selectAll();
            this.inFolderTextField.requestFocusInWindow();
            return;
        }
        if (this.regexCheckBox.isSelected()) {
            try {
                Pattern.compile(this.getSearchString());
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                JOptionPane.showMessageDialog((Component)((Object)this), "Invalid regular expression:\n" + text + "\nPlease check your regular expression search string.", this.getString2("ErrorDialogTitle"), 0);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setSearching(true);
        this.setWorkerThread(this.createWorkerThread(directory));
        this.getWorkerThread().start();
    }

    protected void fireFindInFilesEvent(FindInFilesEvent e) {
        Object[] listeners = this.eventListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FindInFilesListener.class) continue;
            ((FindInFilesListener)listeners[i + 1]).findInFilesFileSelected(e);
        }
    }

    String getString2(String key) {
        return msg.getString(key);
    }

    protected static final JTextComponent getTextComponent(JComboBox combo) {
        return org.fife.rsta.ui.UIUtil.getTextComponent((JComboBox)combo);
    }

    boolean getCheckSubfolders() {
        return this.subfoldersCheckBox.isSelected();
    }

    boolean getDoVerboseOutput() {
        return this.verboseCheckBox.isSelected();
    }

    String getInFilesComboBoxContents() {
        return (String)this.inFilesComboBox.getSelectedItem();
    }

    protected static final int getLength(JTextComponent c) {
        return c.getDocument().getLength();
    }

    boolean getMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    boolean getMatchWholeWord() {
        return this.wholeWordCheckBox.isSelected();
    }

    protected ResultsComponent getResultsComponent() {
        return this.resultsComponent;
    }

    boolean getShowMatchingLines() {
        return this.matchingLinesRadioButton.isSelected();
    }

    boolean getUseRegEx() {
        return this.regexCheckBox.isSelected();
    }

    protected synchronized FindInFilesThread getWorkerThread() {
        return this.workerThread;
    }

    protected FindReplaceButtonsEnableResult handleToggleButtons() {
        FindReplaceButtonsEnableResult er = super.handleToggleButtons();
        boolean enable = er.getEnable();
        this.findButton.setEnabled(enable && this.isEverythingFilledIn());
        JTextComponent tc = FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo);
        tc.setForeground(enable ? UIManager.getColor("TextField.foreground") : Color.RED);
        String tooltip = er.getError();
        String status = this.defaultStatusText;
        if (tooltip != null && (status = tooltip).indexOf(10) > -1) {
            status = status.substring(0, status.indexOf(10));
        }
        this.setStatusText(status);
        if (tooltip != null && tooltip.indexOf(10) > -1) {
            tooltip = tooltip.replaceFirst("\\\n", "</b><br><pre>");
            tooltip = "<html><b>" + tooltip;
        }
        tc.setToolTipText(tooltip);
        return er;
    }

    protected boolean isEverythingFilledIn() {
        return this.getWorkerThread() == null && FindInFilesDialog.getLength(FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo)) > 0 && FindInFilesDialog.getLength(FindInFilesDialog.getTextComponent(this.inFilesComboBox)) > 0 && FindInFilesDialog.getLength((JTextComponent)this.inFolderTextField) > 0;
    }

    protected void refreshUIFromContext() {
        super.refreshUIFromContext();
        if (this.caseCheckBox == null) {
            return;
        }
        FindInFilesSearchContext fifsc = (FindInFilesSearchContext)this.context;
        this.subfoldersCheckBox.setSelected(fifsc.getSearchSubfolders());
        this.verboseCheckBox.setSelected(fifsc.getVerbose());
    }

    public void removeFindInFilesListener(FindInFilesListener listener) {
        this.eventListenerList.remove(FindInFilesListener.class, listener);
    }

    void searchCompleted(String message) {
        this.setStatusText(message);
        this.searchCompleted(-1L);
    }

    void searchCompleted(final long time) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindInFilesDialog.this.setWorkerThread(null);
                FindInFilesDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                FindInFilesDialog.this.setSearching(false);
                if (time != -1L) {
                    String temp = MessageFormat.format(FindInFilesDialog.this.searchingCompleteString, "" + (float)time / 1000.0f);
                    FindInFilesDialog.this.setStatusText(temp);
                    if (FindInFilesDialog.this.getResultsComponent().getRowCount() == 0) {
                        String searchString = (String)FindInFilesDialog.this.findTextCombo.getSelectedItem();
                        JOptionPane.showMessageDialog((Component)((Object)FindInFilesDialog.this), FindInFilesDialog.this.getString2("SearchStringNotFound") + searchString + "'.", FindInFilesDialog.this.getString2("InfoDialogTitle"), 1);
                    }
                }
                FindInFilesDialog.this.getResultsComponent().prettyUp();
            }
        });
    }

    protected void setSearching(boolean searching) {
        boolean enabled = !searching;
        this.findButton.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        if (searching) {
            this.cancelButton.setText(this.getString2("Stop"));
            this.cancelButton.setMnemonic((int)this.getString2("Stop.Mnemonic").charAt(0));
        } else {
            this.cancelButton.setText(this.getString2("Close"));
            this.cancelButton.setMnemonic((int)this.getString2("Close.Mnemonic").charAt(0));
        }
        this.findTextCombo.setEnabled(enabled);
        this.inFilesComboBox.setEnabled(enabled);
        this.inFolderTextField.setEnabled(enabled);
    }

    public void setStatusText(final String text) {
        if (this.isVisible()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.statusBar.setStatusMessage(text);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FindInFilesDialog.this.statusBar.setStatusMessage(text);
                    }
                });
            }
        }
    }

    public void setVisible(boolean visible) {
        this.refreshUIFromContext();
        super.setVisible(visible);
        if (visible) {
            this.setStatusText(this.defaultStatusText);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.handleToggleButtons();
            this.findTextCombo.requestFocusInWindow();
            JTextComponent editor = FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo);
            editor.selectAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindInFilesDialog.this.handleToggleButtons();
                    FindInFilesDialog.this.findTextCombo.requestFocusInWindow();
                    JTextComponent editor = FindInFilesDialog.getTextComponent((JComboBox)FindInFilesDialog.this.findTextCombo);
                    editor.selectAll();
                }
            });
        }
    }

    private synchronized void setWorkerThread(FindInFilesThread thread) {
        this.workerThread = thread;
    }

    public void updateUI() {
        FindInFilesFocusAdapter focusAdapter = new FindInFilesFocusAdapter();
        FindInFilesKeyListener keyListener = new FindInFilesKeyListener();
        JTextComponent textField = FindInFilesDialog.getTextComponent((JComboBox)this.findTextCombo);
        textField.addFocusListener(focusAdapter);
        textField.addKeyListener(keyListener);
        textField.getDocument().addDocumentListener(this.docListener);
        textField = FindInFilesDialog.getTextComponent(this.inFilesComboBox);
        textField.addFocusListener(focusAdapter);
        textField.addKeyListener(keyListener);
        textField.getDocument().addDocumentListener(this.docListener);
        this.inFolderTextField.addFocusListener((FocusListener)focusAdapter);
        this.inFolderTextField.getDocument().addDocumentListener(this.docListener);
    }

    private class FindInFilesKeyListener
    extends KeyAdapter {
        private FindInFilesKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && FindInFilesDialog.isPreJava6JRE()) {
                Object source = e.getSource();
                if (source == FindInFilesDialog.getTextComponent((JComboBox)FindInFilesDialog.this.findTextCombo)) {
                    String inFilesString = (String)FindInFilesDialog.this.inFilesComboBox.getSelectedItem();
                    FindInFilesDialog.this.lastInFilesString = inFilesString;
                    String searchString = (String)FindInFilesDialog.this.findTextCombo.getSelectedItem();
                    if (!searchString.equals(FindInFilesDialog.this.lastSearchString)) {
                        FindInFilesDialog.this.findButton.doClick(0);
                        FindInFilesDialog.this.lastSearchString = searchString;
                        FindInFilesDialog.getTextComponent((JComboBox)FindInFilesDialog.this.findTextCombo).selectAll();
                    }
                } else if (source == FindInFilesDialog.getTextComponent(FindInFilesDialog.this.inFilesComboBox)) {
                    String searchString = (String)FindInFilesDialog.this.findTextCombo.getSelectedItem();
                    FindInFilesDialog.this.lastSearchString = searchString;
                    String inFilesString = (String)FindInFilesDialog.this.inFilesComboBox.getSelectedItem();
                    if (!inFilesString.equals(FindInFilesDialog.this.lastInFilesString)) {
                        FindInFilesDialog.this.findButton.doClick(0);
                        FindInFilesDialog.this.lastInFilesString = inFilesString;
                        FindInFilesDialog.getTextComponent(FindInFilesDialog.this.inFilesComboBox).selectAll();
                    }
                }
            }
        }
    }

    class FindInFilesDialogMouseListener
    extends MouseAdapter {
        ResultsComponent comp;

        FindInFilesDialogMouseListener(ResultsComponent comp) {
            this.comp = comp;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = this.comp.getSelectedRow();
                if (row == -1) {
                    return;
                }
                MatchData data = this.comp.getMatchDataForRow(row);
                String fileName = data.getFileName();
                if (!new File(fileName).isFile()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                String lineStr = data.getLineNumber();
                int line = -1;
                if (!"--".equals(lineStr)) {
                    if (lineStr.indexOf(45) > -1) {
                        lineStr = lineStr.substring(0, lineStr.indexOf(45));
                    }
                    try {
                        line = Integer.parseInt(lineStr);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                FindInFilesDialog.this.fireFindInFilesEvent(new FindInFilesEvent((Object)FindInFilesDialog.this, fileName, line));
            }
        }
    }

    protected class FindInFilesFocusAdapter
    extends FocusAdapter {
        protected FindInFilesFocusAdapter() {
        }

        public void focusGained(FocusEvent e) {
            Component component = e.getComponent();
            ((JTextField)component).selectAll();
            if (component == FindInFilesDialog.getTextComponent((JComboBox)FindInFilesDialog.this.findTextCombo)) {
                FindInFilesDialog.this.lastSearchString = (String)FindInFilesDialog.this.findTextCombo.getSelectedItem();
            } else if (component == FindInFilesDialog.getTextComponent(FindInFilesDialog.this.inFilesComboBox)) {
                FindInFilesDialog.this.lastInFilesString = (String)FindInFilesDialog.this.inFilesComboBox.getSelectedItem();
            }
        }
    }

    private class FindInFilesDocumentListener
    implements DocumentListener {
        private FindInFilesDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            FindInFilesDialog.this.handleToggleButtons();
        }

        public void removeUpdate(DocumentEvent e) {
            FindInFilesDialog.this.handleToggleButtons();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

