/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;
import net.sourceforge.napkinlaf.util.NapkinUtil;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomValueSource;
import net.sourceforge.napkinlaf.util.RandomXY;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawnBoxGenerator
extends AbstractDrawnGenerator {
    private final RandomXY corner;
    private double adjustmentX;
    private double adjustmentY;
    private final RandomValue startAdjust;
    private final RandomXY size;
    private int breakSide;
    private final Point2D breakBeg;
    private final Point2D breakEnd;
    private final Shape[] sides;
    private final AbstractDrawnGenerator[] gens;
    private final Map<Class<?>, AbstractDrawnGenerator> generators = new HashMap(3);
    private boolean asX;
    private static final Logger logger = Logger.getLogger(DrawnBoxGenerator.class.getName());

    public DrawnBoxGenerator() {
        this(DrawnCubicLineGenerator.INSTANCE, DrawnQuadLineGenerator.INSTANCE);
    }

    public DrawnBoxGenerator(DrawnCubicLineGenerator cubic, DrawnQuadLineGenerator quad) {
        this.generators.put(DrawnCubicLineGenerator.class, cubic);
        this.generators.put(DrawnQuadLineGenerator.class, quad);
        this.sides = new Shape[5];
        this.gens = new AbstractDrawnGenerator[5];
        for (int i = 1; i < 5; ++i) {
            this.setGenerator(i, DrawnCubicLineGenerator.class);
        }
        this.corner = new RandomXY(-1.0, 3.0, 0.0, 2.5);
        this.startAdjust = new RandomValue(5.0);
        this.size = new RandomXY(new SideSize(100.0, 2, 4), new SideSize(61.8, 1, 3));
        this.breakSide = -1;
        this.breakBeg = new Point2D.Double(0.0, 0.0);
        this.breakEnd = new Point2D.Double(0.0, 0.0);
    }

    @Override
    public Shape generate(AffineTransform matrix) {
        matrix = matrix != null ? matrix : new AffineTransform();
        GeneralPath shape = new GeneralPath();
        double xSize = this.size.getX().generate();
        double ySize = this.size.getY().generate();
        double xScale = xSize / 100.0;
        double yScale = ySize / 100.0;
        double xCorner = this.adjustStartOffset(this.corner.getX(), xScale);
        double yCorner = this.adjustStartOffset(this.corner.getY(), yScale);
        this.adjustmentX = xCorner - this.corner.getX().get();
        this.adjustmentY = yCorner - this.corner.getY().get();
        if (this.asX) {
            NapkinUtil.drawStroke(shape, matrix, xCorner, 0.0, xSize, ySize, Math.PI, this.gens[0]);
            NapkinUtil.drawStroke(shape, matrix, 0.0, ySize, xSize, yCorner, 0.0, this.gens[0]);
            return shape;
        }
        double scale = (xSize - xCorner) / 100.0;
        AffineTransform smat = (AffineTransform)matrix.clone();
        smat.translate(xCorner, 0.0);
        smat.scale(scale, 1.0);
        this.sides[1] = this.addSide(shape, smat, 1, scale);
        scale = xScale;
        smat = (AffineTransform)matrix.clone();
        smat.translate(xSize, ySize);
        smat.rotate(Math.PI);
        smat.scale(scale, 1.0);
        this.sides[3] = this.addSide(shape, smat, 3, scale);
        scale = yScale;
        smat = (AffineTransform)matrix.clone();
        smat.translate(xSize, 0.0);
        smat.rotate(1.5707963267948966);
        smat.scale(scale, 1.0);
        this.sides[4] = this.addSide(shape, smat, 4, scale);
        scale = (ySize - yCorner) / 100.0;
        smat = (AffineTransform)matrix.clone();
        smat.translate(0.0, ySize);
        smat.rotate(-1.5707963267948966);
        smat.scale(scale, 1.0);
        this.sides[2] = this.addSide(shape, smat, 2, scale);
        return shape;
    }

    private Shape addSide(GeneralPath shape, AffineTransform smat, int side, double scale) {
        Shape result;
        if (side == this.breakSide) {
            GeneralPath line = new GeneralPath();
            if (side == 3 || side == 2) {
                scale = -scale;
            }
            if (side == 1 || side == 3) {
                this.addWithXBreak(smat, line, scale);
            } else {
                this.addWithYBreak(smat, line, scale);
            }
            shape.append(line, false);
            result = line;
        } else {
            result = DrawnBoxGenerator.addLine(shape, smat, this.gens[side]);
        }
        return result;
    }

    private void addWithXBreak(AffineTransform smat, GeneralPath line, double scale) {
        double xOff = smat.getTranslateX();
        double xSize = this.size.getX().get() - (this.corner.getX().get() + this.adjustmentX);
        if (scale < 0.0) {
            xSize = -xSize;
        }
        double xBeg = this.breakBeg.getX() - xOff;
        double xEnd = this.breakEnd.getX() - xOff;
        this.dumpValues(smat, xBeg, xEnd);
        this.addSegment(line, smat, 0.0, 0.0, xBeg / scale);
        this.addSegment(line, smat, xEnd / scale, 0.0, (xSize - xEnd) / scale);
    }

    private void addWithYBreak(AffineTransform smat, GeneralPath line, double scale) {
        double yOff = smat.getTranslateY();
        double ySize = this.size.getY().get() - (this.corner.getY().get() + this.adjustmentY);
        if (scale < 0.0) {
            ySize = -ySize;
        }
        double yBeg = this.breakBeg.getY() - yOff;
        double yEnd = this.breakEnd.getY() - yOff;
        this.dumpValues(smat, yBeg, yEnd);
        this.addSegment(line, smat, 0.0, 0.0, yBeg / scale);
        this.addSegment(line, smat, yEnd / scale, 0.0, (ySize - yEnd) / scale);
    }

    private void dumpValues(AffineTransform smat, double beg, double end) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "");
            NapkinUtil.printPair(logger, Level.FINE, "translate", smat.getTranslateX(), smat.getTranslateY());
            NapkinUtil.printPair(logger, Level.FINE, "scale", smat.getScaleX(), smat.getScaleY());
            NapkinUtil.printPair(logger, Level.FINE, "breakBeg", this.breakBeg.getX(), this.breakBeg.getY());
            NapkinUtil.printPair(logger, Level.FINE, "breakEnd", this.breakEnd.getX(), this.breakEnd.getY());
            NapkinUtil.printPair(logger, Level.FINE, "size", this.size.getX().get(), this.size.getY().get());
            NapkinUtil.printPair(logger, Level.FINE, "adjustment", this.adjustmentX, this.adjustmentY);
            NapkinUtil.printPair(logger, Level.FINE, "beg/end", this.corner.getX().get(), this.corner.getY().get());
            NapkinUtil.printPair(logger, Level.FINE, "break beg/end", beg, end);
        }
    }

    private void addSegment(GeneralPath side, AffineTransform smat, double xBeg, double yBeg, double len) {
        if (logger.isLoggable(Level.FINE)) {
            NapkinUtil.printPair(logger, Level.FINE, "addSeg (len " + len + ")", xBeg, yBeg);
        }
        if (len > 0.0) {
            AffineTransform mat = (AffineTransform)smat.clone();
            mat.translate(xBeg, yBeg);
            mat.scale(len / 100.0, 1.0);
            DrawnBoxGenerator.addLine(side, mat, this.toGenerator(DrawnBoxGenerator.defaultLineType(len)));
        }
    }

    private double adjustStartOffset(RandomValueSource off, double scale) {
        double result = off.generate();
        if (scale < 1.0) {
            double delta = 1.0 - scale;
            double exp = this.startAdjust.generate();
            double adjusted = Math.pow(delta, exp);
            double startScale = 1.0 - adjusted;
            result *= startScale;
        }
        return result;
    }

    public RandomValue getStartAdjust() {
        return this.startAdjust;
    }

    public Shape getSide(int side) {
        return this.sides[side];
    }

    public void setBreak(int side, double begX, double begY, double endX, double endY) {
        this.breakSide = side;
        this.breakBeg.setLocation(begX, begY);
        this.breakEnd.setLocation(endX, endY);
    }

    public void setNoBreak() {
        this.breakSide = -1;
    }

    public void setGenerator(int side, Class<?> type) {
        this.gens[side] = this.toGenerator(type);
    }

    public Class<? extends AbstractDrawnGenerator> getGenerator(int side) {
        return DrawnBoxGenerator.fromGenerator(this.gens[side]);
    }

    private static Class<? extends AbstractDrawnGenerator> fromGenerator(AbstractDrawnGenerator gen) {
        return gen == null ? null : gen.getClass();
    }

    private AbstractDrawnGenerator toGenerator(Class<?> type) {
        AbstractDrawnGenerator result = null;
        if (type != null && (result = this.generators.get(type)) == null) {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        return result;
    }

    public DrawnQuadLineGenerator getQuadGenerator() {
        return (DrawnQuadLineGenerator)this.generators.get(DrawnQuadLineGenerator.class);
    }

    public DrawnCubicLineGenerator getCubicGenerator() {
        return (DrawnCubicLineGenerator)this.generators.get(DrawnCubicLineGenerator.class);
    }

    public void setAsX(boolean asX) {
        this.asX = asX;
    }

    public boolean isAsX() {
        return this.asX;
    }

    public RandomXY getSize() {
        return this.size;
    }

    public RandomXY getCorner() {
        return this.corner;
    }

    private class SideSize
    extends RandomValue {
        private final int s1;
        private final int s2;

        SideSize(double val, int s1, int s2) {
            super(val);
            this.s1 = s1;
            this.s2 = s2;
            this.setSideType(val);
        }

        public void setMid(double mid) {
            super.setMid(mid);
            this.setSideType(mid);
        }

        private void setSideType(double mid) {
            Class<? extends AbstractDrawnGenerator> type = AbstractDrawnGenerator.defaultLineType(mid);
            DrawnBoxGenerator.this.setGenerator(this.s1, type);
            DrawnBoxGenerator.this.setGenerator(this.s2, type);
        }
    }
}

