/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;
import org.graalvm.visualvm.lib.jfluid.heap.LongIterator;

class NumberList {
    private static final int NUMBERS_IN_BLOCK = 3;
    private final File dataFile;
    private final RandomAccessFile data;
    private final int numberSize;
    private final int blockSize;
    private final Map<Long, byte[]> blockCache;
    private final Set<Long> dirtyBlocks;
    private long blocks;
    private MappedByteBuffer buf;
    private long mappedSize;
    private CacheDirectory cacheDirectory;

    NumberList(long dumpFileSize, CacheDirectory cacheDir) throws IOException {
        this(NumberList.bytes(dumpFileSize), cacheDir);
    }

    NumberList(int elSize, CacheDirectory cacheDir) throws IOException {
        this.dataFile = cacheDir.createTempFile("NBProfiler", ".ref");
        this.data = new RandomAccessFile(this.dataFile, "rw");
        this.numberSize = elSize;
        this.blockCache = new BlockLRUCache<Long, byte[]>();
        this.dirtyBlocks = new HashSet<Long>(100000);
        this.blockSize = 4 * this.numberSize;
        this.cacheDirectory = cacheDir;
        this.addBlock();
    }

    private static int bytes(long number) {
        if ((number & 0xFFFFFFFFFFFFFF00L) == 0L) {
            return 1;
        }
        if ((number & 0xFFFFFFFFFFFF0000L) == 0L) {
            return 2;
        }
        if ((number & 0xFFFFFFFFFF000000L) == 0L) {
            return 3;
        }
        if ((number & 0xFFFFFFFF00000000L) == 0L) {
            return 4;
        }
        if ((number & 0xFFFFFF0000000000L) == 0L) {
            return 5;
        }
        if ((number & 0xFFFF000000000000L) == 0L) {
            return 6;
        }
        if ((number & 0xFF00000000000000L) == 0L) {
            return 7;
        }
        return 8;
    }

    protected void finalize() throws Throwable {
        if (this.cacheDirectory.isTemporary()) {
            this.dataFile.delete();
        }
        super.finalize();
    }

    long addNumber(long startOffset, long number) throws IOException {
        int slot;
        byte[] block = this.getBlock(startOffset);
        for (slot = 0; slot < 3; ++slot) {
            long el = this.readNumber(block, slot);
            if (el == 0L) {
                this.writeNumber(startOffset, block, slot, number);
                return startOffset;
            }
            if (el != number) continue;
            return startOffset;
        }
        long nextBlock = this.addBlock();
        block = this.getBlock(nextBlock);
        this.writeNumber(nextBlock, block, slot, startOffset);
        this.writeNumber(nextBlock, block, 0, number);
        return nextBlock;
    }

    long addFirstNumber(long number1, long number2) throws IOException {
        long blockOffset = this.addBlock();
        byte[] block = this.getBlock(blockOffset);
        this.writeNumber(blockOffset, block, 0, number1);
        this.writeNumber(blockOffset, block, 1, number2);
        return blockOffset;
    }

    void putFirst(long startOffset, long number) throws IOException {
        byte[] block;
        long offset = startOffset;
        long movedNumber = 0L;
        block0: do {
            block = this.getBlock(offset);
            for (int slot = 0; slot < 3; ++slot) {
                long el = this.readNumber(block, slot);
                if (offset == startOffset && slot == 0) {
                    if (number == el) {
                        return;
                    }
                    movedNumber = el;
                    this.writeNumber(offset, block, slot, number);
                    continue;
                }
                if (el == 0L) continue block0;
                if (el != number) continue;
                this.writeNumber(offset, block, slot, movedNumber);
                return;
            }
        } while ((offset = this.getOffsetToNextBlock(block)) != 0L);
        System.out.println("Error - number not found at end");
    }

    long getFirstNumber(long startOffset) throws IOException {
        byte[] block = this.getBlock(startOffset);
        return this.readNumber(block, 0);
    }

    LongIterator getNumbersIterator(long startOffset) throws IOException {
        return new NumberIterator(startOffset);
    }

    List<Long> getNumbers(long startOffset) throws IOException {
        ArrayList<Long> numbers = new ArrayList<Long>();
        while (true) {
            long el;
            byte[] block = this.getBlock(startOffset);
            for (int slot = 0; slot < 3 && (el = this.readNumber(block, slot)) != 0L; ++slot) {
                numbers.add(new Long(el));
            }
            long nextBlock = this.getOffsetToNextBlock(block);
            if (nextBlock == 0L) {
                return numbers;
            }
            startOffset = nextBlock;
        }
    }

    private void mmapData() {
        if (this.buf == null) {
            try {
                this.mappedSize = Math.min((long)this.blockSize * this.blocks, (long)(Integer.MAX_VALUE - this.blockSize + 1));
                this.buf = this.data.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.mappedSize);
            }
            catch (IOException ex) {
                this.mappedSize = 0L;
                ex.printStackTrace();
            }
        }
    }

    void flush() {
        try {
            this.flushDirtyBlocks();
            this.blockCache.clear();
            this.mmapData();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private long getOffsetToNextBlock(byte[] block) {
        return this.readNumber(block, 3);
    }

    private long readNumber(byte[] block, int slot) {
        int offset = slot * this.numberSize;
        long el = 0L;
        if (this.numberSize == 4) {
            return (long)this.getInt(block, offset) & 0xFFFFFFFFL;
        }
        if (this.numberSize == 8) {
            return this.getLong(block, offset);
        }
        return el;
    }

    private int getInt(byte[] buf, int i) {
        int ch1 = buf[i++] & 0xFF;
        int ch2 = buf[i++] & 0xFF;
        int ch3 = buf[i++] & 0xFF;
        int ch4 = buf[i] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private long getLong(byte[] buf, int i) {
        return ((long)buf[i++] << 56) + ((long)(buf[i++] & 0xFF) << 48) + ((long)(buf[i++] & 0xFF) << 40) + ((long)(buf[i++] & 0xFF) << 32) + ((long)(buf[i++] & 0xFF) << 24) + (long)((buf[i++] & 0xFF) << 16) + (long)((buf[i++] & 0xFF) << 8) + (long)((buf[i++] & 0xFF) << 0);
    }

    private synchronized void writeNumber(long blockOffset, byte[] block, int slot, long element) throws IOException {
        if (blockOffset < this.mappedSize) {
            long offset = blockOffset + (long)(slot * this.numberSize);
            this.buf.position((int)offset);
            for (int i = this.numberSize - 1; i >= 0; --i) {
                byte el = (byte)(element >> i * 8);
                this.buf.put(el);
            }
        } else {
            Long offsetObj = new Long(blockOffset);
            int offset = slot * this.numberSize;
            for (int i = this.numberSize - 1; i >= 0; --i) {
                byte el = (byte)(element >> i * 8);
                block[offset++] = el;
            }
            this.dirtyBlocks.add(offsetObj);
            if (this.dirtyBlocks.size() > 10000) {
                this.flushDirtyBlocks();
            }
        }
    }

    private synchronized byte[] getBlock(long offset) throws IOException {
        if (offset < this.mappedSize) {
            byte[] block = new byte[this.blockSize];
            this.buf.position((int)offset);
            this.buf.get(block);
            return block;
        }
        Long offsetObj = new Long(offset);
        byte[] block = this.blockCache.get(offsetObj);
        if (block == null) {
            block = new byte[this.blockSize];
            this.data.seek(offset);
            this.data.readFully(block);
            this.blockCache.put(offsetObj, block);
        }
        return block;
    }

    private long addBlock() throws IOException {
        long offset = this.blocks * (long)this.blockSize;
        this.blockCache.put(new Long(offset), new byte[this.blockSize]);
        ++this.blocks;
        return offset;
    }

    private void flushDirtyBlocks() throws IOException {
        if (this.dirtyBlocks.isEmpty()) {
            return;
        }
        Object[] dirty = this.dirtyBlocks.toArray(new Long[0]);
        Arrays.sort(dirty);
        byte[] blocks = new byte[1024 * this.blockSize];
        int dataOffset = 0;
        long lastBlockOffset = 0L;
        for (Object blockOffsetLong : dirty) {
            byte[] block = this.blockCache.get(blockOffsetLong);
            long blockOffset = (Long)blockOffsetLong;
            if (lastBlockOffset + (long)dataOffset == blockOffset && dataOffset <= blocks.length - this.blockSize) {
                System.arraycopy(block, 0, blocks, dataOffset, this.blockSize);
                dataOffset += this.blockSize;
                continue;
            }
            this.data.seek(lastBlockOffset);
            this.data.write(blocks, 0, dataOffset);
            dataOffset = 0;
            System.arraycopy(block, 0, blocks, dataOffset, this.blockSize);
            dataOffset += this.blockSize;
            lastBlockOffset = blockOffset;
        }
        this.data.seek(lastBlockOffset);
        this.data.write(blocks, 0, dataOffset);
        this.dirtyBlocks.clear();
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeUTF(this.dataFile.getAbsolutePath());
        out.writeInt(this.numberSize);
        out.writeLong(this.blocks);
        out.writeBoolean(this.buf != null);
    }

    NumberList(DataInputStream dis, CacheDirectory cacheDir) throws IOException {
        this.cacheDirectory = cacheDir;
        this.dataFile = this.cacheDirectory.getCacheFile(dis.readUTF());
        this.data = new RandomAccessFile(this.dataFile, "rw");
        this.numberSize = dis.readInt();
        this.blocks = dis.readLong();
        boolean mmaped = dis.readBoolean();
        this.blockCache = new BlockLRUCache<Long, byte[]>();
        this.dirtyBlocks = new HashSet<Long>(100000);
        this.blockSize = 4 * this.numberSize;
        if (mmaped) {
            this.mmapData();
        }
    }

    private class BlockLRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int MAX_CAPACITY = 10000;

        private BlockLRUCache() {
            super(10000, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > 10000) {
                K key = eldest.getKey();
                if (!NumberList.this.dirtyBlocks.contains(key)) {
                    return true;
                }
                this.get(key);
            }
            return false;
        }
    }

    private class NumberIterator
    extends LongIterator {
        private int slot = 0;
        private byte[] block;
        private long nextNumber;

        private NumberIterator(long startOffset) throws IOException {
            this.block = NumberList.this.getBlock(startOffset);
            this.nextNumber();
        }

        @Override
        boolean hasNext() {
            return this.nextNumber != 0L;
        }

        @Override
        long next() {
            if (this.hasNext()) {
                long num = this.nextNumber;
                try {
                    this.nextNumber();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.nextNumber = 0L;
                }
                return num;
            }
            throw new NoSuchElementException();
        }

        private void nextNumber() throws IOException {
            if (this.slot < 3) {
                long nextNum;
                if ((nextNum = NumberList.this.readNumber(this.block, this.slot++)) == 0L) {
                    this.nextBlock();
                } else {
                    this.nextNumber = nextNum;
                }
            } else {
                this.nextBlock();
            }
        }

        private void nextBlock() throws IOException {
            long nextBlock = NumberList.this.getOffsetToNextBlock(this.block);
            if (nextBlock == 0L) {
                this.nextNumber = 0L;
                return;
            }
            this.block = NumberList.this.getBlock(nextBlock);
            this.slot = 0;
            this.nextNumber();
        }
    }
}

