/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfo;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbcopy.ColTypeMapper;
import net.sourceforge.squirrel_sql.plugins.dbcopy.I18NBaseObject;
import net.sourceforge.squirrel_sql.plugins.dbcopy.SessionInfoProvider;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.DBCopyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;
import net.sourceforge.squirrel_sql.plugins.dbcopy.util.ScriptWriter;
import org.hibernate.MappingException;

public class DBUtil
extends I18NBaseObject {
    private static final ILogger log = LoggerController.createLogger(DBUtil.class);
    private static DBCopyPreferenceBean _prefs = PreferencesManager.getPreferences();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DBUtil.class);
    private static final String TEST_TABLE_NAME = "dbcopytest";
    private static String lastStatement = null;
    private static String lastStatementValues = null;

    public static void setPreferences(DBCopyPreferenceBean bean) {
        _prefs = bean;
    }

    public static String getPKColumnString(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        List<String> pkColumns = DBUtil.getPKColumnList(sourceConn, ti);
        if (pkColumns == null || pkColumns.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("(");
        Iterator<String> i = pkColumns.iterator();
        while (i.hasNext()) {
            String columnName = i.next();
            sb.append(columnName);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static List<String> getPKColumnList(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        ArrayList<String> pkColumns = new ArrayList<String>();
        DatabaseMetaData md = sourceConn.getConnection().getMetaData();
        ResultSet rs = null;
        rs = md.supportsCatalogsInTableDefinitions() ? md.getPrimaryKeys(ti.getCatalogName(), null, ti.getSimpleName()) : (md.supportsSchemasInTableDefinitions() ? md.getPrimaryKeys(null, ti.getSchemaName(), ti.getSimpleName()) : md.getPrimaryKeys(null, null, ti.getSimpleName()));
        while (rs.next()) {
            String keyColumn = rs.getString(4);
            if (keyColumn == null) continue;
            pkColumns.add(keyColumn);
        }
        if (pkColumns.size() == 0) {
            return null;
        }
        return pkColumns;
    }

    public static Set<String> getForeignKeySQL(SessionInfoProvider prov, ITableInfo ti, ArrayList<ITableInfo> selectedTableInfos) throws SQLException, UserCancelledOperationException {
        HashSet<String> result = new HashSet<String>();
        ForeignKeyInfo[] keys = ti.getImportedKeys();
        if (keys == null) {
            return result;
        }
        for (ForeignKeyInfo fkInfo : keys) {
            String pkTableName = fkInfo.getPrimaryKeyTableName();
            String pkTableCol = fkInfo.getPrimaryKeyColumnName();
            String fkTableName = fkInfo.getForeignKeyTableName();
            String fkTableCol = fkInfo.getForeignKeyColumnName();
            String fkName = fkInfo.getForeignKeyName();
            if (!DBUtil.containsTable(selectedTableInfos, pkTableName)) {
                if (!log.isDebugEnabled()) continue;
                String msg = s_stringMgr.getString("DBUtil.error.missingtable", new String[]{fkTableName, fkTableCol, pkTableName, pkTableCol});
                log.debug((Object)msg);
                continue;
            }
            ISession destSession = prov.getDestSession();
            String destSchema = prov.getDestDatabaseObject().getSimpleName();
            String destCatalog = prov.getDestDatabaseObject().getCatalogName();
            if (DBUtil.tableHasForeignKey(destCatalog, destSchema, ti.getSimpleName(), fkInfo, prov)) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping FK (" + fkName + ") - table " + ti.getSimpleName() + " seems to already have it defined."));
                continue;
            }
            String fkTable = DBUtil.getQualifiedObjectName(destSession, destCatalog, destSchema, ti.getSimpleName(), 1);
            String pkTable = DBUtil.getQualifiedObjectName(destSession, destCatalog, destSchema, pkTableName, 1);
            StringBuilder tmp = new StringBuilder();
            tmp.append("ALTER TABLE ");
            tmp.append(fkTable);
            tmp.append(" ADD FOREIGN KEY (");
            tmp.append(fkTableCol);
            tmp.append(") REFERENCES ");
            tmp.append(pkTable);
            tmp.append("(");
            tmp.append(pkTableCol);
            tmp.append(")");
            result.add(tmp.toString());
        }
        return result;
    }

    public static boolean tableHasForeignKey(String destCatalog, String destSchema, String destTableName, ForeignKeyInfo fkInfo, SessionInfoProvider prov) {
        boolean result;
        block4: {
            result = false;
            try {
                SQLDatabaseMetaData md = prov.getDestSession().getSQLConnection().getSQLMetaData();
                ITableInfo[] tables = md.getTables(destCatalog, destSchema, destTableName, new String[]{"TABLE"}, null);
                if (tables != null && tables.length == 1) {
                    ForeignKeyInfo[] fks;
                    for (ForeignKeyInfo existingKey : fks = SQLUtilities.getImportedKeys((ITableInfo)tables[0], (SQLDatabaseMetaData)md)) {
                        if (!DBUtil.areEqual(existingKey, fkInfo)) continue;
                        result = true;
                        break block4;
                    }
                    break block4;
                }
                log.error((Object)("Couldn't find an exact match for destination table " + destTableName + " in schema " + destSchema + " and catalog " + destCatalog + ". Skipping FK constraint"));
            }
            catch (SQLException e) {
                log.error((Object)("Unexpected exception while attempting to determine if a table (" + destTableName + ") has a particular foreign " + "key"));
            }
        }
        return result;
    }

    private static boolean areEqual(ForeignKeyInfo fk1, ForeignKeyInfo fk2) {
        String fk1FKColumn = fk1.getForeignKeyColumnName();
        String fk2FKColumn = fk2.getForeignKeyColumnName();
        String fk1PKColumn = fk1.getPrimaryKeyColumnName();
        String fk2PKColumn = fk2.getPrimaryKeyColumnName();
        String fk1FKTable = fk1.getForeignKeyTableName();
        String fk2FKTable = fk2.getForeignKeyTableName();
        String fk1PKTable = fk1.getPrimaryKeyTableName();
        String fk2PKTable = fk2.getPrimaryKeyTableName();
        if (!fk1PKColumn.equals(fk2PKColumn)) {
            return false;
        }
        if (!fk1FKColumn.equals(fk2FKColumn)) {
            return false;
        }
        if (!fk1PKTable.equals(fk2PKTable)) {
            return false;
        }
        return fk1FKTable.equals(fk2FKTable);
    }

    private static boolean containsTable(List<ITableInfo> tableInfos, String table) {
        boolean result = false;
        for (ITableInfo ti : tableInfos) {
            if (!table.equalsIgnoreCase(ti.getSimpleName())) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(ISQLConnection con, String SQL, boolean writeSQL) throws SQLException {
        Statement stmt = null;
        int result = 0;
        try {
            stmt = con.createStatement();
            if (writeSQL) {
                ScriptWriter.write(SQL);
            }
            if (log.isDebugEnabled()) {
                String msg = s_stringMgr.getString("DBUtil.info.executeupdate", new Object[]{SQL});
                log.debug((Object)msg);
            }
            lastStatement = SQL;
            result = stmt.executeUpdate(SQL);
        }
        finally {
            SQLUtilities.closeStatement((Statement)stmt);
        }
        return result;
    }

    public static ResultSet executeQuery(ISession session, String sql) throws SQLException {
        ISQLConnection sqlcon = session.getSQLConnection();
        if (sqlcon == null || sql == null) {
            return null;
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = sqlcon.getConnection();
        try {
            if (DialectFactory.isMySQL((ISQLDatabaseMetaData)session.getMetaData())) {
                stmt = con.createStatement(1003, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
            } else if (DialectFactory.isTimesTen((ISQLDatabaseMetaData)session.getMetaData())) {
                stmt = con.createStatement();
                int fetchSize = _prefs.getSelectFetchSize();
                if (fetchSize > 128) {
                    log.info((Object)("executeQuery: TimesTen allows a maximum fetch size of 128.  Altering preferred fetch size from " + fetchSize + " to 128."));
                    fetchSize = 128;
                }
                stmt.setFetchSize(fetchSize);
            } else {
                stmt = con.createStatement();
                if (_prefs.getSelectFetchSize() > 0) {
                    stmt.setFetchSize(_prefs.getSelectFetchSize());
                }
            }
        }
        catch (SQLException e) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement(stmt);
            throw e;
        }
        if (log.isDebugEnabled()) {
            String msg = s_stringMgr.getString("DBUtil.info.executequery", new Object[]{sql});
            log.debug((Object)msg);
        }
        try {
            lastStatement = sql;
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            SQLUtilities.closeStatement((Statement)stmt);
            throw e;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int getTableCount(ISession session, String tableName) {
        ResultSet rs;
        int result;
        block4: {
            result = -1;
            rs = null;
            try {
                String sql = "select count(*) from " + tableName;
                rs = DBUtil.executeQuery(session, sql);
                if (!rs.next()) break block4;
                result = rs.getInt(1);
            }
            catch (Exception e) {
                SQLUtilities.closeResultSet(rs, (boolean)true);
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs, (boolean)true);
                    throw throwable;
                }
            }
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return result;
    }

    public static int getTableCount(ISession session, String catalog, String schema, String tableName, int sessionType) throws UserCancelledOperationException {
        String table = DBUtil.getQualifiedObjectName(session, catalog, schema, tableName, sessionType);
        return DBUtil.getTableCount(session, table);
    }

    public static ITableInfo getTableInfo(ISession session, String schema, String tableName) throws SQLException, MappingException, UserCancelledOperationException {
        ITableInfo[] tis;
        ISQLConnection con = session.getSQLConnection();
        if (con.getSQLMetaData().getDriverName().toLowerCase().startsWith("axion")) {
            schema = "";
        }
        String catalog = null;
        if (DialectFactory.isMySQL((ISQLDatabaseMetaData)session.getMetaData())) {
            catalog = schema;
            schema = null;
        }
        if (((tis = DBUtil.getTables(session, catalog, schema, tableName = tableName.trim())) == null || tis.length == 0) && (tis = DBUtil.getTables(session, null, schema, tableName = Character.isUpperCase(tableName.charAt(0)) ? tableName.toLowerCase() : tableName.toUpperCase())).length == 0) {
            tableName = Character.isUpperCase(tableName.charAt(0)) ? tableName.toLowerCase() : tableName.toUpperCase();
            tis = DBUtil.getTables(session, null, schema, tableName);
        }
        if (tis.length == 0) {
            String msg = s_stringMgr.getString("DBUtil.error.tablenotfound", new String[]{tableName, schema});
            throw new MappingException(msg);
        }
        if (tis.length > 1 && log.isDebugEnabled()) {
            log.debug((Object)("DBUtil.getTableInfo: found " + tis.length + " that matched " + "catalog=" + catalog + " schema=" + schema + " tableName=" + tableName));
        }
        return tis[0];
    }

    public static ITableInfo[] getTables(ISession session, String catalog, String schema, String tableName) {
        ITableInfo[] result = new ITableInfo[]{};
        try {
            SchemaInfo schemaInfo = session.getSchemaInfo();
            result = schemaInfo.getITableInfos(catalog, schema, tableName);
        }
        catch (Exception e) {
            log.error((Object)("Encountered unexpected exception when attempting to call schemaInfo.getTables with catalog = " + catalog + " schema = " + schema + " tableName = " + tableName));
        }
        if (result == null || result.length == 0) {
            SQLDatabaseMetaData d = session.getSQLConnection().getSQLMetaData();
            result = DBUtil.getTables(d, catalog, schema, tableName);
        }
        return result;
    }

    private static ITableInfo[] getTables(SQLDatabaseMetaData data, String catalog, String schema, String tableName) {
        ITableInfo[] result = new ITableInfo[]{};
        try {
            result = data.getTables(catalog, schema, tableName, null, null);
        }
        catch (Exception e) {
            log.error((Object)("Encountered unexpected exception when attempting to call SQLDatabaseMetaData.getTables with catalog = " + catalog + " schema = " + schema + " tableName = " + tableName));
        }
        return result;
    }

    public static boolean typesAreEquivalent(int sourceType, int destType) {
        boolean result = false;
        if (sourceType == destType) {
            result = true;
        }
        if (sourceType == 3 && destType == 2) {
            result = true;
        }
        if (sourceType == 2 && destType == 3) {
            result = true;
        }
        if (sourceType == 16 && destType == -7) {
            result = true;
        }
        if (sourceType == -7 && destType == 16) {
            result = true;
        }
        return result;
    }

    private static boolean handleNull(ResultSet rs, PreparedStatement ps, int index, int type) throws SQLException {
        boolean result = false;
        if (rs.wasNull()) {
            ps.setNull(index, type);
            result = true;
        }
        return result;
    }

    public static int replaceOtherDataType(TableColumnInfo colInfo, ISession session) throws MappingException {
        int colJdbcType = colInfo.getDataType();
        if (colJdbcType == 1111) {
            try {
                HibernateDialect dialect = DialectFactory.getDialect((ISQLDatabaseMetaData)session.getMetaData());
                String typeName = colInfo.getTypeName().toUpperCase();
                int parenIndex = typeName.indexOf("(");
                if (parenIndex != -1) {
                    typeName = typeName.substring(0, parenIndex);
                }
                colJdbcType = dialect.getJavaTypeForNativeType(colInfo.getTypeName());
            }
            catch (Exception e) {
                log.error((Object)("replaceOtherDataType: unexpected exception - " + e.getMessage()));
            }
        }
        return colJdbcType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceDistinctDataType(int colJdbcType, TableColumnInfo colInfo, ISession session) {
        if (colJdbcType == 2001 && DialectFactory.isPostgreSQL((ISQLDatabaseMetaData)session.getMetaData())) {
            PreparedStatement pstmt;
            block7: {
                Connection con = session.getSQLConnection().getConnection();
                pstmt = null;
                ResultSet rs = null;
                try {
                    String sql = "SELECT data_type FROM information_schema.columns where column_name = ? ";
                    if (colInfo.getSchemaName() != null) {
                        sql = sql + " and table_schema = ? ";
                    }
                    pstmt = con.prepareStatement(sql);
                    pstmt.setString(1, colInfo.getColumnName());
                    if (colInfo.getSchemaName() != null) {
                        pstmt.setString(2, colInfo.getSchemaName());
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block7;
                    String nativeTypeName = rs.getString(1);
                    colJdbcType = JDBCTypeMapper.getJdbcType((String)nativeTypeName.toUpperCase(), (int)colJdbcType);
                }
                catch (SQLException e) {
                    try {
                        log.error((Object)("replaceDistinctDataType: Unexpected exception - " + e), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtilities.closeStatement(pstmt);
                        throw throwable;
                    }
                    SQLUtilities.closeStatement((Statement)pstmt);
                }
            }
            SQLUtilities.closeStatement((Statement)pstmt);
        }
        return colJdbcType;
    }

    public static String bindVariable(PreparedStatement ps, int sourceColType, int destColType, int index, ResultSet rs) throws SQLException {
        String result = "null";
        block1 : switch (sourceColType) {
            case 2003: {
                Array arrayVal = rs.getArray(index);
                result = DBUtil.getValue(arrayVal);
                ps.setArray(index, arrayVal);
                break;
            }
            case -5: {
                long bigintVal = rs.getLong(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Long.toString(bigintVal);
                ps.setLong(index, bigintVal);
                break;
            }
            case -2: {
                result = DBUtil.bindBlobVar(ps, index, rs, destColType);
                break;
            }
            case -7: {
                boolean bitValue = rs.getBoolean(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Boolean.toString(bitValue);
                ps.setBoolean(index, bitValue);
                break;
            }
            case 2004: {
                result = DBUtil.bindBlobVar(ps, index, rs, destColType);
                break;
            }
            case 16: {
                boolean booleanValue = rs.getBoolean(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Boolean.toString(booleanValue);
                switch (destColType) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        ps.setInt(index, booleanValue ? 1 : 0);
                        break block1;
                    }
                    case 6: {
                        ps.setFloat(index, booleanValue ? 1.0f : 0.0f);
                        break block1;
                    }
                    case 8: {
                        ps.setDouble(index, booleanValue ? 1.0 : 0.0);
                        break block1;
                    }
                    case 1: 
                    case 12: {
                        ps.setString(index, booleanValue ? "1" : "0");
                        break block1;
                    }
                }
                ps.setBoolean(index, booleanValue);
                break;
            }
            case 1: {
                String charValue = rs.getString(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = charValue;
                ps.setString(index, charValue);
                break;
            }
            case 2005: {
                DBUtil.bindClobVar(ps, index, rs, destColType);
                break;
            }
            case 70: {
                Object datalinkValue = rs.getObject(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(datalinkValue);
                ps.setObject(index, datalinkValue);
                break;
            }
            case 91: {
                Date dateValue = rs.getDate(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(dateValue);
                ps.setDate(index, dateValue);
                break;
            }
            case 3: {
                BigDecimal decimalValue = rs.getBigDecimal(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(decimalValue);
                ps.setBigDecimal(index, decimalValue);
                break;
            }
            case 2001: {
                Object distinctValue = rs.getObject(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(distinctValue);
                ps.setObject(index, distinctValue);
                break;
            }
            case 8: {
                double doubleValue = rs.getDouble(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Double.toString(doubleValue);
                ps.setDouble(index, doubleValue);
                break;
            }
            case 6: {
                double floatValue = rs.getDouble(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Double.toString(floatValue);
                ps.setDouble(index, floatValue);
                break;
            }
            case 4: {
                int integerValue = rs.getInt(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Integer.toString(integerValue);
                ps.setInt(index, integerValue);
                break;
            }
            case 2000: {
                Object objectValue = rs.getObject(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(objectValue);
                ps.setObject(index, objectValue);
                break;
            }
            case -4: {
                result = DBUtil.bindBlobVar(ps, index, rs, destColType);
                break;
            }
            case -1: {
                String longvarcharValue = rs.getString(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = longvarcharValue;
                ps.setString(index, longvarcharValue);
                break;
            }
            case 0: {
                ps.setNull(index, 0);
                break;
            }
            case 2: {
                BigDecimal numericValue = rs.getBigDecimal(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(numericValue);
                ps.setBigDecimal(index, numericValue);
                break;
            }
            case 1111: {
                String testValue = rs.getString(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                try {
                    Double.parseDouble(testValue);
                    double numberValue = rs.getDouble(index);
                    ps.setDouble(index, numberValue);
                }
                catch (SQLException e) {
                    byte[] otherValue = rs.getBytes(index);
                    result = DBUtil.getValue(otherValue);
                    ps.setBytes(index, otherValue);
                }
                break;
            }
            case 7: {
                float realValue = rs.getFloat(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Float.toString(realValue);
                ps.setFloat(index, realValue);
                break;
            }
            case 2006: {
                Ref refValue = rs.getRef(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(refValue);
                ps.setRef(index, refValue);
                break;
            }
            case 5: {
                short smallintValue = rs.getShort(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Short.toString(smallintValue);
                ps.setShort(index, smallintValue);
                break;
            }
            case 2002: {
                Object structValue = rs.getObject(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(structValue);
                ps.setObject(index, structValue);
                break;
            }
            case 92: {
                Time timeValue = rs.getTime(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(timeValue);
                ps.setTime(index, timeValue);
                break;
            }
            case 93: {
                Timestamp timestampValue = rs.getTimestamp(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = DBUtil.getValue(timestampValue);
                ps.setTimestamp(index, timestampValue);
                break;
            }
            case -6: {
                byte tinyintValue = rs.getByte(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = Byte.toString(tinyintValue);
                ps.setByte(index, tinyintValue);
                break;
            }
            case -3: {
                result = DBUtil.bindBlobVar(ps, index, rs, destColType);
                break;
            }
            case 12: {
                String varcharValue = rs.getString(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = varcharValue;
                ps.setString(index, varcharValue);
                break;
            }
            default: {
                String msg = s_stringMgr.getString("DBUtil.error.unknowntype", new Object[]{sourceColType});
                log.error((Object)msg);
                String value = rs.getString(index);
                if (DBUtil.handleNull(rs, ps, index, destColType)) break;
                result = value;
                ps.setString(index, value);
            }
        }
        return result;
    }

    private static String bindClobVar(PreparedStatement ps, int index, ResultSet rs, int type) throws SQLException {
        String result = "null";
        if (_prefs.isUseFileCaching()) {
            try {
                DBUtil.bindClobVarInFile(ps, index, rs, type);
            }
            catch (Exception e) {
                String msg = s_stringMgr.getString("DBUtil.error.bindclobfailure");
                log.error((Object)msg, (Throwable)e);
                result = DBUtil.bindClobVarInMemory(ps, index, rs, type);
            }
        } else {
            result = DBUtil.bindClobVarInMemory(ps, index, rs, type);
        }
        return result;
    }

    private static String bindBlobVar(PreparedStatement ps, int index, ResultSet rs, int type) throws SQLException {
        String result = "null";
        if (_prefs.isUseFileCaching()) {
            try {
                DBUtil.bindBlobVarInFile(ps, index, rs, type);
            }
            catch (Exception e) {
                String msg = s_stringMgr.getString("DBUtil.error.bindblobfailure");
                log.error((Object)msg, (Throwable)e);
                result = DBUtil.bindBlobVarInMemory(ps, index, rs, type);
            }
        } else {
            result = DBUtil.bindBlobVarInMemory(ps, index, rs, type);
        }
        return result;
    }

    private static String bindClobVarInMemory(PreparedStatement ps, int index, ResultSet rs, int type) throws SQLException {
        String clobValue = rs.getString(index);
        if (rs.wasNull()) {
            ps.setNull(index, type);
            return "null";
        }
        String result = DBUtil.getValue(clobValue);
        if (log.isDebugEnabled() && clobValue != null) {
            String msg = s_stringMgr.getString("DBUtil.info.bindclobmem", new Object[]{clobValue.length()});
            log.debug((Object)msg);
        }
        ps.setString(index, clobValue);
        return result;
    }

    private static String bindBlobVarInMemory(PreparedStatement ps, int index, ResultSet rs, int type) throws SQLException {
        byte[] blobValue = rs.getBytes(index);
        if (rs.wasNull()) {
            ps.setNull(index, type);
            return "null";
        }
        String result = DBUtil.getValue(blobValue);
        if (log.isDebugEnabled() && blobValue != null) {
            String msg = s_stringMgr.getString("DBUtil.info.bindblobmem", new Object[]{blobValue.length});
            log.debug((Object)msg);
        }
        ps.setBytes(index, blobValue);
        return result;
    }

    private static void bindClobVarInFile(PreparedStatement ps, int index, ResultSet rs, int type) throws IOException, SQLException {
        InputStream is = rs.getAsciiStream(index);
        if (rs.wasNull()) {
            ps.setNull(index, type);
            return;
        }
        long millis = System.currentTimeMillis();
        File f = File.createTempFile("clob", "" + millis);
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        if (log.isDebugEnabled()) {
            String msg = s_stringMgr.getString("DBUtil.info.bindclobfile", new Object[]{f.getAbsolutePath()});
            log.debug((Object)msg);
        }
        byte[] buf = new byte[_prefs.getFileCacheBufferSize()];
        int length = 0;
        int total = 0;
        while ((length = is.read(buf)) >= 0) {
            if (log.isDebugEnabled()) {
                String msg = s_stringMgr.getString("DBUtil.info.bindcloblength", new Object[]{length});
                log.debug((Object)msg);
            }
            fos.write(buf, 0, length);
            total += length;
        }
        fos.close();
        FileInputStream fis = new FileInputStream(f);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ps.setAsciiStream(index, (InputStream)bis, total);
    }

    private static void bindBlobVarInFile(PreparedStatement ps, int index, ResultSet rs, int type) throws IOException, SQLException {
        InputStream is = rs.getBinaryStream(index);
        if (rs.wasNull()) {
            ps.setNull(index, type);
            return;
        }
        long millis = System.currentTimeMillis();
        File f = File.createTempFile("blob", "" + millis);
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        if (log.isDebugEnabled()) {
            String msg = s_stringMgr.getString("DBUtil.info.bindblobfile", new Object[]{f.getAbsolutePath()});
            log.debug((Object)msg);
        }
        byte[] buf = new byte[_prefs.getFileCacheBufferSize()];
        int length = 0;
        int total = 0;
        while ((length = is.read(buf)) >= 0) {
            if (log.isDebugEnabled()) {
                String msg = s_stringMgr.getString("DBUtil.info.bindbloblength", new Object[]{length});
                log.debug((Object)msg);
            }
            fos.write(buf, 0, length);
            total += length;
        }
        fos.close();
        FileInputStream fis = new FileInputStream(f);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ps.setBinaryStream(index, (InputStream)bis, total);
    }

    private static String getValue(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "null";
    }

    public static int getColumnType(ISQLConnection con, ITableInfo ti, String columnName) throws SQLException {
        int result = -1;
        if (ti != null) {
            TableColumnInfo[] tciArr = con.getSQLMetaData().getColumnInfo(ti);
            for (int i = 0; i < tciArr.length; ++i) {
                if (!tciArr[i].getColumnName().equalsIgnoreCase(columnName)) continue;
                result = tciArr[i].getDataType();
                break;
            }
        }
        return result;
    }

    public static int[] getColumnTypes(ISQLConnection con, ITableInfo ti, String[] colNames) throws SQLException {
        TableColumnInfo[] tciArr = con.getSQLMetaData().getColumnInfo(ti);
        int[] result = new int[tciArr.length];
        for (int i = 0; i < tciArr.length; ++i) {
            boolean found = false;
            for (int j = 0; j < colNames.length && !found; ++j) {
                String columnName = colNames[j];
                if (!tciArr[i].getColumnName().equalsIgnoreCase(columnName)) continue;
                result[i] = tciArr[i].getDataType();
                found = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableHasPrimaryKey(ISQLConnection con, ITableInfo ti) throws SQLException {
        boolean result = false;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = con.getConnection().getMetaData();
            String cat = ti.getCatalogName();
            String schema = ti.getSchemaName();
            String tableName = ti.getSimpleName();
            rs = md.getPrimaryKeys(cat, schema, tableName);
            if (rs.next()) {
                result = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        return result;
    }

    public static boolean isKeyword(ISession session, String data) {
        return session.getSchemaInfo().isKeyword(data);
    }

    public static void deleteDataInExistingTable(ISession session, String catalogName, String schemaName, String tableName) throws SQLException, UserCancelledOperationException {
        ISQLConnection con = session.getSQLConnection();
        boolean useTrunc = PreferencesManager.getPreferences().isUseTruncate();
        String fullTableName = DBUtil.getQualifiedObjectName(session, catalogName, schemaName, tableName, 1);
        String truncSQL = "TRUNCATE TABLE " + fullTableName;
        String deleteSQL = "DELETE FROM " + fullTableName;
        try {
            if (useTrunc) {
                DBUtil.executeUpdate(con, truncSQL, true);
            } else {
                DBUtil.executeUpdate(con, deleteSQL, true);
            }
        }
        catch (SQLException e) {
            if (useTrunc) {
                DBUtil.executeUpdate(con, deleteSQL, true);
            }
            throw e;
        }
    }

    public static void sanityCheckPreferences(ISession destSession) throws MappingException {
        if (DialectFactory.isFirebird((ISQLDatabaseMetaData)destSession.getMetaData()) && !PreferencesManager.getPreferences().isCommitAfterTableDefs()) {
            String msg = s_stringMgr.getString("DBUtil.error.firebirdcommit");
            throw new MappingException(msg);
        }
    }

    public static String getCreateTableSql(SessionInfoProvider prov, ITableInfo ti, String destTableName, String destSchema, String destCatalog) throws SQLException, MappingException, UserCancelledOperationException {
        ISession sourceSession = prov.getSourceSession();
        String sourceSchema = prov.getSourceDatabaseObjects().get(0).getSchemaName();
        String sourceCatalog = prov.getSourceDatabaseObjects().get(0).getCatalogName();
        String sourceTableName = DBUtil.getQualifiedObjectName(sourceSession, sourceCatalog, sourceSchema, ti.getSimpleName(), 0);
        ISession destSession = prov.getDestSession();
        String destinationTableName = DBUtil.getQualifiedObjectName(destSession, destCatalog, destSchema, destTableName, 1);
        StringBuilder result = new StringBuilder("CREATE TABLE ");
        result.append(destinationTableName);
        result.append(" ( ");
        result.append("\n");
        TableColumnInfo colInfo = null;
        try {
            String pkString;
            ISQLConnection sourceCon = prov.getSourceSession().getSQLConnection();
            TableColumnInfo[] colInfoArr = sourceCon.getSQLMetaData().getColumnInfo(ti);
            if (colInfoArr.length == 0) {
                String msg = s_stringMgr.getString("DBUtil.error.nocolumns", new String[]{ti.getSimpleName(), ti.getSchemaName()});
                throw new MappingException(msg);
            }
            for (int i = 0; i < colInfoArr.length; ++i) {
                colInfo = colInfoArr[i];
                result.append("\t");
                String columnSql = DBUtil.getColumnSql(prov, colInfo, sourceTableName, destinationTableName);
                result.append(columnSql);
                if (i >= colInfoArr.length - 1) continue;
                result.append(",\n");
            }
            if (_prefs.isCopyPrimaryKeys() && !DialectFactory.isAxion((ISQLDatabaseMetaData)sourceSession.getMetaData()) && (pkString = DBUtil.getPKColumnString(sourceCon, ti)) != null) {
                result.append(",\n\tPRIMARY KEY ");
                result.append(pkString);
            }
            result.append(")");
        }
        catch (MappingException e) {
            if (colInfo != null) {
                String msg = s_stringMgr.getString("DBUtil.error.maptype", new String[]{destinationTableName, colInfo.getColumnName()});
                log.error((Object)msg, (Throwable)e);
            }
            throw e;
        }
        return result.toString();
    }

    public static String getColumnList(TableColumnInfo[] colInfoArr) throws SQLException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < colInfoArr.length; ++i) {
            TableColumnInfo colInfo = colInfoArr[i];
            String columnName = colInfo.getColumnName();
            result.append(columnName);
            if (i >= colInfoArr.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String getColumnSql(SessionInfoProvider prov, TableColumnInfo colInfo, String sourceTableName, String destTableName) throws UserCancelledOperationException, MappingException {
        String typeName;
        String columnName = colInfo.getColumnName();
        if (_prefs.isCheckKeywords()) {
            DBUtil.checkKeyword(prov.getDestSession(), destTableName, columnName);
        }
        String columnDefinitionString = (typeName = ColTypeMapper.mapColType(prov.getSourceSession(), prov.getDestSession(), colInfo, sourceTableName, destTableName)).contains("(") ? columnName + " " + typeName : SQLUtilities.createColumnDefinitionString((String)columnName, (String)typeName, (int)colInfo.getColumnSize(), (int)colInfo.getDecimalDigits());
        StringBuilder result = new StringBuilder(columnDefinitionString);
        boolean notNullable = colInfo.isNullable().equalsIgnoreCase("NO");
        if (notNullable) {
            result.append(" NOT NULL");
        } else {
            ISession destSession = prov.getDestSession();
            HibernateDialect d = DialectFactory.getDialect((int)1, (JFrame)destSession.getApplication().getMainFrame(), (ISQLDatabaseMetaData)destSession.getMetaData());
            String nullString = d.getNullColumnString().toUpperCase();
            result.append(nullString);
        }
        return result.toString();
    }

    public static void checkKeyword(ISession session, String table, String column) throws MappingException {
        if (DBUtil.isKeyword(session, column)) {
            String message = DBUtil.getMessage("DBUtil.mappingErrorKeyword", new String[]{table, column});
            throw new MappingException(message);
        }
    }

    public static String getColumnName(ISQLConnection sourceConn, ITableInfo ti, int column) throws SQLException {
        TableColumnInfo[] infoArr = sourceConn.getSQLMetaData().getColumnInfo(ti);
        TableColumnInfo colInfo = infoArr[column];
        return colInfo.getColumnName();
    }

    public static String[] getColumnNames(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        TableColumnInfo[] infoArr = sourceConn.getSQLMetaData().getColumnInfo(ti);
        String[] result = new String[infoArr.length];
        for (int i = 0; i < result.length; ++i) {
            TableColumnInfo colInfo = infoArr[i];
            result[i] = colInfo.getColumnName();
        }
        return result;
    }

    public static String getSelectQuery(SessionInfoProvider prov, String columnList, ITableInfo ti) throws SQLException, UserCancelledOperationException {
        StringBuilder result = new StringBuilder("select ");
        result.append(columnList);
        result.append(" from ");
        ISession sourceSession = prov.getSourceSession();
        String tableName = DBUtil.getQualifiedObjectName(sourceSession, ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 0);
        result.append(tableName);
        return result.toString();
    }

    public static String getInsertSQL(SessionInfoProvider prov, String columnList, ITableInfo ti, int columnCount) throws SQLException, UserCancelledOperationException {
        StringBuilder result = new StringBuilder();
        result.append("insert into ");
        String destSchema = DBUtil.getSchemaNameFromDbObject(prov.getDestDatabaseObject());
        String destCatalog = prov.getDestDatabaseObject().getCatalogName();
        ISession destSession = prov.getDestSession();
        result.append(DBUtil.getQualifiedObjectName(destSession, destCatalog, destSchema, ti.getSimpleName(), 1));
        result.append(" ( ");
        result.append(columnList);
        result.append(" ) values ( ");
        result.append(DBUtil.getQuestionMarks(columnCount));
        result.append(" )");
        return result.toString();
    }

    public static boolean isBinaryType(TableColumnInfo columnInfo) {
        boolean result = false;
        int type = columnInfo.getDataType();
        if (type == -2 || type == 2004 || type == -4 || type == -3) {
            result = true;
        }
        return result;
    }

    public static String getQualifiedObjectName(ISession session, String catalogName, String schemaName, String objectName, int sessionType) {
        String catalog = catalogName;
        String schema = schemaName;
        String object = objectName;
        if (sessionType == 1) {
            catalog = DBUtil.fixCase(session, catalogName);
            schema = DBUtil.fixCase(session, schemaName);
            object = DBUtil.fixCase(session, objectName);
        }
        ISQLDatabaseMetaData md = session.getMetaData();
        boolean useSchema = true;
        boolean useCatalog = true;
        try {
            useCatalog = md.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException e) {
            log.info((Object)"Encountered unexpected exception while attempting to determine if catalogs are used in table definitions");
        }
        try {
            useSchema = md.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            log.info((Object)"Encountered unexpected exception while attempting to determine if schemas are used in table definitions");
        }
        if (!useCatalog && !useSchema) {
            return object;
        }
        if ((catalog == null || catalog.equals("")) && (schema == null || schema.equals(""))) {
            return object;
        }
        StringBuilder result = new StringBuilder();
        if (useCatalog && catalog != null && !catalog.equals("")) {
            result.append(catalog);
            result.append(DBUtil.getCatSep(session));
        }
        if (useSchema && schema != null && !schema.equals("")) {
            result.append(schema);
            result.append(".");
        }
        result.append(object);
        return result.toString();
    }

    public static String getCatSep(ISession session) {
        String catsep = ".";
        try {
            ISQLDatabaseMetaData md = session.getMetaData();
            catsep = md.getCatalogSeparator();
        }
        catch (SQLException e) {
            log.error((Object)("getCatSep: Unexpected Exception - " + e.getMessage()), (Throwable)e);
        }
        return catsep;
    }

    public static String fixCase(ISession session, String identifier) {
        if (identifier == null || identifier.equals("")) {
            return identifier;
        }
        try {
            DatabaseMetaData md = session.getSQLConnection().getConnection().getMetaData();
            if (md.storesMixedCaseIdentifiers()) {
                return identifier;
            }
            if (md.storesUpperCaseIdentifiers()) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("fixCase: unexpected exception: " + e.getMessage()));
            }
            return identifier;
        }
    }

    private static String getQuestionMarks(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append("?");
            if (i >= count - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static int getColumnCount(ISQLConnection sourceConn, ITableInfo ti) throws SQLException {
        return sourceConn.getSQLMetaData().getColumnInfo(ti).length;
    }

    public static int getColumnType(ISQLConnection con, ITableInfo ti, int column) throws SQLException {
        TableColumnInfo[] infoArr = con.getSQLMetaData().getColumnInfo(ti);
        TableColumnInfo colInfo = infoArr[column];
        return colInfo.getDataType();
    }

    public static int[] getColumnTypes(ISQLConnection con, ITableInfo ti) throws SQLException {
        TableColumnInfo[] infoArr = con.getSQLMetaData().getColumnInfo(ti);
        int[] result = new int[infoArr.length];
        for (int i = 0; i < result.length; ++i) {
            TableColumnInfo colInfo = infoArr[i];
            result[i] = colInfo.getDataType();
        }
        return result;
    }

    public static void validateColumnNames(ITableInfo ti, SessionInfoProvider prov) throws MappingException, UserCancelledOperationException {
        if (prov == null) {
            return;
        }
        ISession sourceSession = prov.getSourceSession();
        ISession destSession = prov.getDestSession();
        if (sourceSession == null || destSession == null) {
            return;
        }
        ISQLConnection sourceCon = sourceSession.getSQLConnection();
        ISQLConnection con = destSession.getSQLConnection();
        TableColumnInfo[] colInfoArr = null;
        try {
            colInfoArr = sourceCon.getSQLMetaData().getColumnInfo(ti);
        }
        catch (SQLException e) {
            return;
        }
        for (int colIdx = 0; colIdx < colInfoArr.length; ++colIdx) {
            TableColumnInfo colInfo = colInfoArr[colIdx];
            IDatabaseObjectInfo selectedDestObj = prov.getDestDatabaseObject();
            String schema = selectedDestObj.getSimpleName();
            String catalog = selectedDestObj.getCatalogName();
            String tableName = DBUtil.getQualifiedObjectName(destSession, catalog, schema, TEST_TABLE_NAME, 1);
            StringBuilder sql = new StringBuilder("CREATE TABLE ");
            sql.append(tableName);
            sql.append(" ( ");
            sql.append(colInfo.getColumnName());
            sql.append(" CHAR(10) )");
            boolean cascade = DialectFactory.isFrontBase((ISQLDatabaseMetaData)destSession.getMetaData());
            try {
                DBUtil.dropTable(TEST_TABLE_NAME, schema, catalog, destSession, cascade, 1);
                DBUtil.executeUpdate(con, sql.toString(), false);
                continue;
            }
            catch (SQLException e) {
                String message = DBUtil.getMessage("DBUtil.mappingErrorKeyword", new String[]{ti.getSimpleName(), colInfo.getColumnName()});
                log.error((Object)message, (Throwable)e);
                throw new MappingException(message);
            }
            finally {
                DBUtil.dropTable(tableName, schema, catalog, destSession, cascade, 1);
            }
        }
    }

    public static boolean dropTable(String tableName, String schemaName, String catalogName, ISession session, boolean cascade, int sessionType) throws UserCancelledOperationException {
        boolean result = false;
        ISQLConnection con = session.getSQLConnection();
        String table = DBUtil.getQualifiedObjectName(session, catalogName, schemaName, tableName, sessionType);
        String dropsql = "DROP TABLE " + table;
        if (cascade) {
            dropsql = dropsql + " CASCADE";
        }
        try {
            DBUtil.executeUpdate(con, dropsql, false);
            result = true;
        }
        catch (SQLException e) {
            // empty catch block
        }
        return result;
    }

    public static boolean sameDatabaseType(ISession session1, ISession session2) {
        String driver2ClassName;
        boolean result = false;
        String driver1ClassName = session1.getDriver().getDriverClassName();
        if (driver1ClassName.equals(driver2ClassName = session2.getDriver().getDriverClassName())) {
            result = true;
        }
        return result;
    }

    public static String getMaxColumnLengthSQL(ISession sourceSession, TableColumnInfo colInfo, String tableName, boolean tableNameIsQualified) throws UserCancelledOperationException {
        String maxFunction;
        StringBuilder result = new StringBuilder();
        HibernateDialect dialect = DialectFactory.getDialect((int)0, (JFrame)sourceSession.getApplication().getMainFrame(), (ISQLDatabaseMetaData)sourceSession.getMetaData());
        String lengthFunction = dialect.getLengthFunction(colInfo.getDataType());
        if (lengthFunction == null) {
            log.error((Object)("Length function is null for dialect=" + dialect.getClass().getName() + ". Using 'length'"));
            lengthFunction = "length";
        }
        if ((maxFunction = dialect.getMaxFunction()) == null) {
            log.error((Object)("Max function is null for dialect=" + dialect.getClass().getName() + ". Using 'max'"));
            maxFunction = "max";
        }
        result.append("select ");
        result.append(maxFunction);
        result.append("(");
        result.append(lengthFunction);
        result.append("(");
        result.append(colInfo.getColumnName());
        result.append(")) from ");
        String table = tableName;
        if (!tableNameIsQualified) {
            table = DBUtil.getQualifiedObjectName(sourceSession, colInfo.getCatalogName(), colInfo.getSchemaName(), tableName, 0);
        }
        result.append(table);
        return result.toString();
    }

    public static void setLastStatement(String lastStatement) {
        DBUtil.lastStatement = lastStatement;
    }

    public static String getLastStatement() {
        return lastStatement;
    }

    public static void setLastStatementValues(String values) {
        lastStatementValues = values;
    }

    public static String getLastStatementValues() {
        return lastStatementValues;
    }

    public static List<ITableInfo> convertObjectToTableList(List<IDatabaseObjectInfo> objectInfoList) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (IDatabaseObjectInfo info : objectInfoList) {
            result.add((ITableInfo)info);
        }
        return result;
    }

    public static List<ITableInfo> convertObjectArrayToTableList(IDatabaseObjectInfo[] objectInfoArr) {
        ArrayList<ITableInfo> selectedTables = new ArrayList<ITableInfo>();
        for (int i = 0; i < objectInfoArr.length; ++i) {
            selectedTables.add((ITableInfo)objectInfoArr[i]);
        }
        return selectedTables;
    }

    public static List<IDatabaseObjectInfo> convertTableToObjectList(List<ITableInfo> tableInfoList) {
        ArrayList<IDatabaseObjectInfo> result = new ArrayList<IDatabaseObjectInfo>();
        for (ITableInfo info : tableInfoList) {
            result.add((IDatabaseObjectInfo)info);
        }
        return result;
    }

    public static String getSchemaNameFromDbObject(IDatabaseObjectInfo dbObject) {
        String destSchema = dbObject.getDatabaseObjectType().equals(DatabaseObjectType.SCHEMA) ? dbObject.getSimpleName() : dbObject.getSchemaName();
        return destSchema;
    }

    public static IDatabaseObjectInfo getSchemaFromDbObject(IDatabaseObjectInfo dbObject, SchemaInfo schemaInfo) {
        if (dbObject.getDatabaseObjectType().equals(DatabaseObjectType.SCHEMA)) {
            return dbObject;
        }
        return new DatabaseObjectInfo(dbObject.getCatalogName(), dbObject.getSchemaName(), dbObject.getSimpleName(), DatabaseObjectType.SCHEMA, (ISQLDatabaseMetaData)schemaInfo.getSQLDatabaseMetaData());
    }
}

