/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Query;
import org.jpl7.Term;
import org.jpl7.Variable;
import org.jpl7.fli.term_t;

public final class Util {
    public static Term termArrayToList(Term[] termArray) {
        Term term = JPL.LIST_NIL;
        for (int i = termArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{termArray[i], term});
        }
        return term;
    }

    public static String toString(Map<String, Term> map) {
        if (map == null) {
            return "[no solution]";
        }
        Iterator<String> iterator = map.keySet().iterator();
        String string = "Bindings: ";
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            string = string + string2 + "=" + map.get(string2).toString() + "; ";
        }
        return string;
    }

    public static Map<term_t, Variable> namevarsToMap(Term term) {
        try {
            HashMap<term_t, Variable> hashMap = new HashMap<term_t, Variable>();
            while (term.arity() == 2 && (term.name().equals("[|]") || term.name().equals(".")) && term.arg(1).hasFunctor("=", 2)) {
                hashMap.put(((Variable)term.arg((int)1).arg((int)2)).term_, new Variable(term.arg(1).arg(1).name()));
                term = term.arg(2);
            }
            return hashMap;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static Term textToTerm(String string) {
        Query query = new Query(new Compound("atom_to_term", new Term[]{new Atom(string), new Variable("Term"), new Variable("NVdict")}));
        query.open();
        Map<String, Term> map = query.getSubstWithNameVars();
        if (map != null) {
            query.close();
            return map.get("Term");
        }
        return null;
    }

    public static Term textParamsToTerm(String string, Term[] termArray) {
        return Util.textToTerm(string).putParams(termArray);
    }

    public static Term stringArrayToList(String[] stringArray) {
        Term term = JPL.LIST_NIL;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Atom(stringArray[i]), term});
        }
        return term;
    }

    public static Term intArrayToList(int[] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Integer(nArray[i]), term});
        }
        return term;
    }

    public static Term intArrayArrayToList(int[][] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{Util.intArrayToList(nArray[i]), term});
        }
        return term;
    }

    public static final boolean isList(Term term) {
        return Util.listToLength(term) >= 0;
    }

    public static int listToLength(Term term) {
        int n = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            ++n;
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? n : -1;
    }

    public static Term[] listToTermArray(Term term) {
        try {
            int n = Util.listToLength(term);
            Term[] termArray = new Term[n];
            for (int i = 0; i < n; ++i) {
                termArray[i] = term.arg(1);
                term = term.arg(2);
            }
            return termArray;
        }
        catch (JPLException jPLException) {
            throw new JPLException("term is not a proper list");
        }
    }

    public static String[] atomListToStringArray(Term term) {
        int n = Util.listToLength(term);
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            Term term3 = term2.arg(1);
            if (!term3.isAtom()) {
                return null;
            }
            stringArray[n2++] = term3.name();
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? stringArray : null;
    }
}

