/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Util;
import org.jpl7.Variable;
import org.jpl7.fli.DoubleHolder;
import org.jpl7.fli.Int64Holder;
import org.jpl7.fli.IntHolder;
import org.jpl7.fli.ObjectHolder;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.StringHolder;
import org.jpl7.fli.term_t;

public abstract class Term {
    protected Term() {
    }

    public Term arg(int n) {
        throw new JPLException("arg(int) is undefined for " + this.typeName() + " instances");
    }

    public Term[] args() {
        throw new JPLException("args() is undefined for " + this.typeName());
    }

    public int arity() {
        return 0;
    }

    public String atomType() {
        throw new JPLException("atomType() is undefined for " + this.typeName());
    }

    public BigInteger bigValue() {
        throw new JPLException("bigValue() is undefined for " + this.typeName());
    }

    public double doubleValue() {
        throw new JPLException("doubleValue() is undefined for " + this.typeName());
    }

    public float floatValue() {
        throw new JPLException("floatValue() is undefined for " + this.typeName());
    }

    protected void getSubst(Map<String, Term> map, Map<term_t, Variable> map2) {
    }

    protected static void getSubsts(Map<String, Term> map, Map<term_t, Variable> map2, Term[] termArray) {
        for (int i = 0; i < termArray.length; ++i) {
            termArray[i].getSubst(map, map2);
        }
    }

    protected static Term getTerm(Map<term_t, Variable> map, term_t term_t2) {
        switch (Prolog.term_type(term_t2)) {
            case 1: {
                for (term_t term_t3 : map.keySet()) {
                    if (Prolog.compare(term_t3, term_t2) != 0) continue;
                    return map.get(term_t3);
                }
                Variable variable = new Variable();
                variable.term_ = term_t2;
                map.put(term_t2, variable);
                return variable;
            }
            case 2: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_atom_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value, "text");
            }
            case 5: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_string_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value, "string");
            }
            case 3: {
                Int64Holder int64Holder = new Int64Holder();
                if (Prolog.get_integer(term_t2, int64Holder)) {
                    return new Integer(int64Holder.value);
                }
                StringHolder stringHolder = new StringHolder();
                if (Prolog.get_integer_big(term_t2, stringHolder)) {
                    return new Integer(new BigInteger(stringHolder.value));
                }
                return new Integer(-3L);
            }
            case 4: {
                DoubleHolder doubleHolder = new DoubleHolder();
                Prolog.get_float(term_t2, doubleHolder);
                return new Float(doubleHolder.value);
            }
            case 6: 
            case 9: {
                StringHolder stringHolder = new StringHolder();
                IntHolder intHolder = new IntHolder();
                Prolog.get_name_arity(term_t2, stringHolder, intHolder);
                Term[] termArray = new Term[intHolder.value];
                for (int i = 1; i <= intHolder.value; ++i) {
                    term_t term_t4 = Prolog.new_term_ref();
                    Prolog.get_arg(i, term_t2, term_t4);
                    termArray[i - 1] = Term.getTerm(map, term_t4);
                }
                return new Compound(stringHolder.value, termArray);
            }
            case 7: {
                return JPL.LIST_NIL;
            }
            case 8: {
                ObjectHolder objectHolder = new ObjectHolder();
                if (Prolog.get_jref_object(term_t2, objectHolder)) {
                    if (objectHolder.value == null) {
                        return JPL.JNULL;
                    }
                    return new JRef(objectHolder.value);
                }
                throw new JPLException("unsupported blob type passed from Prolog");
            }
        }
        throw new JPLException("unknown term type=" + Prolog.term_type(term_t2));
    }

    protected static Term getTerm(term_t term_t2) {
        return Term.getTerm(new HashMap<term_t, Variable>(), term_t2);
    }

    public boolean hasFunctor(String string, int n) {
        return false;
    }

    public boolean hasFunctor(long l, int n) {
        return false;
    }

    public boolean hasFunctor(BigInteger bigInteger, int n) {
        return false;
    }

    public boolean hasFunctor(double d, int n) {
        return false;
    }

    public int intValue() {
        throw new JPLException("intValue() is undefined for " + this.typeName());
    }

    public final boolean isAtom() {
        return this instanceof Atom;
    }

    protected boolean isAtomOfNameType(String string, String string2) {
        return false;
    }

    public boolean isBig() {
        throw new JPLException("isBig() is undefined for " + this.typeName());
    }

    public boolean isBigInteger() {
        return this instanceof Integer && ((Integer)this).isBig();
    }

    public final boolean isCompound() {
        return this instanceof Compound;
    }

    public final boolean isFloat() {
        return this instanceof Float;
    }

    public final boolean isInteger() {
        return this instanceof Integer;
    }

    public boolean isJFalse() {
        return false;
    }

    public boolean isJNull() {
        return false;
    }

    public final boolean isJRef() {
        return this instanceof JRef;
    }

    public boolean isJTrue() {
        return false;
    }

    public boolean isJVoid() {
        return false;
    }

    public boolean isListNil() {
        return false;
    }

    public boolean isListPair() {
        return false;
    }

    public final boolean isVariable() {
        return this instanceof Variable;
    }

    @Deprecated
    public Object jrefToObject() {
        throw new JPLException("term is neither a JRef nor a Compound representing @(null)");
    }

    @Deprecated
    public final int listLength() {
        if (this.isListPair()) {
            return 1 + this.arg(2).listLength();
        }
        if (this.isListNil()) {
            return 0;
        }
        throw new JPLException("term is not a list");
    }

    public long longValue() {
        throw new JPLException("longValue() is undefined for " + this.typeName());
    }

    public String name() {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public Object object() {
        if (this == JPL.JNULL) {
            return null;
        }
        throw new JPLException("this term is not a JRef");
    }

    @Deprecated
    public static final Term objectToJRef(Object object) {
        if (object == null) {
            return JPL.JNULL;
        }
        if (object instanceof String) {
            throw new JPLException("a JRef cannot have a String value (Strings are represented by text atoms)");
        }
        return new JRef(object);
    }

    protected void put(term_t term_t2) {
        this.put(new HashMap<String, term_t>(), term_t2);
    }

    protected abstract void put(Map<String, term_t> var1, term_t var2);

    public Term putParams(Term[] termArray) {
        IntHolder intHolder = new IntHolder();
        intHolder.value = 0;
        Term term = this.putParams1(intHolder, termArray);
        if (intHolder.value != termArray.length) {
            throw new JPLException("more actual params than formal");
        }
        return term;
    }

    protected Term putParams(Term term) {
        Term[] termArray = term.toTermArray();
        return this.putParams(termArray);
    }

    protected Term putParams1(IntHolder intHolder, Term[] termArray) {
        switch (this.type()) {
            case 6: {
                return new Compound(this.name(), Term.putParams2(this.args(), intHolder, termArray));
            }
            case 2: {
                if (!this.name().equals("?")) {
                    return this;
                }
                if (intHolder.value >= termArray.length) {
                    throw new JPLException("fewer actual params than formal params");
                }
                return termArray[intHolder.value++];
            }
        }
        return this;
    }

    protected static Term[] putParams2(Term[] termArray, IntHolder intHolder, Term[] termArray2) {
        int n = termArray.length;
        Term[] termArray3 = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray3[i] = termArray[i].putParams1(intHolder, termArray2);
        }
        return termArray3;
    }

    public static void putTerm(Object object, term_t term_t2) {
        if (!(object instanceof Term)) {
            throw new JPLException("not a Term");
        }
        ((Term)object).put(term_t2);
    }

    protected static term_t putTerms(Map<String, term_t> map, Term[] termArray) {
        term_t term_t2 = Prolog.new_term_refs(termArray.length);
        long l = term_t2.value;
        for (int i = 0; i < termArray.length; ++i) {
            term_t term_t3 = new term_t();
            term_t3.value = l++;
            termArray[i].put(map, term_t3);
        }
        return term_t2;
    }

    @Deprecated
    public Object ref() {
        throw new JPLException("this Term is not a JRef");
    }

    public final Term[] toTermArray() {
        try {
            int n = Util.listToLength(this);
            Term[] termArray = new Term[n];
            Term term = this;
            for (int i = 0; i < n; ++i) {
                termArray[i] = term.arg(1);
                term = term.arg(2);
            }
            return termArray;
        }
        catch (JPLException jPLException) {
            throw new JPLException("term is not a proper list");
        }
    }

    protected static boolean terms_equals(Term[] termArray, Term[] termArray2) {
        if (termArray.length != termArray2.length) {
            return false;
        }
        for (int i = 0; i < termArray.length; ++i) {
            if (termArray[i].equals(termArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String toString(Term[] termArray) {
        String string = "";
        for (int i = 0; i < termArray.length; ++i) {
            string = string + termArray[i].toString();
            if (i == termArray.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public abstract int type();

    public abstract String typeName();
}

