/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private boolean closed;
    private Stack markStack;
    byte[] buffer;
    protected int bitOffset;
    protected ByteOrder byteOrder;
    protected long flushedPos;
    protected long streamPos;

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void flushBefore(long position) throws IOException {
        if (position < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        if (position > this.streamPos) {
            throw new IndexOutOfBoundsException();
        }
        this.flushedPos = position;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public long length() {
        return -1;
    }

    public void mark() {
        try {
            this.markStack.push(new Long(this.getStreamPosition()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract int read() throws IOException;

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int readBit() throws IOException {
        this.checkClosed();
        int newOffset = this.bitOffset + 1 & 7;
        byte data = this.readByte();
        if (this.bitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            data = (byte)(data >> 8 - newOffset);
        }
        this.bitOffset = newOffset;
        return data & 1;
    }

    public long readBits(int numBits) throws IOException {
        this.checkClosed();
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numBits == 0) {
            return 0L;
        }
        long bits = 0L;
        int i = 0;
        while (i < numBits) {
            bits <<= 1;
            bits |= (long)this.readBit();
            ++i;
        }
        return bits;
    }

    public boolean readBoolean() throws IOException {
        byte data = this.readByte();
        boolean bl = false;
        if (data != 0) {
            bl = true;
        }
        return bl;
    }

    public byte readByte() throws IOException {
        int data = this.read();
        if (data == -1) {
            throw new EOFException();
        }
        return (byte)data;
    }

    public void readBytes(IIOByteBuffer buffer, int len) throws IOException {
        int result = this.read(buffer.getData(), buffer.getOffset(), len);
        if (result == -1 || result < len) {
            throw new EOFException();
        }
        buffer.setLength(len);
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return this.readLong();
    }

    public float readFloat() throws IOException {
        return this.readInt();
    }

    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readByte();
            ++i;
        }
    }

    public void readFully(char[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readChar();
            ++i;
        }
    }

    public void readFully(double[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readDouble();
            ++i;
        }
    }

    public void readFully(float[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readFloat();
            ++i;
        }
    }

    public void readFully(int[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readInt();
            ++i;
        }
    }

    public void readFully(long[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readLong();
            ++i;
        }
    }

    public void readFully(short[] data, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            data[offset + i] = this.readShort();
            ++i;
        }
    }

    public int readInt() throws IOException {
        int result = this.read(this.buffer, 0, 4);
        if (result == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (this.buffer[0] & 0xFF) + (this.buffer[1] << 8) + (this.buffer[2] << 16) + (this.buffer[3] << 24);
        }
        return (this.buffer[4] << 24) + (this.buffer[3] << 16) + (this.buffer[2] << 8) + (this.buffer[1] & 0xFF);
    }

    public String readLine() throws IOException {
        this.checkClosed();
        int c = -1;
        boolean eol = false;
        StringBuffer buffer = new StringBuffer();
        while (!eol && (c = this.read()) != -1) {
            switch (c) {
                case 13: {
                    long oldPosition = this.getStreamPosition();
                    if (this.read() != 10) {
                        this.seek(oldPosition);
                    }
                }
                case 10: {
                    eol = true;
                    break;
                }
                default: {
                    buffer.append((char)c);
                    break;
                }
            }
        }
        if (c == -1 && buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public long readLong() throws IOException {
        int result = this.read(this.buffer, 0, 8);
        if (result == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (long)((this.buffer[0] & 0xFF) + ((this.buffer[1] & 0xFF) << 8) + ((this.buffer[2] & 0xFF) << 16)) + (((long)this.buffer[3] & 0xFFL) << 24) + (((long)this.buffer[4] & 0xFFL) << 32) + (((long)this.buffer[5] & 0xFFL) << 40) + (((long)this.buffer[6] & 0xFFL) << 48) + ((long)this.buffer[7] << 56);
        }
        return ((long)this.buffer[7] << 56) + (((long)this.buffer[6] & 0xFFL) << 48) + (((long)this.buffer[5] & 0xFFL) << 40) + (((long)this.buffer[4] & 0xFFL) << 32) + (((long)this.buffer[3] & 0xFFL) << 24) + (long)((this.buffer[2] & 0xFF) << 16) + (long)((this.buffer[1] & 0xFF) << 8) + (long)(this.buffer[0] & 0xFF);
    }

    public short readShort() throws IOException {
        int result = this.read(this.buffer, 0, 2);
        if (result == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((this.buffer[0] & 0xFF) + (this.buffer[1] << 8));
        }
        return (short)((this.buffer[0] << 8) + (this.buffer[1] & 0xFF));
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return this.readInt() & 0xFFFFFFFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & (char)-1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readUTF() throws IOException {
        String data;
        this.checkClosed();
        ByteOrder old = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            data = DataInputStream.readUTF(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setByteOrder(old);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.setByteOrder(old);
            return data;
        }
    }

    public void reset() throws IOException {
        this.checkClosed();
        long mark = (Long)this.markStack.pop();
        this.seek(mark);
    }

    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("position < flushed position");
        }
        this.streamPos = position;
        this.bitOffset = 0;
    }

    public void setBitOffset(int bitOffset) throws IOException {
        this.checkClosed();
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException();
        }
        this.bitOffset = bitOffset;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int skipBytes(int num) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + (long)num);
        this.bitOffset = 0;
        return num;
    }

    public long skipBytes(long num) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + num);
        this.bitOffset = 0;
        return num;
    }

    private final /* synthetic */ void this() {
        this.markStack = new Stack();
        this.buffer = new byte[8];
    }

    public ImageInputStreamImpl() {
        this.this();
    }
}

