/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management.client;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.Configuration;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.management.client.AgentConnection;
import org.opensolaris.opengrok.management.client.ShowErrorForm;

public class ConfigurationsFrame
extends JFrame {
    AgentConnection con;
    private static final Logger logger = OpenGrokLogger.getLogger();
    private static final Level[] levels = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.SEVERE, Level.WARNING};
    private ObjectName managementObjectName;
    private ObjectName configObjectName;
    private Level consoleLevel = Level.OFF;
    private Level fileLevel = Level.OFF;
    private String filePath = "";
    private String publishURL = "";
    private Configuration config = null;
    private String configurationFile = null;
    private static final String[] projectTableHeaders = new String[]{"Id", "Description", "Path", "Default"};
    private static final String[] repositoryTableHeaders = new String[]{"Directory", "Type", "SCM Working"};
    private static final String[] ignoredNamesHeaders = new String[]{"IgnorePatterns"};
    private JCheckBox allowLeadingWildCardsCB;
    private JTextField bugPageField;
    private JTextField bugPatternField;
    private JTextField cTagsField;
    private JButton closeBtn;
    private JCheckBox compressXRefsCB;
    private JTextField configFileField;
    private JComboBox<Level> consoleLevelCombo;
    private JTextField dataRootField;
    private JComboBox<Level> fileLevelCombo;
    private JPanel genSettingsPanel;
    private JCheckBox generateHtmlCB;
    private JCheckBox historyCacheCB;
    private JPanel historyListingPanel;
    private JTextField historyReaderTimelimitField;
    private JTable ignoredNamesTable;
    private JCheckBox indexVersionedFilesOnlyCB;
    private JTextField indexWordLimitField;
    private JPanel indexerPanel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabPane;
    private JTextField logFilePathField;
    private JCheckBox luceneLockingCB;
    private JCheckBox optimizedDatabaseCB;
    private JPanel projectsPanel;
    private JTable projectsTable;
    private JTextField publishHostField;
    private JCheckBox remoteSCMSupportedCB;
    private JPanel repositoryPanel;
    private JTable repositoryTable;
    private JTextField reviewPageField;
    private JTextField reviewPatternField;
    private JTextField sourceRootField;
    private JCheckBox tagsEnabledCB;
    private JButton updateBtn;
    private JTextField urlPrefixField;
    private JTextField userPageField;
    private JTextField webAppLAFField;

    public ConfigurationsFrame(AgentConnection ac) throws IOException {
        this.con = ac;
        try {
            this.managementObjectName = new ObjectName("OGA:name=Management");
            this.configObjectName = new ObjectName("OGA:name=JMXConfiguration");
        }
        catch (MalformedObjectNameException ex) {
            logger.log(Level.SEVERE, "MalformedObjectName", ex);
            throw new IOException("Malformedname " + ex);
        }
        this.initComponents();
        this.createLogLevelCombos();
        this.getConfigsFromAgent();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - mySize.width / 2, screenSize.height / 2 - mySize.height / 2);
    }

    private void showError(Exception exc) {
        ShowErrorForm sf = new ShowErrorForm((Frame)this, true, exc.getMessage());
        sf.setVisible(true);
    }

    private void createLogLevelCombos() {
        this.consoleLevelCombo.removeAllItems();
        this.fileLevelCombo.removeAllItems();
        for (int i = 0; i < levels.length; ++i) {
            this.consoleLevelCombo.addItem(levels[i]);
            this.fileLevelCombo.addItem(levels[i]);
        }
    }

    private void getConfigsFromAgent() {
        if (this.con != null && this.con.isConnected()) {
            try {
                this.consoleLevel = (Level)this.con.getMBeanServerConnection().getAttribute(this.managementObjectName, "ConsoleLogLevel");
                this.consoleLevelCombo.setSelectedItem(this.consoleLevel);
                this.fileLevel = (Level)this.con.getMBeanServerConnection().getAttribute(this.managementObjectName, "FileLogLevel");
                this.fileLevelCombo.setSelectedItem(this.fileLevel);
                this.filePath = (String)this.con.getMBeanServerConnection().getAttribute(this.managementObjectName, "FileLogPath");
                this.logFilePathField.setText(this.filePath);
                this.publishURL = (String)this.con.getMBeanServerConnection().getAttribute(this.managementObjectName, "PublishServerURL");
                if (this.publishURL == null) {
                    this.publishURL = "";
                }
                this.publishHostField.setText(this.publishURL);
                this.configurationFile = (String)this.con.getMBeanServerConnection().getAttribute(this.managementObjectName, "ConfigurationFile");
                this.configFileField.setText(this.configurationFile);
                String xmlconfig = (String)this.con.getMBeanServerConnection().getAttribute(this.configObjectName, "Configuration");
                this.config = Configuration.makeXMLStringAsConfiguration(xmlconfig);
                this.updateConfigFieldsFromConfig();
            }
            catch (MBeanException ex) {
                logger.log(Level.SEVERE, "", ex);
            }
            catch (AttributeNotFoundException ex) {
                Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstanceNotFoundException ex) {
                Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ReflectionException ex) {
                Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void updateConfigFieldsFromConfig() {
        this.dataRootField.setText(this.config.getDataRoot());
        this.sourceRootField.setText(this.config.getSourceRoot());
        this.indexVersionedFilesOnlyCB.setSelected(this.config.isIndexVersionedFilesOnly());
        this.luceneLockingCB.setSelected(this.config.isUsingLuceneLocking());
        this.remoteSCMSupportedCB.setText(this.config.getRemoteScmSupported().toString());
        this.bugPageField.setText(this.config.getBugPage());
        this.bugPatternField.setText(this.config.getBugPattern());
        this.reviewPageField.setText(this.config.getReviewPage());
        this.reviewPatternField.setText(this.config.getReviewPattern());
        this.userPageField.setText(this.config.getUserPage());
        this.webAppLAFField.setText(this.config.getWebappLAF());
        this.compressXRefsCB.setSelected(this.config.isCompressXref());
        this.cTagsField.setText(this.config.getCtags());
        this.generateHtmlCB.setSelected(this.config.isGenerateHtml());
        this.tagsEnabledCB.setSelected(this.config.isTagsEnabled());
        this.historyCacheCB.setSelected(this.config.isHistoryCache());
        this.indexWordLimitField.setText(Double.toString(this.config.getRamBufferSize()));
        this.allowLeadingWildCardsCB.setSelected(this.config.isAllowLeadingWildcard());
        this.urlPrefixField.setText(this.config.getUrlPrefix());
        this.historyReaderTimelimitField.setText(Integer.toString(this.config.getHistoryCacheTime()));
        List<Project> projects = this.config.getProjects();
        DefaultTableModel model = new DefaultTableModel(projectTableHeaders, projects.size());
        Project defaultproj = this.config.getDefaultProject();
        int row = 0;
        for (Project proj : projects) {
            model.setValueAt(proj.getId(), row, 0);
            model.setValueAt(proj.getDescription(), row, 1);
            model.setValueAt(proj.getPath(), row, 2);
            String defaultval = "";
            defaultval = proj.equals(defaultproj) ? "Yes" : "";
            model.setValueAt(defaultval, row, 3);
            ++row;
        }
        this.projectsTable.setModel(model);
        IgnoredNames in = this.config.getIgnoredNames();
        List<String> ignoredpatternlist = in.getItems();
        DefaultTableModel ignoredModel = new DefaultTableModel(ignoredNamesHeaders, ignoredpatternlist.size());
        row = 0;
        for (String item : ignoredpatternlist) {
            ignoredModel.setValueAt(item, row, 0);
            ++row;
        }
        this.ignoredNamesTable.setModel(ignoredModel);
        List<RepositoryInfo> repos = this.config.getRepositories();
        DefaultTableModel reposModel = new DefaultTableModel(repositoryTableHeaders, repos.size());
        row = 0;
        for (RepositoryInfo info : repos) {
            reposModel.setValueAt(info.getDirectoryName(), row, 0);
            reposModel.setValueAt(info.getType(), row, 1);
            reposModel.setValueAt(info.isWorking(), row, 2);
            ++row;
        }
        this.repositoryTable.setModel(reposModel);
    }

    private void initComponents() {
        this.jTabPane = new JTabbedPane();
        this.genSettingsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.consoleLevelCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.fileLevelCombo = new JComboBox();
        this.jLabel4 = new JLabel();
        this.logFilePathField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.publishHostField = new JTextField();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.configFileField = new JTextField();
        this.indexerPanel = new JPanel();
        this.jLabel7 = new JLabel();
        this.dataRootField = new JTextField();
        this.jLabel8 = new JLabel();
        this.sourceRootField = new JTextField();
        this.luceneLockingCB = new JCheckBox();
        this.optimizedDatabaseCB = new JCheckBox();
        this.remoteSCMSupportedCB = new JCheckBox();
        this.indexVersionedFilesOnlyCB = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.cTagsField = new JTextField();
        this.historyCacheCB = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.historyReaderTimelimitField = new JTextField();
        this.generateHtmlCB = new JCheckBox();
        this.compressXRefsCB = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.indexWordLimitField = new JTextField();
        this.tagsEnabledCB = new JCheckBox();
        this.projectsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.projectsTable = new JTable();
        this.repositoryPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.repositoryTable = new JTable();
        this.historyListingPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.bugPageField = new JTextField();
        this.jLabel10 = new JLabel();
        this.bugPatternField = new JTextField();
        this.jLabel11 = new JLabel();
        this.reviewPageField = new JTextField();
        this.jLabel12 = new JLabel();
        this.reviewPatternField = new JTextField();
        this.jLabel13 = new JLabel();
        this.userPageField = new JTextField();
        this.jLabel14 = new JLabel();
        this.webAppLAFField = new JTextField();
        this.jLabel15 = new JLabel();
        this.urlPrefixField = new JTextField();
        this.allowLeadingWildCardsCB = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.ignoredNamesTable = new JTable();
        this.closeBtn = new JButton();
        this.updateBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("OpenGrok Configuration");
        this.setName("configFrame");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel1.setText("Logging:");
        this.jLabel2.setText("Console Level");
        this.consoleLevelCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("File Level");
        this.fileLevelCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel4.setText("File Path");
        this.logFilePathField.setText("jTextField1");
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel5.setText("Publishing:");
        this.jLabel6.setText("Host URL");
        this.publishHostField.setText("jTextField2");
        this.jLabel19.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel19.setText("Configuration");
        this.jLabel20.setText("Configuration file: ");
        this.configFileField.setText("jTextField1");
        GroupLayout genSettingsPanelLayout = new GroupLayout(this.genSettingsPanel);
        this.genSettingsPanel.setLayout(genSettingsPanelLayout);
        genSettingsPanelLayout.setHorizontalGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(genSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(genSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publishHostField, -1, 443, Short.MAX_VALUE)).addComponent(this.jLabel1).addGroup(genSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.consoleLevelCombo, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.fileLevelCombo, -2, 93, -2)).addGroup(genSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.logFilePathField, -1, 441, Short.MAX_VALUE)).addComponent(this.jLabel19).addGroup(genSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configFileField, -1, 366, Short.MAX_VALUE))).addContainerGap()));
        genSettingsPanelLayout.setVerticalGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(genSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.consoleLevelCombo, -2, -1, -2).addComponent(this.fileLevelCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.logFilePathField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.publishHostField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(genSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.configFileField, -2, -1, -2)).addContainerGap(121, Short.MAX_VALUE)));
        this.jTabPane.addTab("General", this.genSettingsPanel);
        this.jLabel7.setText("Data Root Path");
        this.dataRootField.setText("jTextField1");
        this.jLabel8.setText("Source Root Path");
        this.sourceRootField.setText("jTextField1");
        this.luceneLockingCB.setText("Use Lucene Locking");
        this.optimizedDatabaseCB.setText("Optimized Database");
        this.remoteSCMSupportedCB.setText("Remote SCM Supported");
        this.indexVersionedFilesOnlyCB.setText("Index Versioned Files Only");
        this.jLabel16.setText("CTags binary");
        this.cTagsField.setText("jTextField1");
        this.historyCacheCB.setText("Use History Cache");
        this.jLabel17.setText("History Reader Time Limit");
        this.historyReaderTimelimitField.setText("jTextField1");
        this.generateHtmlCB.setText("Generate HTML");
        this.compressXRefsCB.setText("Compress XRefs");
        this.jLabel18.setText("Ram Buffer Size");
        this.jLabel18.setToolTipText("when to flush docs to disk");
        this.indexWordLimitField.setText("jTextField1");
        this.tagsEnabledCB.setText("Assign Tags in History");
        GroupLayout indexerPanelLayout = new GroupLayout(this.indexerPanel);
        this.indexerPanel.setLayout(indexerPanelLayout);
        indexerPanelLayout.setHorizontalGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexerPanelLayout.createSequentialGroup().addContainerGap().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexerPanelLayout.createSequentialGroup().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceRootField, -1, 398, Short.MAX_VALUE).addComponent(this.dataRootField, -1, 398, Short.MAX_VALUE))).addGroup(indexerPanelLayout.createSequentialGroup().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.remoteSCMSupportedCB, GroupLayout.Alignment.LEADING).addComponent(this.luceneLockingCB, GroupLayout.Alignment.LEADING).addComponent(this.historyCacheCB, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compressXRefsCB).addGroup(indexerPanelLayout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyReaderTimelimitField, -1, 113, Short.MAX_VALUE)).addComponent(this.optimizedDatabaseCB).addComponent(this.indexVersionedFilesOnlyCB))).addGroup(indexerPanelLayout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexWordLimitField, 0, 1, Short.MAX_VALUE).addGap(325, 325, 325)).addGroup(indexerPanelLayout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cTagsField, -1, 419, Short.MAX_VALUE)).addGroup(indexerPanelLayout.createSequentialGroup().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generateHtmlCB).addComponent(this.tagsEnabledCB)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        indexerPanelLayout.setVerticalGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexerPanelLayout.createSequentialGroup().addContainerGap().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.dataRootField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.sourceRootField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.luceneLockingCB).addComponent(this.optimizedDatabaseCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteSCMSupportedCB).addComponent(this.indexVersionedFilesOnlyCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.historyCacheCB).addComponent(this.jLabel17).addComponent(this.historyReaderTimelimitField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compressXRefsCB).addComponent(this.generateHtmlCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagsEnabledCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.indexWordLimitField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.cTagsField, -2, -1, -2)).addContainerGap(117, Short.MAX_VALUE)));
        this.jTabPane.addTab("Indexer", this.indexerPanel);
        this.projectsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.projectsTable);
        GroupLayout projectsPanelLayout = new GroupLayout(this.projectsPanel);
        this.projectsPanel.setLayout(projectsPanelLayout);
        projectsPanelLayout.setHorizontalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 510, Short.MAX_VALUE).addContainerGap()));
        projectsPanelLayout.setVerticalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectsPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 301, Short.MAX_VALUE).addContainerGap()));
        this.jTabPane.addTab("Projects", this.projectsPanel);
        this.repositoryTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.repositoryTable);
        GroupLayout repositoryPanelLayout = new GroupLayout(this.repositoryPanel);
        this.repositoryPanel.setLayout(repositoryPanelLayout);
        repositoryPanelLayout.setHorizontalGroup(repositoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repositoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 510, Short.MAX_VALUE).addContainerGap()));
        repositoryPanelLayout.setVerticalGroup(repositoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repositoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 289, Short.MAX_VALUE).addContainerGap()));
        this.jTabPane.addTab("Repositories", this.repositoryPanel);
        this.jLabel9.setText("Bug Page");
        this.bugPageField.setText("jTextField1");
        this.jLabel10.setText("Bug Pattern");
        this.bugPatternField.setText("jTextField2");
        this.jLabel11.setText("Review Page");
        this.reviewPageField.setText("jTextField3");
        this.jLabel12.setText("Review Pattern");
        this.reviewPatternField.setText("jTextField4");
        this.jLabel13.setText("User Page");
        this.userPageField.setText("jTextField5");
        this.jLabel14.setText("Web App LAF");
        this.webAppLAFField.setText("jTextField1");
        this.jLabel15.setText("URL Prefix");
        this.urlPrefixField.setText("jTextField1");
        this.allowLeadingWildCardsCB.setText("Allow Leading Wildcards");
        GroupLayout historyListingPanelLayout = new GroupLayout(this.historyListingPanel);
        this.historyListingPanel.setLayout(historyListingPanelLayout);
        historyListingPanelLayout.setHorizontalGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyListingPanelLayout.createSequentialGroup().addContainerGap().addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allowLeadingWildCardsCB).addGroup(historyListingPanelLayout.createSequentialGroup().addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel15).addGroup(GroupLayout.Alignment.TRAILING, historyListingPanelLayout.createSequentialGroup().addComponent(this.jLabel9, -2, 69, -2).addGap(19, 19, 19))).addComponent(this.jLabel12).addComponent(this.jLabel11).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userPageField, -1, 390, Short.MAX_VALUE).addComponent(this.urlPrefixField, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE).addComponent(this.bugPageField, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE).addComponent(this.bugPatternField, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE).addComponent(this.reviewPageField, GroupLayout.Alignment.TRAILING, -1, 410, Short.MAX_VALUE).addComponent(this.reviewPatternField, -1, 410, Short.MAX_VALUE))).addGroup(historyListingPanelLayout.createSequentialGroup().addComponent(this.jLabel14).addGap(18, 18, 18).addComponent(this.webAppLAFField, -1, 412, Short.MAX_VALUE))).addContainerGap()));
        historyListingPanelLayout.setVerticalGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(historyListingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.allowLeadingWildCardsCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.urlPrefixField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.bugPageField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.bugPatternField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reviewPageField, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reviewPatternField, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.userPageField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(historyListingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.webAppLAFField, -2, -1, -2)).addContainerGap(111, Short.MAX_VALUE)));
        this.jTabPane.addTab("Web App", this.historyListingPanel);
        this.ignoredNamesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.ignoredNamesTable);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 510, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 289, Short.MAX_VALUE).addContainerGap()));
        this.jTabPane.addTab("IgnoredNames", this.jPanel1);
        this.closeBtn.setText("Close");
        this.closeBtn.setToolTipText("Close without deploying changes");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsFrame.this.closeBtnActionPerformed(evt);
            }
        });
        this.updateBtn.setText("Update");
        this.updateBtn.setToolTipText("send update to the opengrok agent");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsFrame.this.updateBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTabPane).addGroup(layout.createSequentialGroup().addComponent(this.updateBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabPane, -1, 358, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeBtn).addComponent(this.updateBtn)).addContainerGap()));
        this.pack();
    }

    private void closeBtnActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        try {
            Attribute attribute;
            logger.info("updating to agent management mbean attributes");
            if (!this.filePath.equals(this.logFilePathField.getText())) {
                attribute = new Attribute("FileLogPath", this.logFilePathField.getText());
                this.con.getMBeanServerConnection().setAttribute(this.managementObjectName, attribute);
                this.filePath = this.logFilePathField.getText();
            }
            if (!this.fileLevel.equals((Level)this.fileLevelCombo.getSelectedItem())) {
                attribute = new Attribute("FileLogLevel", this.fileLevelCombo.getSelectedItem());
                this.con.getMBeanServerConnection().setAttribute(this.managementObjectName, attribute);
                this.fileLevel = (Level)this.fileLevelCombo.getSelectedItem();
            }
            if (!this.consoleLevel.equals((Level)this.consoleLevelCombo.getSelectedItem())) {
                attribute = new Attribute("ConsoleLogLevel", this.consoleLevelCombo.getSelectedItem());
                this.con.getMBeanServerConnection().setAttribute(this.managementObjectName, attribute);
                this.consoleLevel = (Level)this.consoleLevelCombo.getSelectedItem();
            }
            if (!this.publishURL.equals(this.publishHostField.getText())) {
                attribute = new Attribute("PublishServerURL", this.publishHostField.getText());
                this.con.getMBeanServerConnection().setAttribute(this.managementObjectName, attribute);
                this.publishURL = this.publishHostField.getText();
            }
            if (!this.configurationFile.equals(this.configFileField.getText())) {
                attribute = new Attribute("ConfigurationFile", this.configFileField.getText());
                this.con.getMBeanServerConnection().setAttribute(this.managementObjectName, attribute);
                this.configurationFile = this.configFileField.getText();
            }
            logger.info("updating agent configuration mbean attributes");
            this.updateConfigurationFromGUIObjects();
            attribute = new Attribute("Configuration", this.config.getXMLRepresentationAsString());
            this.con.getMBeanServerConnection().setAttribute(this.configObjectName, attribute);
        }
        catch (InstanceNotFoundException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
        catch (AttributeNotFoundException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
        catch (InvalidAttributeValueException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
        catch (MBeanException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
        catch (ReflectionException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.showError(ex);
        }
    }

    private Configuration.RemoteSCM stringToRemoteSCM(String rscm) {
        if (rscm.contentEquals("on")) {
            return Configuration.RemoteSCM.ON;
        }
        if (rscm.contentEquals("off")) {
            return Configuration.RemoteSCM.OFF;
        }
        if (rscm.contentEquals("dirbased")) {
            return Configuration.RemoteSCM.DIRBASED;
        }
        if (rscm.contentEquals("uionly")) {
            return Configuration.RemoteSCM.UIONLY;
        }
        return Configuration.RemoteSCM.OFF;
    }

    private void updateConfigurationFromGUIObjects() {
        this.config.setSourceRoot(this.sourceRootField.getText());
        this.config.setDataRoot(this.dataRootField.getText());
        this.config.setIndexVersionedFilesOnly(this.indexVersionedFilesOnlyCB.isSelected());
        this.config.setUsingLuceneLocking(this.luceneLockingCB.isSelected());
        this.config.setRemoteScmSupported(this.stringToRemoteSCM(this.remoteSCMSupportedCB.getText()));
        this.config.setOptimizeDatabase(this.optimizedDatabaseCB.isSelected());
        this.config.setAllowLeadingWildcard(this.allowLeadingWildCardsCB.isSelected());
        this.config.setCompressXref(this.compressXRefsCB.isSelected());
        this.config.setCtags(this.cTagsField.getText());
        this.config.setGenerateHtml(this.generateHtmlCB.isSelected());
        this.config.setTagsEnabled(this.tagsEnabledCB.isSelected());
        this.config.setHistoryCache(this.historyCacheCB.isSelected());
        this.config.setHistoryCacheTime(Integer.parseInt(this.historyReaderTimelimitField.getText()));
        this.config.setRamBufferSize(Double.parseDouble(this.indexWordLimitField.getText()));
        this.config.setUrlPrefix(this.urlPrefixField.getText());
        this.config.setBugPage(this.bugPageField.getText());
        this.config.setBugPattern(this.bugPatternField.getText());
        this.config.setReviewPage(this.reviewPageField.getText());
        this.config.setReviewPattern(this.reviewPatternField.getText());
        this.config.setUserPage(this.userPageField.getText());
        this.config.setWebappLAF(this.webAppLAFField.getText());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new ConfigurationsFrame(null).setVisible(true);
                }
                catch (IOException ex) {
                    Logger.getLogger(ConfigurationsFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

