/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.MathProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class MathFunction
extends UnaryScalarFunction {
    protected MathFunction(Source source) {
        super(source);
    }

    protected MathFunction(Source source, Expression field) {
        super(source, field);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    @Override
    public String processScript(String template) {
        return super.processScript(String.format(Locale.ROOT, "{sql}.%s(%s)", this.getClass().getSimpleName().toLowerCase(Locale.ROOT), template));
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    protected Processor makeProcessor() {
        return new MathProcessor(this.operation());
    }

    protected abstract MathProcessor.MathOperation operation();

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MathFunction other = (MathFunction)obj;
        return Objects.equals(other.field(), this.field());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field());
    }
}

