/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum GetPasswordQualityRequirementsTargetType {
    ADD_WITH_DEFAULT_PASSWORD_POLICY(-128),
    ADD_WITH_SPECIFIED_PASSWORD_POLICY(-127),
    SELF_CHANGE_FOR_AUTHORIZATION_IDENTITY(-126),
    SELF_CHANGE_FOR_SPECIFIED_USER(-125),
    ADMINISTRATIVE_RESET_FOR_SPECIFIED_USER(-124);

    private final byte berType;

    private GetPasswordQualityRequirementsTargetType(byte berType) {
        this.berType = berType;
    }

    public byte getBERType() {
        return this.berType;
    }

    public static GetPasswordQualityRequirementsTargetType forBERType(byte berType) {
        for (GetPasswordQualityRequirementsTargetType t : GetPasswordQualityRequirementsTargetType.values()) {
            if (t.berType != berType) continue;
            return t;
        }
        return null;
    }

    public static GetPasswordQualityRequirementsTargetType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "addwithdefaultpasswordpolicy": 
            case "add-with-default-password-policy": 
            case "add_with_default_password_policy": {
                return ADD_WITH_DEFAULT_PASSWORD_POLICY;
            }
            case "addwithspecifiedpasswordpolicy": 
            case "add-with-specified-password-policy": 
            case "add_with_specified_password_policy": {
                return ADD_WITH_SPECIFIED_PASSWORD_POLICY;
            }
            case "selfchangeforauthorizationidentity": 
            case "self-change-for-authorization-identity": 
            case "self_change_for_authorization_identity": {
                return SELF_CHANGE_FOR_AUTHORIZATION_IDENTITY;
            }
            case "selfchangeforspecifieduser": 
            case "self-change-for-specified-user": 
            case "self_change_for_specified_user": {
                return SELF_CHANGE_FOR_SPECIFIED_USER;
            }
            case "administrativeresetforspecifieduser": 
            case "administrative-reset-for-specified-user": 
            case "administrative_reset_for_specified_user": {
                return ADMINISTRATIVE_RESET_FOR_SPECIFIED_USER;
            }
        }
        return null;
    }
}

