/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class TransportMlInfoAction
extends HandledTransportAction<MlInfoAction.Request, MlInfoAction.Response> {
    private final ClusterService clusterService;

    @Inject
    public TransportMlInfoAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:monitor/xpack/ml/info/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, MlInfoAction.Request::new);
        this.clusterService = clusterService;
    }

    protected void doExecute(MlInfoAction.Request request, ActionListener<MlInfoAction.Response> listener) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("defaults", this.defaults());
        info.put("limits", this.limits());
        info.put(MlMetadata.UPGRADE_MODE.getPreferredName(), this.upgradeMode());
        listener.onResponse((Object)new MlInfoAction.Response(info));
    }

    private Map<String, Object> defaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("anomaly_detectors", this.anomalyDetectorsDefaults());
        defaults.put("datafeeds", this.datafeedsDefaults());
        return defaults;
    }

    private boolean upgradeMode() {
        return MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode();
    }

    private Map<String, Object> anomalyDetectorsDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(AnalysisLimits.MODEL_MEMORY_LIMIT.getPreferredName(), this.defaultModelMemoryLimit());
        defaults.put(AnalysisLimits.CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), 4L);
        defaults.put(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), 1L);
        return defaults;
    }

    private ByteSizeValue defaultModelMemoryLimit() {
        ByteSizeValue defaultLimit = new ByteSizeValue(1024L, ByteSizeUnit.MB);
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L && maxModelMemoryLimit.getBytes() < defaultLimit.getBytes()) {
            return maxModelMemoryLimit;
        }
        return defaultLimit;
    }

    private Map<String, Object> datafeedsDefaults() {
        HashMap<String, Object> anomalyDetectorsDefaults = new HashMap<String, Object>();
        anomalyDetectorsDefaults.put(DatafeedConfig.SCROLL_SIZE.getPreferredName(), 1000);
        return anomalyDetectorsDefaults;
    }

    private Map<String, Object> limits() {
        HashMap<String, Object> limits = new HashMap<String, Object>();
        ByteSizeValue maxModelMemoryLimit = (ByteSizeValue)this.clusterService.getClusterSettings().get(MachineLearningField.MAX_MODEL_MEMORY_LIMIT);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            limits.put("max_model_memory_limit", maxModelMemoryLimit);
        }
        return limits;
    }
}

