/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;

public class TableTraverser {
    private FindService _findService;
    private int _col = -1;
    private int _row = 0;

    public void reset() {
        this._col = -1;
        this._row = 0;
    }

    public void forward() {
        if (this._col < this._findService.getColCount() - 1) {
            ++this._col;
        } else if (this._row < this._findService.getRowCount() - 1) {
            ++this._row;
            this._col = 0;
        } else {
            this.reset();
        }
    }

    public void backward() {
        if (0 < this._col) {
            --this._col;
        } else if (0 < this._row) {
            --this._row;
            this._col = this._findService.getColCount() - 1;
        } else {
            this._col = Math.max(0, this._findService.getColCount() - 1);
            this._row = Math.max(0, this._findService.getRowCount() - 1);
        }
    }

    public int getRow() {
        return this._row;
    }

    public int getCol() {
        if (-1 == this._col) {
            this.forward();
        }
        return this._col;
    }

    public void setFindService(FindService findService) {
        this._findService = findService;
        this.reset();
    }

    public boolean hasRows() {
        return 0 < this._findService.getRowCount();
    }

    public int getCellCount() {
        return this._findService.getColCount() * this._findService.getRowCount();
    }
}

