/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.jmeld.util.StringUtil;
import org.jmeld.util.prefs.AppPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preference {
    private String preferenceName;

    public Preference(String preferenceName) {
        this.preferenceName = preferenceName;
    }

    protected String getPreferenceName() {
        return this.preferenceName;
    }

    protected String getString(String name, String defaultValue) {
        return this.getPreferences().get(this.getKey(name), defaultValue);
    }

    protected void putString(String name, String value) {
        this.getPreferences().put(this.getKey(name), value);
    }

    protected List<String> getListOfString(String name, int maxItems) {
        ArrayList<String> list = new ArrayList<String>(maxItems);
        for (int index = 0; index < maxItems; ++index) {
            String element = this.getString(name + index, null);
            if (StringUtil.isEmpty(element)) continue;
            list.add(element);
        }
        return list;
    }

    protected void putListOfString(String name, int maxItems, List<String> list) {
        for (int index = 0; index < maxItems; ++index) {
            String element = "";
            if (index < list.size() && StringUtil.isEmpty(element = list.get(index))) {
                element = "";
            }
            this.putString(name + index, element);
        }
    }

    protected int getInt(String name, int defaultValue) {
        return this.getPreferences().getInt(this.getKey(name), defaultValue);
    }

    protected void putInt(String name, int value) {
        this.getPreferences().putInt(this.getKey(name), value);
    }

    protected Preferences getPreferences() {
        return AppPreferences.getPreferences(this.getClass());
    }

    private String getKey(String name) {
        return this.preferenceName + "-" + name;
    }

    private String getKey(String name, int index) {
        return this.preferenceName + "-" + name + "-" + index;
    }
}

