/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui.util;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument
implements Document {
    private static final long serialVersionUID = 8245201344439966381L;
    private int maxLength = -1;
    private String valid = "-0123456789";
    private boolean fractional = false;

    public NumberDocument() {
    }

    public NumberDocument(int length) {
        this.maxLength = length;
    }

    public NumberDocument(int length, String specialValid) {
        this.maxLength = length;
        this.valid = this.valid + specialValid;
    }

    public NumberDocument(int length, boolean fractional) {
        this.maxLength = length;
        this.fractional = fractional;
        if (this.fractional) {
            this.valid = this.valid + ".";
        }
    }

    @Override
    public void insertString(int i, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.maxLength > -1 && this.getLength() == this.maxLength) {
            return;
        }
        for (char c : string.toCharArray()) {
            if (this.valid.indexOf(c) != -1 && (!this.fractional || c != '.' || this.getText(0, this.getLength()).indexOf(c) == -1)) continue;
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(i, string, attributeSet);
    }
}

