/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.SerializationProcedure;
import org.jetbrains.coverage.gnu.trove.TFloatHash;
import org.jetbrains.coverage.gnu.trove.TFloatHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TFloatObjectIterator;
import org.jetbrains.coverage.gnu.trove.TFloatObjectProcedure;
import org.jetbrains.coverage.gnu.trove.TFloatProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectFunction;
import org.jetbrains.coverage.gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatObjectHashMap<V>
extends TFloatHash
implements Serializable {
    protected transient V[] _values;

    public TFloatObjectHashMap() {
    }

    public TFloatObjectHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatObjectHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatObjectHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    public TFloatObjectHashMap<V> clone() {
        TFloatObjectHashMap m = (TFloatObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    public TFloatObjectIterator<V> iterator() {
        return new TFloatObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public V put(float key, V value) {
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        V[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public V get(float key) {
        int index = this.index(key);
        return index < 0 ? null : (V)this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        float[] keys = this._set;
        V[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            vals[i] = null;
            states[i] = 0;
        }
    }

    public V remove(float key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatObjectHashMap)) {
            return false;
        }
        TFloatObjectHashMap that = (TFloatObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = null;
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(V val) {
        byte[] states = this._states;
        V[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        byte[] states = this._states;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatObjectProcedure<V> procedure) {
        byte[] states = this._states;
        float[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatObjectProcedure<V> procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        byte[] states = this._states;
        V[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TFloatObjectProcedure {
        private final TFloatObjectHashMap _otherMap;

        EqProcedure(TFloatObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(float key, Object value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    private final class HashProcedure
    implements TFloatObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float key, Object value) {
            this.h += TFloatObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

