/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubIndex;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolScopeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class AncestorBenchmark
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyAncestors";

    public AncestorBenchmark(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            AncestorBenchmark.$$$reportNull$$$0(0);
        }
        if (text == null) {
            AncestorBenchmark.$$$reportNull$$$0(1);
        }
        super(project, text, line, PREFIX, new Options(), false);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        Project project = this.getProject();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(project);
        ReadAction.run(() -> {
            int step = 0;
            ArrayList<Trinity> results = new ArrayList<Trinity>();
            Collection constantFQNs = StubIndex.getInstance().getAllKeys(RubyResolutionIndex.KEY, project).stream().map(it -> FQN.of((String)it)).filter(it -> StringUtil.isCapitalized((String)it.getShortName())).collect(Collectors.toList());
            int size = constantFQNs.size();
            long totalTime = System.currentTimeMillis();
            for (FQN fqn : constantFQNs) {
                Symbol symbol = SymbolUtil.findConstantByFQN((Project)project, (FQN)fqn, null);
                if (symbol == null) continue;
                if (((Options)this.getOptions()).clearCache) {
                    this.clearCaches();
                }
                long time = System.currentTimeMillis();
                List caching = SymbolScopeUtil.getAncestorsCaching((Symbol)symbol, null);
                results.add(Trinity.create((Object)symbol, (Object)caching, (Object)(System.currentTimeMillis() - time)));
                if (++step % 100 != 0) continue;
                context.message("(" + step + "/" + size + ")", this.getLine());
            }
            results.sort(Comparator.comparing(it -> (Long)it.getThird()));
            for (int i = Math.max(0, results.size() - 10); i < results.size(); ++i) {
                context.message(String.format("%s %d %dms", ((Symbol)((Trinity)results.get(i)).getFirst()).getFQNWithNesting().getFullPath(), ((List)((Trinity)results.get(i)).getSecond()).size(), ((Trinity)results.get(i)).getThird()), this.getLine());
            }
            context.message("total: " + (System.currentTimeMillis() - totalTime), this.getLine());
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/ruby/performanceTesting/AncestorBenchmark";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        @Argument
        public boolean clearCache;
    }
}

