/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedFunctionJSInspection
extends JavaScriptInspection {
    public boolean m_includeAnonymousFunctions = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("nested.function.display.name", new Object[0]);
        if (string == null) {
            NestedFunctionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            NestedFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("nested.function.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("nested.anonymous.function.error.string", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("include.anonymous.functions.parameter", new Object[0]), (InspectionProfileEntry)this, "m_includeAnonymousFunctions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function);
            if (!NestedFunctionJSInspection.this.m_includeAnonymousFunctions && function instanceof JSFunctionExpression) {
                return;
            }
            if (function.getParent() instanceof JSClass) {
                return;
            }
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class, (boolean)true);
            if (containingFunction == null) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

