/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EmptyStatementBodyJSInspection
extends JavaScriptInspection {
    public boolean m_reportEmptyBlocks = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            EmptyStatementBodyJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONFUSING_GROUP_NAME;
        if (string == null) {
            EmptyStatementBodyJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof JSIfStatement) {
            return InspectionJSBundle.message("statement.has.empty.branch.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("statement.has.empty.body.error.string", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("include.statement.bodies.that.are.empty.code.blocks.parameter", new Object[0]), (InspectionProfileEntry)this, "m_reportEmptyBlocks");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/EmptyStatementBodyJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSDoWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!this.isEmpty((JSElement)body)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSWhileStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!this.isEmpty((JSElement)body)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(2);
            }
            super.visitJSForStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!this.isEmpty((JSElement)body)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSForInStatement(statement);
            JSStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            if (!this.isEmpty((JSElement)body)) {
                return;
            }
            this.registerStatementError((JSStatement)statement, statement);
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(4);
            }
            super.visitJSIfStatement(statement);
            JSStatement thenBranch = statement.getThen();
            if (thenBranch != null && this.isEmpty((JSElement)thenBranch)) {
                this.registerStatementError((JSStatement)statement, statement);
                return;
            }
            JSStatement elseBranch = statement.getElse();
            if (elseBranch != null && this.isEmpty((JSElement)elseBranch)) {
                this.registerStatementError((JSStatement)statement, statement);
            }
        }

        private boolean isEmpty(JSElement body) {
            if (body instanceof JSEmptyStatement) {
                return true;
            }
            if (EmptyStatementBodyJSInspection.this.m_reportEmptyBlocks && body instanceof JSBlockStatement) {
                JSBlockStatement block = (JSBlockStatement)body;
                JSStatement[] statements = block.getStatements();
                return statements.length == 0;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/sixrr/inspectjs/confusing/EmptyStatementBodyJSInspection$EmptyStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDoWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

