/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLocalClassIndex;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedNameResolver
extends JSQualifiedNameResolver {
    private final StrictKind myStrictKind;
    private final boolean myIncludeAugmentations;
    private final boolean myCheckLocalClasses;

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        this(context, StrictKind.OBJECTS, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, boolean acceptObjectScopes) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        this(context, acceptObjectScopes ? StrictKind.OBJECTS_WITH_FIELDS : StrictKind.OBJECTS, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, @NotNull StrictKind strictKind, boolean includeAugmentations) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(2);
        }
        if (strictKind == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(3);
        }
        this(context, strictKind, includeAugmentations, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, @NotNull StrictKind strictKind, boolean includeAugmentations, boolean checkLocalClasses) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(4);
        }
        if (strictKind == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(5);
        }
        super(context, strictKind == StrictKind.OBJECTS_WITH_FIELDS);
        this.myStrictKind = strictKind;
        this.myIncludeAugmentations = includeAugmentations;
        this.myCheckLocalClasses = checkLocalClasses;
    }

    @Override
    @NotNull
    protected TypeScriptQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        StrictKind newStrictKind = this.myStrictKind == StrictKind.TYPES ? StrictKind.CONTAINERS_AND_TYPES : this.myStrictKind;
        TypeScriptQualifiedNameResolver typeScriptQualifiedNameResolver = new TypeScriptQualifiedNameResolver(newContext, newStrictKind, this.myIncludeAugmentations);
        if (typeScriptQualifiedNameResolver == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(7);
        }
        return typeScriptQualifiedNameResolver;
    }

    @Override
    protected boolean isStrictTypeContext() {
        return this.myStrictKind == StrictKind.CONTAINERS_AND_TYPES || this.myStrictKind == StrictKind.TYPES;
    }

    @Override
    @NotNull
    public final Collection<PsiElement> getTopLevelElements(@NotNull String name, boolean isQualifier) {
        Collection<PsiElement> modules;
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(8);
        }
        if ((modules = this.resolveImportedModuleType(name)) != null) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(9);
            }
            return collection;
        }
        if (name.startsWith("module:")) {
            Collection<PsiElement> collection = this.getTopAmbientModules(name);
            if (collection == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(10);
            }
            return collection;
        }
        Collection<PsiElement> collection = this.getTopLevelElementsWalkUp(name, isQualifier);
        if (collection == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    private Collection<PsiElement> getTopAmbientModules(@NotNull String name) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        List result2 = ContainerUtil.newSmartList();
        PsiElement externalModule = ES6PsiUtil.findExternalModule(this.myContext, false);
        if (externalModule instanceof TypeScriptModule && TypeScriptAugmentationUtil.isExternalModuleAugmentation(externalModule) && name.equals(((TypeScriptModule)externalModule).getQualifiedName())) {
            result2.addAll(TypeScriptAugmentationUtil.resolveAugmentation(externalModule));
            result2.add(externalModule);
            List list = result2;
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(13);
            }
            return list;
        }
        this.addMergedAndGlobalElements(name, this.myContext, result2, true);
        List list = result2;
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private Collection<PsiElement> getTopLevelElementsWalkUp(@NotNull String name, boolean isQualifier) {
        Collection localClasses;
        PsiFile containingFile;
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(15);
        }
        PsiElement source = this.myContext;
        JSElement moduleParent = ES6PsiUtil.getNonStrictExportScope(source);
        if (this.myCheckLocalClasses && (containingFile = source.getContainingFile()) != null && (localClasses = (Collection)AstLoadingFilter.forceAllowTreeLoading((PsiFile)containingFile, () -> {
            if (name == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(57);
            }
            return TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, (PsiElement)moduleParent, source.getParent());
        })) != null) {
            ArrayList elements = ContainerUtil.newArrayList((Iterable)localClasses);
            this.addMergedAndGlobalElements(TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)moduleParent), source, elements, true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule((PsiElement)moduleParent);
        boolean isModule = moduleParent instanceof TypeScriptModule || isParentExternalFileModule;
        TypeScriptModuleDeclarationsProcessor processor = this.createWalkUpTopElementsProcessor(name);
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        JSElement module = moduleParent;
        while (module != null) {
            JSElement originalCurrentModule = module;
            if (module instanceof TypeScriptModule && ((TypeScriptModule)module).isAugmentation()) {
                module = TypeScriptQualifiedNameResolver.getOriginalModuleForAugmentation(module);
            }
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope(module, processor, false);
            List<PsiElement> possibleResults = processor.getResults();
            if (!possibleResults.isEmpty()) {
                if (isParentExternalFileModule) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations((PsiElement)module, possibleResults, source, processor);
                    ArrayList results = ContainerUtil.newArrayList(processor.getResults());
                    TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(source, results);
                    ArrayList arrayList = results;
                    if (arrayList == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(17);
                    }
                    return arrayList;
                }
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getLocalElements((PsiElement)module, possibleResults);
                if (!isQualifier && isModule && !ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(18);
                    }
                    return collection;
                }
                result2.addAll(possibleResults);
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)module);
            this.addMergedAndGlobalElements(qName, source, result2, false);
            if (!isQualifier && !result2.isEmpty()) break;
            module = ES6PsiUtil.getExportScope((PsiElement)originalCurrentModule);
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(19);
        }
        return linkedHashSet;
    }

    @NotNull
    private static JSElement getOriginalModuleForAugmentation(@NotNull JSElement startModule) {
        if (startModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(20);
        }
        Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation((PsiElement)startModule);
        for (PsiElement element : elements) {
            if (!(element instanceof JSElement)) continue;
            JSElement jSElement = (JSElement)element;
            if (jSElement == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(21);
            }
            return jSElement;
        }
        JSElement jSElement = startModule;
        if (jSElement == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        return jSElement;
    }

    @NotNull
    protected TypeScriptModuleDeclarationsProcessor createWalkUpTopElementsProcessor(@NotNull String name) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(23);
        }
        TypeScriptModuleDeclarationsProcessor typeScriptModuleDeclarationsProcessor = new TypeScriptModuleDeclarationsProcessor(name, this.isStrictTypeContext(), false);
        if (typeScriptModuleDeclarationsProcessor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        return typeScriptModuleDeclarationsProcessor;
    }

    @Nullable
    private static Collection<PsiElement> getLocalElements(@NotNull PsiElement module, @NotNull List<? extends PsiElement> possibleResults) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(26);
        }
        ArrayList notPublic = null;
        for (PsiElement psiElement : possibleResults) {
            JSAttributeList list;
            if (!(psiElement instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)psiElement).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, psiElement)) continue;
            if (notPublic == null) {
                notPublic = ContainerUtil.newArrayList();
            }
            notPublic.add(psiElement);
        }
        return notPublic;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSFile && ((JSFile)module).isCommonJSModule() || ES6PsiUtil.isEmbeddedModule(module);
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, @Nullable PsiElement module, @Nullable PsiElement parent) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if (module == parent || module == source) {
            return null;
        }
        if (TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            return null;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptQualifiedNameResolver.getLocalClassesForName(name, source);
        if (elements.size() == 0) {
            return null;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result2.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result2.add(element);
                }
            }
            if (result2.isEmpty()) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static Collection<JSQualifiedNamedElement> getLocalClassesForName(@NotNull String name, @NotNull PsiElement source) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(29);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(30);
        }
        List result2 = ContainerUtil.newSmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        JSStubBasedPsiTreeUtil.processElementsForFile(TypeScriptLocalClassIndex.KEY, name, source.getProject(), source.getContainingFile(), JSQualifiedNamedElement.class, processor);
        List list = result2;
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @NotNull
    public final Collection<PsiElement> postProcessResults(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(32);
        }
        Collection<PsiElement> results = super.postProcessResults(elements);
        boolean checkType = this.myStrictKind == StrictKind.TYPES;
        StreamEx stream = (StreamEx)StreamEx.of(results).filter(el -> (!checkType || TypeScriptPsiUtil.isNamedTypeDefinition(el)) && TypeScriptQualifiedNameResolver.checkModulesAccess(this.myContext, el));
        List list = stream.toList();
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file2;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file2 = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file2);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private void addMergedAndGlobalElements(@NotNull String qName, @NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2, boolean modulesOnly) {
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(34);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(35);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(36);
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(qName, currentSource);
        Condition condition = element -> {
            if (currentSource == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(55);
            }
            if (result2 == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(56);
            }
            return TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, result2, modulesOnly);
        };
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        result2.addAll(filteredElements);
        if (this.myIncludeAugmentations) {
            TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(currentSource, result2);
        }
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull List<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor) {
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(37);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(38);
        }
        if (realPlace == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(40);
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, false);
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2, boolean modulesOnly) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(41);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(42);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(43);
        }
        if (result2.contains(element)) {
            return false;
        }
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return true;
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptQualifiedNameResolver.checkModulesAccess(currentSource, (PsiElement)element);
        }
        PsiElement externalSourceModule = ES6PsiUtil.findExternalModule(currentSource);
        if (!(TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) || TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, currentSource) || TypeScriptQualifiedNameResolver.checkGlobalAugmentation((PsiElement)element))) {
            return false;
        }
        return TypeScriptQualifiedNameResolver.checkModulesAccess(currentSource, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean checkGlobalAugmentation(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(44);
        }
        JSElement scope = ES6PsiUtil.getExportScope(element);
        while (scope instanceof TypeScriptModule && !((TypeScriptModule)scope).isGlobalScopeAugmentation()) {
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
        return scope instanceof TypeScriptModule && ((TypeScriptModule)scope).isGlobalScopeAugmentation();
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private static void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(45);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(46);
        }
        if (result2.size() > 0 && !(externalModules = TypeScriptQualifiedNameResolver.getModulesForAugmentations(result2)).isEmpty()) {
            result2.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    private static Collection<PsiElement> getModulesForAugmentations(@NotNull Collection<PsiElement> result2) {
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(47);
        }
        ArrayList modules = ContainerUtil.newArrayList();
        for (PsiElement element : result2) {
            TypeScriptModule typeScriptModule;
            String refName;
            TypeScriptExportAssignment assignment;
            PsiElement module;
            if (ES6PsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || (module = ES6PsiUtil.findExternalModule(element)) == null || (assignment = TypeScriptPsiUtil.findExportAssignment(module)) == null || !StringUtil.equals((CharSequence)(refName = assignment.getInitializerReference()), (CharSequence)TypeScriptQualifiedNameResolver.getQualifiedNameWithoutParentModule(typeScriptModule = (TypeScriptModule)element, module))) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static String getQualifiedNameWithoutParentModule(@NotNull TypeScriptModule module, @NotNull PsiElement externalModule) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(48);
        }
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(49);
        }
        String moduleQualifiedName = module.getQualifiedName();
        if (externalModule instanceof TypeScriptModule) {
            String name = ((TypeScriptModule)externalModule).getQualifiedName();
            if (moduleQualifiedName == null || name == null) {
                return moduleQualifiedName;
            }
            int indexOfExternalModule = moduleQualifiedName.indexOf(name);
            if (indexOfExternalModule != -1) {
                int position = indexOfExternalModule + name.length() + 1;
                return position < moduleQualifiedName.length() ? moduleQualifiedName.substring(position) : moduleQualifiedName;
            }
        }
        return moduleQualifiedName;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(50);
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        PsiElement sourceContainer;
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(51);
        }
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(52);
        }
        if (TypeScriptPsiUtil.isAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || TypeScriptPsiUtil.isAugmentationModule(element) || TypeScriptPsiUtil.isAugmentationModule(element);
    }

    public static boolean checkModulesAccess(@NotNull PsiElement source, @NotNull PsiElement element) {
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(53);
        }
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(54);
        }
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 23: 
            case 27: 
            case 29: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startModule";
                break;
            }
            case 25: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 26: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 28: 
            case 30: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 35: 
            case 42: 
            case 45: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSource";
                break;
            }
            case 36: 
            case 43: 
            case 46: 
            case 47: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 37: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModule";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realPlace";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 41: 
            case 44: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedResolver";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopAmbientModules";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElementsWalkUp";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalModuleForAugmentation";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createWalkUpTopElementsProcessor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalClassesForName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNestedResolver";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 33: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTopAmbientModules";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElementsWalkUp";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalModuleForAugmentation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createWalkUpTopElementsProcessor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesIfExists";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesForName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "postProcessResults";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addMergedAndGlobalElements";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addMergedElementsFromAugmentations";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMergeSymbol";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkGlobalAugmentation";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addAugmentationsForModuleResults";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForAugmentations";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameWithoutParentModule";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameForModule";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkAugmentationAccess";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkModulesAccess";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMergedAndGlobalElements$2";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTopLevelElementsWalkUp$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum StrictKind {
        OBJECTS_WITH_FIELDS,
        OBJECTS,
        CONTAINERS_AND_TYPES,
        TYPES;

    }
}

