/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMembersFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ES6ClassMemberCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement parent;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((parent = parameters.getPosition().getParent()) instanceof JSField)) {
            return;
        }
        JSField field = (JSField)parent;
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)field);
        if (containingClass == null) {
            return;
        }
        final HashSet existingMembers = ContainerUtil.newHashSet();
        for (JSElement o : containingClass.getMembers()) {
            String name = o.getName();
            if (name == null) continue;
            existingMembers.add(name);
        }
        final HashMap forCompletion = ContainerUtil.newHashMap();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (aClass.isEquivalentTo((PsiElement)containingClass)) {
                    return true;
                }
                for (JSFunction function : aClass.getFunctions()) {
                    JSContext jsContext;
                    String name;
                    JSAttributeList attributeList;
                    if (function.isConstructor() || (attributeList = function.getAttributeList()) != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || (name = function.getName()) == null || existingMembers.contains(name) || forCompletion.containsKey(name) || (jsContext = function.getJSContext()) == JSContext.STATIC) continue;
                    forCompletion.put(name, function);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        boolean useOverridesCompletion = JSApplicationSettings.getInstance().isUseOverridesCompletion();
        forCompletion.values().forEach(el -> {
            if (result2 == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(28);
            }
            result2.consume(ES6ClassMemberCompletionProvider.createLookupElement(el, containingClass, useOverridesCompletion));
        });
    }

    private static LookupElement createLookupElement(@NotNull JSElement function, @NotNull JSClass<?> containingClass, boolean useOverridesCompletion) {
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(4);
        }
        String name = function.getName();
        assert (name != null);
        LookupElementBuilder element = LookupElementBuilder.create((Object)function, (String)name);
        if (!useOverridesCompletion) {
            return element;
        }
        return element.withPresentableText(" " + name + "(...) {...}").withIcon(ES6ClassMemberCompletionProvider.getIcon((PsiElement)function, containingClass)).withInsertHandler(ES6ClassMemberCompletionProvider.createInsertHandler((PsiElement)function, containingClass, name));
    }

    private static Icon getIcon(@NotNull PsiElement psiElement, @NotNull PsiElement classOfInsertionContext) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(5);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(6);
        }
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && sourceClass.isInterface()) {
            return AllIcons.General.ImplementingMethod;
        }
        return AllIcons.General.OverridingMethod;
    }

    static InsertHandler<LookupElement> createInsertHandler(final @NotNull PsiElement psiElement, @NotNull PsiElement classOfInsertionContext, @NotNull String name) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(7);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(8);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(9);
        }
        if (!(psiElement instanceof JSFunction)) {
            return (context, item) -> {};
        }
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && !sourceClass.isInterface()) {
            return (context, item) -> {
                if (classOfInsertionContext == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(25);
                }
                if (psiElement == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(26);
                }
                if (name == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(27);
                }
                OverrideMethodsFix fix = new OverrideMethodsFix((JSClass)classOfInsertionContext){

                    @Override
                    public Set<JSFunction> getElementsToProcess() {
                        return ContainerUtil.set((Object[])new JSFunction[]{(JSFunction)psiElement});
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((JSFunction)psiElement, name, context, fix, classOfInsertionContext);
            };
        }
        if (psiElement instanceof TypeScriptFunction) {
            return (ctx, item) -> {
                if (classOfInsertionContext == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(22);
                }
                if (psiElement == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(23);
                }
                if (name == null) {
                    ES6ClassMemberCompletionProvider.$$$reportNull$$$0(24);
                }
                TypeScriptImplementMembersFix fix = new TypeScriptImplementMembersFix(classOfInsertionContext, false){

                    @Override
                    public Set<TypeScriptFunction> getElementsToProcess() {
                        return ContainerUtil.set((Object[])new TypeScriptFunction[]{(TypeScriptFunction)psiElement});
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((TypeScriptFunction)psiElement, name, ctx, fix, classOfInsertionContext);
            };
        }
        return (ctx, item) -> {
            if (classOfInsertionContext == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(19);
            }
            if (psiElement == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(20);
            }
            if (name == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(21);
            }
            String bodyText = ImplementJSDocMethodsFix.formatFunction(classOfInsertionContext, psiElement.getProject(), new JSMethodToImplement((JSPsiElementBase)((JSFunction)psiElement), false, ""));
            ES6ClassMemberCompletionProvider.insertFunctionText(name, ctx, bodyText, classOfInsertionContext);
        };
    }

    private static <T extends JSElement> void insertFunctionText(@NotNull T function, @NotNull String name, @NotNull InsertionContext context, @NotNull BaseCreateMembersFix<T> fix, @NotNull PsiElement classOfInsertionContext) {
        String functionText;
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(12);
        }
        if (fix == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(13);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(14);
        }
        if ((functionText = fix.buildFunctionText(function, null)) != null) {
            ES6ClassMemberCompletionProvider.insertFunctionText(name, context, functionText, classOfInsertionContext);
        }
    }

    private static void insertFunctionText(@NotNull String name, @NotNull InsertionContext context, @NotNull String functionText, @NotNull PsiElement classOfInsertionContext) {
        int indexOfName;
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(15);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(16);
        }
        if (functionText == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(17);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(18);
        }
        String prefix = (indexOfName = functionText.indexOf(name + "(")) > 0 ? functionText.substring(0, indexOfName) : "";
        String restText = functionText.substring(prefix.length() + name.length());
        int startOffset = context.getEditor().getCaretModel().getOffset();
        Document document = context.getDocument();
        document.insertString(startOffset, (CharSequence)restText);
        if (!prefix.isEmpty()) {
            String toInsert = classOfInsertionContext instanceof JSObjectLiteralExpression ? (prefix.trim().endsWith("*") ? "*" : "") : prefix;
            document.insertString(context.getStartOffset(), (CharSequence)toInsert);
            startOffset = context.getStartOffset();
        }
        context.commitDocument();
        FormatFixer.create(context.getFile(), new TextRange(startOffset, startOffset + restText.length() + prefix.length() + (prefix.isEmpty() ? 0 : name.length())), document, FormatFixer.Mode.Reformat).fixFormat();
        JSFunction func = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(startOffset), JSFunction.class);
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)func, JSBlockStatement.class);
        if (block != null) {
            JSStatement[] statements = block.getStatements();
            if (statements.length == 1) {
                JSStatement statement = statements[0];
                TextRange range = statement.getTextRange();
                context.getEditor().getCaretModel().moveToOffset(range.getStartOffset());
                context.getEditor().getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            } else {
                context.getEditor().getCaretModel().moveToOffset(block.getFirstChild().getTextOffset() + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 5: 
            case 7: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOfInsertionContext";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createInsertHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "insertFunctionText";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createInsertHandler$4";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createInsertHandler$3";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createInsertHandler$2";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addCompletions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

