/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.popup.MovablePopup;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.MouseEventHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExpandableItemsHandler<KeyType, ComponentType extends JComponent>
implements ExpandableItemsHandler<KeyType> {
    protected final ComponentType myComponent;
    private final Alarm myUpdateAlarm;
    private final CellRendererPane myRendererPane;
    private final JComponent myTipComponent;
    private boolean myEnabled;
    private final MovablePopup myPopup;
    private KeyType myKey;
    private Rectangle myKeyItemBounds;
    private BufferedImage myImage;

    public static void setRelativeBounds(@NotNull Component parent, @NotNull Rectangle bounds2, @NotNull Component child2, @NotNull Container validationParent) {
        if (parent == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(0);
        }
        if (bounds2 == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(1);
        }
        if (child2 == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(2);
        }
        if (validationParent == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(3);
        }
        validationParent.add(parent);
        parent.setBounds(bounds2);
        parent.validate();
        child2.setLocation(SwingUtilities.convertPoint(child2, 0, 0, parent));
        validationParent.remove(parent);
    }

    protected AbstractExpandableItemsHandler(@NotNull ComponentType component) {
        if (component == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(4);
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myRendererPane = new CellRendererPane();
        this.myTipComponent = new JComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                Insets insets = this.getInsets();
                Graphics2D g2d = (Graphics2D)g;
                double scale = JBUI.sysScale((Graphics2D)((Graphics2D)g));
                double devTop = (double)insets.top * scale;
                if (devTop + 0.5 == Math.floor(devTop + 0.5)) {
                    g2d = (Graphics2D)g2d.create();
                    double devPix = 1.0 / scale;
                    g2d.translate(0.0, -devPix);
                }
                try {
                    UIUtil.drawImage((Graphics)g2d, (Image)AbstractExpandableItemsHandler.this.myImage, (int)insets.left, (int)insets.top, null);
                }
                finally {
                    if (g2d != g) {
                        g2d.dispose();
                    }
                }
            }
        };
        this.myEnabled = Registry.is((String)"ide.expansion.hints.enabled");
        this.myComponent = component;
        ((Container)this.myComponent).add(this.myRendererPane);
        ((Container)this.myComponent).validate();
        this.myPopup = new MovablePopup((Component)this.myComponent, this.myTipComponent);
        MouseEventHandler dispatcher = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                ((Component)AbstractExpandableItemsHandler.this.myComponent).dispatchEvent(MouseEventAdapter.convert((MouseEvent)event, AbstractExpandableItemsHandler.this.myComponent));
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (((Component)AbstractExpandableItemsHandler.this.myComponent).getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        this.myTipComponent.addMouseListener((MouseListener)dispatcher);
        this.myTipComponent.addMouseMotionListener((MouseMotionListener)dispatcher);
        this.myTipComponent.addMouseWheelListener((MouseWheelListener)dispatcher);
        MouseEventHandler handler2 = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(event, 503 != event.getID());
            }

            public void mouseClicked(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (Registry.is((String)"ide.hide.expandable.tooltip.owner.mouse.exit") || AbstractExpandableItemsHandler.this.myTipComponent.getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        ((Component)this.myComponent).addMouseListener((MouseListener)handler2);
        ((Component)this.myComponent).addMouseMotionListener((MouseMotionListener)handler2);
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractExpandableItemsHandler.this.onFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }
        });
    }

    protected void onFocusLost() {
        this.hideHint();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        if (!this.myEnabled) {
            this.hideHint();
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public Collection<KeyType> getExpandedItems() {
        Collection<Object> collection = this.myKey == null ? Collections.emptyList() : Collections.singleton(this.myKey);
        if (collection == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(5);
        }
        return collection;
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.myKey, true);
    }

    protected void handleMouseEvent(MouseEvent e, boolean forceUpdate) {
        KeyType selected = this.getCellKeyForPoint(e.getPoint());
        if (forceUpdate || !Comparing.equal(this.myKey, selected)) {
            this.handleSelectionChange(selected, true);
        }
        if (e.getClickCount() == 2) {
            this.hideHint();
        }
    }

    protected void handleSelectionChange(KeyType selected) {
        this.handleSelectionChange(selected, false);
    }

    protected void handleSelectionChange(KeyType selected, boolean processIfUnfocused) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        if (selected == null || !this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        if (!selected.equals(this.myKey)) {
            this.hideHint();
        }
        this.myUpdateAlarm.addRequest(() -> this.doHandleSelectionChange(selected, processIfUnfocused), 10);
    }

    private boolean isHandleSelectionEnabled(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (selected == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(6);
        }
        return this.myEnabled && ((Component)this.myComponent).isEnabled() && ((Component)this.myComponent).isShowing() && ((JComponent)this.myComponent).getVisibleRect().intersects(this.getVisibleRect(selected)) && (processIfUnfocused || ((Component)this.myComponent).isFocusOwner());
    }

    private void doHandleSelectionChange(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (selected == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(7);
        }
        if (!this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        this.myKey = selected;
        Point location = this.createToolTipImage(this.myKey);
        if (location == null) {
            this.hideHint();
        } else {
            Rectangle bounds2 = new Rectangle(location, this.myTipComponent.getPreferredSize());
            this.myPopup.setBounds(bounds2);
            this.myPopup.onAncestorFocusLost(() -> this.onFocusLost());
            this.myPopup.setVisible(this.noIntersections(bounds2));
            this.repaintKeyItem();
        }
    }

    protected boolean isPopup() {
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        return window != null && !(window instanceof Dialog) && !(window instanceof Frame) && !AbstractExpandableItemsHandler.isHintsAllowed(window);
    }

    private static boolean isHintsAllowed(Window window) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return Boolean.TRUE.equals(pane.getClientProperty("ShowHints"));
        }
        return false;
    }

    private static boolean isFocused(Window window) {
        return window != null && (window.isFocused() || AbstractExpandableItemsHandler.isFocused(window.getOwner()));
    }

    private boolean noIntersections(Rectangle bounds2) {
        Window owner = SwingUtilities.getWindowAncestor(this.myComponent);
        Window popup2 = SwingUtilities.getWindowAncestor(this.myTipComponent);
        Window focus = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (focus == owner.getOwner()) {
            focus = null;
        }
        boolean focused = SystemInfo.isWindows || AbstractExpandableItemsHandler.isFocused(owner);
        for (Window other : owner.getOwnedWindows()) {
            if (!focused) {
                focused = other.isFocused();
            }
            if (popup2 != other && other.isVisible() && bounds2.x + 10 >= other.getX() && bounds2.intersects(other.getBounds())) {
                return false;
            }
            if (focus != other) continue;
            focus = null;
        }
        return focused && (focus == owner || focus == null || !owner.getBounds().intersects(focus.getBounds()));
    }

    private void hideHint() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myPopup.isVisible()) {
            this.myPopup.setVisible(false);
            this.repaintKeyItem();
        }
        this.myKey = null;
    }

    public boolean isShowing() {
        return this.myPopup.isVisible();
    }

    private void repaintKeyItem() {
        if (this.myKeyItemBounds != null) {
            ((JComponent)this.myComponent).repaint(this.myKeyItemBounds);
        }
    }

    @Nullable
    private Point createToolTipImage(@NotNull KeyType key) {
        if (key == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(8);
        }
        UIUtil.putClientProperty(this.myComponent, (Key)EXPANDED_RENDERER, (Object)true);
        Pair<Component, Rectangle> rendererAndBounds = this.getCellRendererAndBounds(key);
        UIUtil.putClientProperty(this.myComponent, (Key)EXPANDED_RENDERER, null);
        if (rendererAndBounds == null) {
            return null;
        }
        JComponent renderer = (JComponent)ObjectUtils.tryCast((Object)rendererAndBounds.first, JComponent.class);
        if (renderer == null) {
            return null;
        }
        if (UIUtil.isClientPropertyTrue((Object)renderer, (Object)RENDERER_DISABLED)) {
            return null;
        }
        if (UIUtil.isClientPropertyTrue((Object)rendererAndBounds.getFirst(), (Object)USE_RENDERER_BOUNDS)) {
            ((Rectangle)rendererAndBounds.getSecond()).translate(renderer.getX(), renderer.getY());
            ((Rectangle)rendererAndBounds.getSecond()).setSize(renderer.getSize());
        }
        Rectangle cellBounds = this.myKeyItemBounds = (Rectangle)rendererAndBounds.second;
        Rectangle visibleRect = this.getVisibleRect(key);
        if (cellBounds.y < visibleRect.y) {
            return null;
        }
        int cellMaxY = cellBounds.y + cellBounds.height;
        int visMaxY = visibleRect.y + visibleRect.height;
        if (cellMaxY > visMaxY) {
            return null;
        }
        int cellMaxX = cellBounds.x + cellBounds.width;
        int visMaxX = visibleRect.x + visibleRect.width;
        Point location = new Point(visMaxX, cellBounds.y);
        SwingUtilities.convertPointToScreen(location, this.myComponent);
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)location);
        int borderWidth = this.isPaintBorder() ? 1 : 0;
        int width = Math.min(screen.width + screen.x - location.x - borderWidth, cellMaxX - visMaxX);
        int height = cellBounds.height;
        if (width <= 0 || height <= 0) {
            return null;
        }
        Dimension size = this.getImageSize(width, height);
        this.myImage = UIUtil.createImage(this.myComponent, (int)size.width, (int)size.height, (int)1);
        Graphics2D g = this.myImage.createGraphics();
        g.setClip(null);
        this.doFillBackground(height, width, g);
        g.translate(cellBounds.x - visMaxX, 0);
        this.doPaintTooltipImage(renderer, cellBounds, g, key);
        CustomLineBorder border = null;
        if (borderWidth > 0) {
            border = new CustomLineBorder(this.getBorderColor(), borderWidth, 0, borderWidth, borderWidth);
            Insets insets = border.getBorderInsets((Component)this.myTipComponent);
            location.y -= insets.top;
            JBInsets.addTo((Dimension)size, (Insets)insets);
        }
        g.dispose();
        this.myRendererPane.remove(renderer);
        this.myTipComponent.setBorder((Border)border);
        this.myTipComponent.setPreferredSize(size);
        return location;
    }

    protected boolean isPaintBorder() {
        return true;
    }

    protected Color getBorderColor() {
        return JBColor.border();
    }

    protected Dimension getImageSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected void doFillBackground(int height, int width, Graphics2D g) {
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
    }

    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g, KeyType key) {
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, cellBounds.height, true);
    }

    protected Rectangle getVisibleRect(KeyType key) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    @Nullable
    protected abstract Pair<Component, Rectangle> getCellRendererAndBounds(KeyType var1);

    protected abstract KeyType getCellKeyForPoint(Point var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AbstractExpandableItemsHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AbstractExpandableItemsHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRelativeBounds";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isHandleSelectionEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doHandleSelectionChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createToolTipImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

