/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserModuleNode
extends ChangesBrowserNode<Module> {
    @NotNull
    private final FilePath myModuleRoot;

    protected ChangesBrowserModuleNode(Module userObject) {
        super(userObject);
        this.myModuleRoot = ChangesBrowserModuleNode.getModuleRootFilePath(userObject);
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Module module = (Module)this.userObject;
        renderer.append(module.isDisposed() ? "" : module.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        this.appendParentPath(renderer, this.myModuleRoot);
        if (module.isDisposed()) {
            renderer.setIcon(ModuleType.EMPTY.getIcon());
        } else {
            renderer.setIcon(ModuleType.get((Module)module).getIcon());
        }
    }

    @NotNull
    public FilePath getModuleRoot() {
        FilePath filePath = this.myModuleRoot;
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(0);
        }
        return filePath;
    }

    @Override
    public String getTextPresentation() {
        return ((Module)this.getUserObject()).getName();
    }

    @Override
    public int getSortWeight() {
        return 4;
    }

    @Override
    public int compareUserObjects(Module o2) {
        return ((Module)this.getUserObject()).getName().compareToIgnoreCase(o2.getName());
    }

    @NotNull
    private static FilePath getModuleRootFilePath(Module module) {
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 1) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)roots[0]);
            if (filePath == null) {
                ChangesBrowserModuleNode.$$$reportNull$$$0(1);
            }
            return filePath;
        }
        FilePath filePath = VcsUtil.getFilePath((String)ModuleUtilCore.getModuleDirPath((Module)module));
        if (filePath == null) {
            ChangesBrowserModuleNode.$$$reportNull$$$0(2);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserModuleNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootFilePath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

