/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.componentsList.layout;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;

public abstract class Orientation {
    public static Orientation VERTICAL = new Orientation(){

        @Override
        public int getExtent(Insets insets) {
            return insets.top + insets.bottom;
        }

        @Override
        public Orientation getContrary() {
            return HORIZONTAL;
        }

        @Override
        public int getExtent(Container container) {
            return container.getHeight();
        }

        @Override
        public void advance(Point point, int width, int height) {
            point.y += height;
        }

        @Override
        public boolean isVertical() {
            return true;
        }

        @Override
        public void extend(Dimension dimension, int extend) {
            dimension.height += extend;
        }

        @Override
        public void expandInline(Dimension dimension, Dimension extend) {
            dimension.height += extend.height;
            dimension.width = Math.max(dimension.width, extend.width);
        }
    };
    public static Orientation HORIZONTAL = new Orientation(){

        @Override
        public int getExtent(Insets insets) {
            return insets.left + insets.right;
        }

        @Override
        public Orientation getContrary() {
            return VERTICAL;
        }

        @Override
        public int getExtent(Container container) {
            return container.getWidth();
        }

        @Override
        public void advance(Point point, int width, int height) {
            point.x += width;
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public void extend(Dimension dimension, int extend) {
            dimension.width += extend;
        }

        @Override
        public void expandInline(Dimension dimension, Dimension extend) {
            dimension.width += extend.width;
            dimension.height = Math.max(dimension.height, extend.height);
        }
    };

    public int getInnerExtent(Container container) {
        return this.getExtent(container) - this.getExtent(container.getInsets());
    }

    public abstract int getExtent(Insets var1);

    public abstract Orientation getContrary();

    public abstract int getExtent(Container var1);

    public abstract void advance(Point var1, int var2, int var3);

    public abstract boolean isVertical();

    public abstract void extend(Dimension var1, int var2);

    public abstract void expandInline(Dimension var1, Dimension var2);
}

