/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.impl.AppUIExecutorEx;
import com.intellij.openapi.application.impl.AppUIExecutorImpl;
import com.intellij.openapi.application.impl.AsyncExecution;
import com.intellij.openapi.application.impl.AsyncExecutionSupport;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B%\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0011\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/application/impl/AppUIExecutorImpl;", "Lcom/intellij/openapi/application/impl/AsyncExecutionSupport;", "Lcom/intellij/openapi/application/impl/AppUIExecutorEx;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/intellij/openapi/application/ModalityState;)V", "myModality", "disposables", "", "Lcom/intellij/openapi/Disposable;", "dispatcher", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "(Lcom/intellij/openapi/application/ModalityState;Ljava/util/Set;Lkotlinx/coroutines/experimental/CoroutineDispatcher;)V", "getDispatcher", "()Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "getDisposables", "()Ljava/util/Set;", "cloneWith", "inSmartMode", "Lcom/intellij/openapi/application/AppUIExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "inTransaction", "parentDisposable", "inUndoTransparentAction", "inWriteAction", "later", "withDocumentsCommitted", "intellij.platform.ide.impl"})
public final class AppUIExecutorImpl
extends AsyncExecutionSupport<AppUIExecutorEx>
implements AppUIExecutorEx {
    private final ModalityState myModality;
    @NotNull
    private final Set<Disposable> disposables;
    @NotNull
    private final CoroutineDispatcher dispatcher;

    @Override
    @NotNull
    protected AppUIExecutorImpl cloneWith(@NotNull Set<? extends Disposable> disposables, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull(disposables, (String)"disposables");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        return new AppUIExecutorImpl(this.myModality, disposables, dispatcher);
    }

    @NotNull
    public AppUIExecutor later() {
        Integer n;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
            n = ideEventQueue.getEventCount();
        } else {
            n = null;
        }
        Integer edtEventCount = n;
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(this, edtEventCount){
            private volatile boolean usedOnce;
            final /* synthetic */ AppUIExecutorImpl this$0;
            final /* synthetic */ Integer $edtEventCount;

            public final boolean getUsedOnce() {
                return this.usedOnce;
            }

            public final void setUsedOnce(boolean bl) {
                this.usedOnce = bl;
            }

            public boolean isCorrectContext() {
                boolean bl;
                if (this.$edtEventCount == null) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    bl = application.isDispatchThread();
                } else {
                    Integer n = this.$edtEventCount;
                    IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideEventQueue, (String)"IdeEventQueue.getInstance()");
                    int n2 = ideEventQueue.getEventCount();
                    bl = n == null || n != n2 || this.usedOnce;
                }
                return bl;
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().invokeLater(new Runnable(this, runnable2){
                    final /* synthetic */ later.1 this$0;
                    final /* synthetic */ Runnable $runnable;

                    public final void run() {
                        this.this$0.setUsedOnce(true);
                        this.$runnable.run();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runnable = runnable2;
                    }
                }, AppUIExecutorImpl.access$getMyModality$p(this.this$0));
            }

            @NotNull
            public String toString() {
                return "later";
            }
            {
                this.this$0 = $outer;
                this.$edtEventCount = $captured_local_variable$1;
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.SimpleContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        });
    }

    @NotNull
    public AppUIExecutor withDocumentsCommitted(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.ExpirableContextConstraint(this, project){
            @NotNull
            private final Project expirable;
            final /* synthetic */ AppUIExecutorImpl this$0;
            final /* synthetic */ Project $project;

            @NotNull
            public Project getExpirable() {
                return this.expirable;
            }

            public boolean isCorrectContext() {
                return !PsiDocumentManager.getInstance((Project)this.$project).hasUncommitedDocuments();
            }

            public void scheduleExpirable(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                PsiDocumentManager.getInstance((Project)this.$project).performLaterWhenAllCommitted(runnable2, AppUIExecutorImpl.access$getMyModality$p(this.this$0));
            }

            @NotNull
            public String toString() {
                return "withDocumentsCommitted";
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.expirable = $captured_local_variable$1;
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.ExpirableContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        });
    }

    @NotNull
    public AppUIExecutor inSmartMode(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.ExpirableContextConstraint(project){
            @NotNull
            private final Project expirable;
            final /* synthetic */ Project $project;

            @NotNull
            public Project getExpirable() {
                return this.expirable;
            }

            public boolean isCorrectContext() {
                DumbService dumbService = DumbService.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(project)");
                return !dumbService.isDumb();
            }

            public void scheduleExpirable(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                DumbService.getInstance((Project)this.$project).runWhenSmart(runnable2);
            }

            @NotNull
            public String toString() {
                return "inSmartMode";
            }
            {
                this.$project = $captured_local_variable$0;
                this.expirable = $captured_local_variable$0;
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.ExpirableContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        });
    }

    @NotNull
    public AppUIExecutor inTransaction(@NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
        TransactionId id = transactionGuard.getContextTransaction();
        return ((AppUIExecutorEx)this.withConstraint(new AsyncExecution.SimpleContextConstraint(id){
            final /* synthetic */ TransactionId $id;

            public boolean isCorrectContext() {
                TransactionGuard transactionGuard = TransactionGuard.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)transactionGuard, (String)"TransactionGuard.getInstance()");
                return transactionGuard.getContextTransaction() != null;
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                TransactionGuard.getInstance().submitTransaction((Disposable)ApplicationManager.getApplication(), this.$id, runnable2);
            }

            @NotNull
            public String toString() {
                return "inTransaction";
            }
            {
                this.$id = $captured_local_variable$0;
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.SimpleContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        })).expireWith(parentDisposable);
    }

    @Override
    @NotNull
    public AppUIExecutor inUndoTransparentAction() {
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(){

            public boolean isCorrectContext() {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
                return commandProcessor.isUndoTransparentActionInProgress();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                CommandProcessor.getInstance().runUndoTransparentAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inUndoTransparentAction";
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.SimpleContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        });
    }

    @Override
    @NotNull
    public AppUIExecutor inWriteAction() {
        return (AppUIExecutor)this.withConstraint(new AsyncExecution.SimpleContextConstraint(){

            public boolean isCorrectContext() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return application.isWriteAccessAllowed();
            }

            public void schedule(@NotNull Runnable runnable2) {
                Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
                ApplicationManager.getApplication().runWriteAction(runnable2);
            }

            @NotNull
            public String toString() {
                return "inWriteAction";
            }

            @NotNull
            public CoroutineDispatcher toCoroutineDispatcher(@NotNull CoroutineDispatcher delegate) {
                Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
                return AsyncExecution.SimpleContextConstraint.DefaultImpls.toCoroutineDispatcher(this, delegate);
            }
        });
    }

    @Override
    @NotNull
    protected Set<Disposable> getDisposables() {
        return this.disposables;
    }

    @Override
    @NotNull
    protected CoroutineDispatcher getDispatcher() {
        return this.dispatcher;
    }

    private AppUIExecutorImpl(ModalityState myModality, Set<? extends Disposable> disposables, CoroutineDispatcher dispatcher) {
        this.myModality = myModality;
        this.disposables = disposables;
        this.dispatcher = dispatcher;
    }

    public AppUIExecutorImpl(final @NotNull ModalityState modality) {
        Intrinsics.checkParameterIsNotNull((Object)modality, (String)"modality");
        this(modality, SetsKt.emptySet(), new CoroutineDispatcher(){

            public boolean isDispatchNeeded(@NotNull CoroutineContext context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                return !application.isDispatchThread() || ModalityState.current().dominates(modality);
            }

            public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                ApplicationManager.getApplication().invokeLater(block, modality);
            }

            @NotNull
            public String toString() {
                return "onUiThread(" + modality + ')';
            }
        });
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        AppUIExecutorEx.DefaultImpls.execute(this, command);
    }

    @Override
    @NotNull
    public CancellablePromise<?> submit(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return AppUIExecutorEx.DefaultImpls.submit((AppUIExecutorEx)this, task);
    }

    @Override
    @NotNull
    public <T> CancellablePromise<T> submit(@NotNull Callable<T> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        return AppUIExecutorEx.DefaultImpls.submit((AppUIExecutorEx)this, task);
    }

    @NotNull
    public static final /* synthetic */ ModalityState access$getMyModality$p(AppUIExecutorImpl $this) {
        return $this.myModality;
    }
}

