/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;

public class RunIdeConsoleAction
extends DumbAwareAction {
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<WeakReference<RunContentDescriptor>> DESCRIPTOR_KEY = Key.create((String)"DESCRIPTOR_KEY");
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(0);
        }
        IdeScriptEngineManager manager = IdeScriptEngineManager.getInstance();
        e.getPresentation().setVisible(e.getProject() != null);
        e.getPresentation().setEnabled(manager.isInitialized() && !manager.getLanguages().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<String> languages;
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(1);
        }
        if ((languages = IdeScriptEngineManager.getInstance().getLanguages()).size() == 1) {
            this.runConsole(e, languages.iterator().next());
            return;
        }
        DefaultActionGroup actions = new DefaultActionGroup(ContainerUtil.map(languages, (Function)((NotNullFunction)language -> new DumbAwareAction((String)language, (String)language){
            final /* synthetic */ String val$language;
            {
                this.val$language = string;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e1) {
                if (e1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunIdeConsoleAction.this.runConsole(e1, this.val$language);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/execution/console/RunIdeConsoleAction$1", "actionPerformed"));
            }
        })));
        JBPopupFactory.getInstance().createActionGroupPopup("Script Engine", (ActionGroup)actions, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
    }

    protected void runConsole(@NotNull AnActionEvent e, @NotNull String language) {
        Project project;
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(2);
        }
        if (language == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<String> extensions = IdeScriptEngineManager.getInstance().getFileExtensions(language);
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(4);
        }
        if (source == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(5);
        }
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull IdeScriptEngine engine) {
        String command;
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(8);
        }
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmptyOrSpaces((String)(command = RunIdeConsoleAction.getCommandText(project, editor)))) {
            return;
        }
        String profile2 = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor = RunIdeConsoleAction.getConsoleView(project, file2);
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project, engine, descriptor);
        try {
            long ts = System.currentTimeMillis();
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile2 == null ? command : profile2 + "\n" + command;
            Object o = engine.eval(script);
            String prefix = "[" + StringUtil.formatDuration((long)(System.currentTimeMillis() - ts)) + "]";
            consoleView.print(prefix + "=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e) {
            Throwable ex = ExceptionUtil.getRootCause((Throwable)e);
            consoleView.print(ex.getClass().getSimpleName() + ": " + ex.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor);
    }

    private static void prepareEngine(@NotNull Project project, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(10);
        }
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(12);
        }
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(13);
        }
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize((String)VfsUtilCore.loadText(profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(15);
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.isEmpty()) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 != null && file2.getFirstChild() != null && file2.getFirstChild() != file2.getLastChild()) {
                PsiElement parent;
                PsiElement e1 = file2.findElementAt(selectedRange.getStartOffset());
                PsiElement e2 = file2.findElementAt(selectedRange.getEndOffset());
                while (e1 != e2 && (e1 instanceof PsiWhiteSpace || e1 != null && StringUtil.isEmptyOrSpaces((String)e1.getText()))) {
                    e1 = (PsiElement)ObjectUtils.chooseNotNull((Object)e1.getNextSibling(), (Object)PsiTreeUtil.getDeepestFirst((PsiElement)e1.getParent()));
                }
                while (e1 != e2 && (e2 instanceof PsiWhiteSpace || e2 != null && StringUtil.isEmptyOrSpaces((String)e2.getText()))) {
                    e2 = (PsiElement)ObjectUtils.chooseNotNull((Object)e2.getPrevSibling(), (Object)PsiTreeUtil.getDeepestLast((PsiElement)e2.getParent()));
                }
                if (e1 instanceof LeafPsiElement) {
                    e1 = e1.getParent();
                }
                if (e2 instanceof LeafPsiElement) {
                    e2 = e2.getParent();
                }
                PsiElement psiElement = e1 == null ? e2 : (parent = e2 == null ? e1 : PsiTreeUtil.findCommonParent((PsiElement)e1, (PsiElement)e2));
                if (parent != null && parent != file2) {
                    selectedRange = parent.getTextRange();
                }
            }
        }
        String string = document.getText(selectedRange);
        if (string == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void selectContent(RunContentDescriptor descriptor) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = (ConsoleViewImpl)ObjectUtils.assertNotNull((Object)((ConsoleViewImpl)descriptor.getExecutionConsole()));
        ExecutionManager.getInstance((Project)consoleView.getProject()).getContentManager().toFrontRunContent(executor, descriptor);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project, @NotNull VirtualFile file2) {
        PsiFile psiFile;
        WeakReference ref;
        RunContentDescriptor descriptor;
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(18);
        }
        RunContentDescriptor runContentDescriptor = descriptor = (ref = (WeakReference)(psiFile = (PsiFile)ObjectUtils.assertNotNull((Object)PsiManager.getInstance((Project)project).findFile(file2))).getCopyableUserData(DESCRIPTOR_KEY)) == null ? null : (RunContentDescriptor)ref.get();
        if (descriptor == null || descriptor.getExecutionConsole() == null) {
            descriptor = RunIdeConsoleAction.createConsoleView(project, psiFile);
            psiFile.putCopyableUserData(DESCRIPTOR_KEY, new WeakReference<RunContentDescriptor>(descriptor));
        }
        RunContentDescriptor runContentDescriptor2 = descriptor;
        if (runContentDescriptor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(19);
        }
        return runContentDescriptor2;
    }

    @NotNull
    private static RunContentDescriptor createConsoleView(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(20);
        }
        if (psiFile == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(21);
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunIdeConsole", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel2.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel2, psiFile.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.addAll(consoleView.createConsoleActions());
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(22);
        }
        return runContentDescriptor;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor) {
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(23);
        }
        if (descriptor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(24);
        }
        ConsoleWriter stdOutWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor);
        engine.setStdOut(new ConsoleWriter(ref, ConsoleViewContentType.NORMAL_OUTPUT));
        engine.setStdErr(new ConsoleWriter(ref, ConsoleViewContentType.ERROR_OUTPUT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/RunIdeConsoleAction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/RunIdeConsoleAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runConsole";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureConsole";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeQuery";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProfileText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCommandText";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleView";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "ensureOutputIsRedirected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConsoleWriter
    extends Writer {
        private final WeakReference<RunContentDescriptor> myDescriptor;
        private final ConsoleViewContentType myOutputType;

        private ConsoleWriter(@NotNull WeakReference<RunContentDescriptor> descriptor, @NotNull ConsoleViewContentType outputType) {
            if (descriptor == null) {
                ConsoleWriter.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ConsoleWriter.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor;
            this.myOutputType = outputType;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return (RunContentDescriptor)this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RunContentDescriptor descriptor = (RunContentDescriptor)this.myDescriptor.get();
            ConsoleViewImpl console = (ConsoleViewImpl)ObjectUtils.tryCast((Object)(descriptor != null ? descriptor.getExecutionConsole() : null), ConsoleViewImpl.class);
            if (console == null) {
                throw new IOException("The console is not available.");
            }
            console.print(new String(cbuf, off, len), this.myOutputType);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngine engine;

        private MyRunAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(project != null && editor != null && virtualFile != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (project == null || editor == null || virtualFile == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            String extension = virtualFile.getExtension();
            if (!(extension == null || this.engine != null && this.engine.getFileExtensions().contains(extension))) {
                this.engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension(extension, null);
            }
            if (this.engine == null) {
                LOG.warn("Script engine not found for: " + virtualFile.getName());
            } else {
                RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engine);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/console/RunIdeConsoleAction$MyRunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

