/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLScalarElementManipulator
extends AbstractElementManipulator<YAMLScalarImpl> {
    @NotNull
    public TextRange getRangeInElement(@NotNull YAMLScalarImpl element) {
        List<TextRange> ranges;
        if (element == null) {
            YAMLScalarElementManipulator.$$$reportNull$$$0(0);
        }
        if ((ranges = element.getContentRanges()).isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                YAMLScalarElementManipulator.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)ranges.get(0).getStartOffset(), (int)ranges.get(ranges.size() - 1).getEndOffset());
        if (textRange == null) {
            YAMLScalarElementManipulator.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public YAMLScalarImpl handleContentChange(@NotNull YAMLScalarImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            YAMLScalarElementManipulator.$$$reportNull$$$0(3);
        }
        if (range == null) {
            YAMLScalarElementManipulator.$$$reportNull$$$0(4);
        }
        try {
            List<Pair<TextRange, String>> encodeReplacements = element.getEncodeReplacements(newContent);
            StringBuilder builder = new StringBuilder();
            String oldText = element.getText();
            builder.append(oldText.subSequence(0, range.getStartOffset()));
            builder.append(YAMLScalarImpl.processReplacements(newContent, encodeReplacements));
            builder.append(oldText.subSequence(range.getEndOffset(), oldText.length()));
            YAMLFile dummyYamlFile = YAMLElementGenerator.getInstance(element.getProject()).createDummyYamlWithText(builder.toString());
            YAMLScalar newScalar = (YAMLScalar)PsiTreeUtil.collectElementsOfType((PsiElement)dummyYamlFile, (Class[])new Class[]{YAMLScalar.class}).iterator().next();
            PsiElement result = element.replace((PsiElement)newScalar);
            if (!(result instanceof YAMLScalarImpl)) {
                throw new AssertionError((Object)"Inserted YAML scalar, but it isn't a scalar after insertion :(");
            }
            return (YAMLScalarImpl)result;
        }
        catch (IllegalArgumentException e) {
            PsiElement newElement = element.replace((PsiElement)YAMLElementGenerator.getInstance(element.getProject()).createYamlDoubleQuotedString());
            if (!(newElement instanceof YAMLQuotedTextImpl)) {
                throw new AssertionError((Object)"Could not replace with dummy scalar");
            }
            return (YAMLScalarImpl)this.handleContentChange((PsiElement)((YAMLScalarImpl)newElement), newContent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

