/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasMethodCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;

public class RubyTargetElementUtil {
    private RubyTargetElementUtil() {
    }

    @Nullable
    public static RPsiElement getRubyNamedElement(PsiElement element) {
        RPsiElement rPsiElement = RubyPsiUtil.getCoveringRPsiElement(element);
        if (rPsiElement == null) {
            return null;
        }
        RAliasStatement rAliasStatement = RAliasStatementNavigator.getAliasByNewName((PsiElement)rPsiElement);
        if (rAliasStatement != null) {
            return rAliasStatement;
        }
        RCall rCall = RAliasMethodCallNavigator.getAliasMethodCallByNewName(rPsiElement);
        if (rCall != null) {
            return rCall;
        }
        if (rPsiElement instanceof RFName && RubyCallTypes.getDefinedAttributeName(rPsiElement.getParent()) != null) {
            return (RPsiElement)rPsiElement.getParent();
        }
        if (RubyCallTypes.getDefinedAttributeName((PsiElement)rPsiElement) != null || StructNewCallType.isClassName((PsiElement)rPsiElement)) {
            return rPsiElement;
        }
        if (RubyPsiUtil.isClassModuleOrMethodName((PsiElement)rPsiElement)) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, (Class[])new Class[]{RClass.class, RModule.class, RMethod.class, RSingletonMethod.class});
        }
        if (I18nProvider.isLocaleFile(element.getContainingFile())) {
            return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, RAssoc.class);
        }
        return null;
    }
}

