/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import b.h.la;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.codeInspection.ui.RegExFormatter;
import com.intellij.codeInspection.ui.RegExInputVerifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyBaseInspection;

public abstract class ConventionInspection
extends RubyBaseInspection {
    public String m_regex = this.getDefaultRegex();
    public String m_motionRegex = this.getMotionDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);
    protected Pattern m_motionRegexPattern = Pattern.compile(this.m_motionRegex);
    private static final int b = 25;
    private static final long i = la.a(7671860184609221579L, 2833058675024837055L, MethodHandles.lookup().lookupClass()).a(14218972296193L);

    @Override
    @NotNull
    public String getGroupDisplayName() {
        long l2 = i ^ 0x7122621A1045L;
        if ("Naming Conventions" == null) {
            ConventionInspection.c(0);
        }
        return "Naming Conventions";
    }

    @NonNls
    protected abstract String getDefaultRegex();

    @NonNls
    protected abstract String getMotionDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name, @Nullable PsiElement context) {
        Matcher matcher;
        Module module;
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        if (!ConventionInspection.containsAnyLetter(name)) {
            return true;
        }
        int n2 = name.length();
        if (n2 < this.m_minLength) {
            return false;
        }
        if (n2 > this.m_maxLength) {
            return false;
        }
        Module module2 = module = context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null;
        if (RubyMotionUtil.getInstance().hasRubyMotionSupport(module) && (matcher = this.m_motionRegexPattern.matcher(name)).matches()) {
            return true;
        }
        matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    protected static boolean containsAnyLetter(@NotNull String name) {
        if (name == null) {
            ConventionInspection.c(1);
        }
        for (int i10 = 0; i10 < name.length(); ++i10) {
            if (!Character.isLetter(name.charAt(i10))) continue;
            return true;
        }
        return false;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ConventionInspection.c(2);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
        this.m_motionRegexPattern = Pattern.compile(this.m_motionRegex);
    }

    public Collection<? extends JComponent> createExtraOptions() {
        return Collections.emptyList();
    }

    public final JComponent createOptionsPanel() {
        long l2 = i ^ 0x660E52884BA6L;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel("RubyMotion Pattern:");
        final JFormattedTextField jFormattedTextField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegExFormatter());
        jFormattedTextField.setValue(this.m_motionRegexPattern);
        jFormattedTextField.setColumns(25);
        jFormattedTextField.setInputVerifier((InputVerifier)new RegExInputVerifier());
        jFormattedTextField.setFocusLostBehavior(0);
        UIUtil.fixFormattedField((JFormattedTextField)jFormattedTextField);
        DocumentAdapter documentAdapter = new DocumentAdapter(){
            private static final long a = la.a(-3893408852529824349L, 920302381816017321L, MethodHandles.lookup().lookupClass()).a(21807158142703L);

            public void textChanged(@NotNull DocumentEvent evt) {
                if (evt == null) {
                    1.a(0);
                }
                try {
                    jFormattedTextField.commitEdit();
                    ConventionInspection.this.m_motionRegexPattern = (Pattern)jFormattedTextField.getValue();
                    ConventionInspection.this.m_motionRegex = ConventionInspection.this.m_motionRegexPattern.pattern();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7FB2CCC74718L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "org/jetbrains/plugins/ruby/ruby/inspections/naming/ConventionInspection$1", "textChanged"));
            }
        };
        Document document = jFormattedTextField.getDocument();
        document.addDocumentListener((DocumentListener)documentAdapter);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jFormattedTextField, gridBagConstraints);
        Collection<? extends JComponent> collection = this.createExtraOptions();
        JComponent[] jComponentArray = new JComponent[collection.size() + 1];
        jComponentArray[0] = jPanel;
        int n2 = 1;
        for (JComponent jComponent : collection) {
            jComponentArray[n2++] = jComponent;
        }
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", jComponentArray);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x4A4186BC95A8L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/ConventionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/ConventionInspection";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyLetter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

