/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.epp.psi.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.completion.PuppetLookupElements;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.psi.references.PuppetNamedReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EppTemplateReference
extends FileReference
implements PuppetNamedReference {
    public static final String TEMPLATES_DIR = "templates";

    public EppTemplateReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            EppTemplateReference.$$$reportNull$$$0(0);
        }
        super(fileReferenceSet, range, index, text);
    }

    @NotNull
    private Project getProject() {
        Project project = this.getElement().getProject();
        if (project == null) {
            EppTemplateReference.$$$reportNull$$$0(1);
        }
        return project;
    }

    private PsiManager getPsiManager() {
        return this.getElement().getManager();
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            EppTemplateReference.$$$reportNull$$$0(2);
        }
        if (this.getIndex() > 0) {
            ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
            if (resolveResultArray == null) {
                EppTemplateReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        Collection modules = PuppetProjectManager.getInstance((Project)this.getProject()).findModules(this.getText());
        if (modules.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                EppTemplateReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ArrayList<PsiDirectory> result = new ArrayList<PsiDirectory>();
        PsiManager psiManager = this.getPsiManager();
        for (PuppetModule module : modules) {
            PsiDirectory directory = psiManager.findDirectory(module.getRoot());
            if (directory == null) continue;
            result.add(directory);
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(result);
        if (resolveResultArray == null) {
            EppTemplateReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        if (this.getIndex() != 1) {
            Collection collection = super.getContexts();
            if (collection == null) {
                EppTemplateReference.$$$reportNull$$$0(6);
            }
            return collection;
        }
        FileReferenceSet fileReferenceSet = this.getFileReferenceSet();
        FileReference contextRef = fileReferenceSet.getReference(0);
        PsiElement sourceElement = fileReferenceSet.getElement();
        PsiManager psiManager = sourceElement.getManager();
        assert (contextRef != null);
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        for (PuppetModule puppetModule : PuppetProjectManager.getInstance((Project)this.getElement().getProject()).findModules(contextRef.getText())) {
            PsiDirectory psiDirectory;
            VirtualFile moduleRoot = puppetModule.getRoot();
            VirtualFile templatesDir = moduleRoot.findChild(TEMPLATES_DIR);
            if (templatesDir == null || !templatesDir.isValid() || !templatesDir.isDirectory() || (psiDirectory = psiManager.findDirectory(templatesDir)) == null) continue;
            result.add((PsiFileSystemItem)psiDirectory);
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            EppTemplateReference.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public Object[] getVariants() {
        if (this.getIndex() > 0) {
            Object[] objectArray = super.getVariants();
            if (objectArray == null) {
                EppTemplateReference.$$$reportNull$$$0(8);
            }
            return objectArray;
        }
        List<LookupElement> lookups = this.getModulesLookups();
        Object[] objectArray = lookups.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            EppTemplateReference.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    private List<LookupElement> getModulesLookups() {
        VirtualFile virtualFile = this.getElement().getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        PuppetEntity currentEntity = PuppetProjectManager.getInstance((Project)this.getProject()).findModuleOrEnvironmentForFile(virtualFile);
        if (currentEntity == null) {
            return Collections.emptyList();
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        if (currentEntity instanceof PuppetModule) {
            result.add(PuppetLookupElements.forModule((PuppetModule)((PuppetModule)currentEntity)));
        }
        for (PuppetModule puppetModule : currentEntity.getDependencies()) {
            result.add(PuppetLookupElements.forModule((PuppetModule)puppetModule));
        }
        return result;
    }

    @NotNull
    public String getPresentableName() {
        String string = PuppetBundle.message((String)"epp.file.reference.name", (Object[])new Object[0]);
        if (string == null) {
            EppTemplateReference.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/epp/psi/references/EppTemplateReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/epp/psi/references/EppTemplateReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

