/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalView {
    public static final Key<JBTerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private ToolWindow myToolWindow;
    private final Project myProject;
    private final LocalTerminalDirectRunner myTerminalRunner;
    private TerminalDockContainer myDockContainer;

    @NotNull
    public LocalTerminalDirectRunner getTerminalRunner() {
        LocalTerminalDirectRunner localTerminalDirectRunner = this.myTerminalRunner;
        if (localTerminalDirectRunner == null) {
            TerminalView.$$$reportNull$$$0(0);
        }
        return localTerminalDirectRunner;
    }

    public TerminalView(@NotNull Project project) {
        if (project == null) {
            TerminalView.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myTerminalRunner = LocalTerminalDirectRunner.createTerminalRunner(this.myProject);
    }

    public static TerminalView getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalView.$$$reportNull$$$0(2);
        }
        return (TerminalView)project.getComponent(TerminalView.class);
    }

    void initToolWindow(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(3);
        }
        if (this.myToolWindow != null) {
            return;
        }
        this.myToolWindow = toolWindow;
        ((ToolWindowImpl)this.myToolWindow).setTabActions(new AnAction[]{new DumbAwareAction("New Session", "Create new session", AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TerminalView.this.newTab(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalView$1", "actionPerformed"));
            }
        }});
        ((ToolWindowImpl)this.myToolWindow).setTabDoubleClickActions(new AnAction[]{new RenameTerminalSessionAction()});
        this.myToolWindow.setToHideOnEmptyContent(true);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (toolWindow.isVisible() && TerminalView.this.myToolWindow.getContentManager().getContentCount() == 0) {
                    TerminalView.this.createNewSession(TerminalView.this.myTerminalRunner, null);
                }
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer(this.myToolWindow);
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDockContainer);
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer);
        }
    }

    void restoreTabs(@Nullable TerminalArrangementState arrangementState) {
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                this.createNewSession(this.myTerminalRunner, tabState);
            }
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
        if (this.myToolWindow.getContentManager().getContentCount() == 0) {
            this.createNewSession(this.myTerminalRunner, null);
        }
    }

    public void createNewSession(@NotNull AbstractTerminalRunner terminalRunner) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(4);
        }
        this.createNewSession(terminalRunner, null);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner terminalRunner, @Nullable TerminalTabState tabState) {
        ToolWindow window;
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(5);
        }
        if ((window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal")) != null && window.isAvailable()) {
            ((ToolWindowImpl)window).ensureContentInitialized();
            this.createNewTab(null, terminalRunner, this.myToolWindow, tabState);
            window.activate(null);
        }
    }

    private Content newTab(@Nullable JBTerminalWidget terminalWidget) {
        return this.createNewTab(terminalWidget, this.myTerminalRunner, this.myToolWindow, null);
    }

    @NotNull
    private Content createNewTab(@Nullable JBTerminalWidget terminalWidget, @NotNull AbstractTerminalRunner terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(6);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(7);
        }
        Content content = this.createTerminalContent(terminalRunner, toolWindow, terminalWidget, tabState);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        Content content2 = content;
        if (content2 == null) {
            TerminalView.$$$reportNull$$$0(8);
        }
        return content2;
    }

    private static String generateUniqueName(String suggestedName, List<String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    private Content createTerminalContent(@NotNull AbstractTerminalRunner terminalRunner, final @NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget, final @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(9);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(10);
        }
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        String tabName = (String)ObjectUtils.notNull((Object)(tabState != null ? tabState.myTabName : null), (Object)TerminalOptionsProvider.getInstance().getTabName());
        final Content[] contents = this.myToolWindow.getContentManager().getContents();
        final Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)panel), tabName, false);
        if (terminalWidget == null) {
            VirtualFile currentWorkingDir = TerminalView.getCurrentWorkingDir(tabState);
            terminalWidget = terminalRunner.createTerminalWidget((Disposable)content, currentWorkingDir);
            TerminalArrangementManager.getInstance(this.myProject).register(terminalWidget, tabState);
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            terminalWidget.setVirtualFile(null);
            terminalWidget.moveDisposable((Disposable)content);
        }
        final JBTerminalWidget finalTerminalWidget = terminalWidget;
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalView.this.newTab(null);
            }

            public void onTerminalStarted() {
                if (tabState == null || StringUtil.isEmpty((String)tabState.myTabName)) {
                    String name = finalTerminalWidget.getSettingsProvider().tabName(finalTerminalWidget.getTtyConnector(), finalTerminalWidget.getSessionName());
                    content.setDisplayName(TerminalView.generateUniqueName(name, Arrays.stream(contents).map(c -> c.getDisplayName()).collect(Collectors.toList())));
                }
            }

            public void onPreviousTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectNextContent();
                }
            }

            public void onSessionClosed() {
                Content content2 = toolWindow.getContentManager().getSelectedContent();
                if (content2 != null) {
                    TerminalView.this.removeTab(content2, true);
                }
            }
        });
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)terminalWidget);
        panel.setContent(terminalWidget.getComponent());
        panel.addFocusListener(this.createFocusListener());
        panel.uiSettingsChanged(null);
        content.setPreferredFocusableComponent(terminalWidget.getPreferredFocusableComponent());
        terminalWidget.addListener(widget -> ApplicationManager.getApplication().invokeLater(() -> this.removeTab(content, true)));
        return content;
    }

    @Nullable
    private static VirtualFile getCurrentWorkingDir(@Nullable TerminalTabState tabState) {
        String dir = tabState != null ? tabState.myWorkingDirectory : null;
        VirtualFile result = null;
        if (dir != null) {
            result = LocalFileSystem.getInstance().findFileByPath(dir);
        }
        return result;
    }

    private void removeTab(Content content, boolean keepFocus) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.removeContent(content, true, keepFocus, keepFocus);
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.this.getComponentToFocus();
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private JComponent getComponentToFocus() {
        Content selectedContent = this.myToolWindow.getContentManager().getSelectedContent();
        if (selectedContent != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return this.myToolWindow.getComponent();
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
        if (window != null && window.isAvailable()) {
            ((ToolWindowImpl)window).ensureContentInitialized();
            TerminalTabState state = new TerminalTabState();
            if (fileToOpen != null) {
                state.myWorkingDirectory = fileToOpen.getPath();
            }
            this.createNewSession(this.myTerminalRunner, state);
            window.activate(null);
        }
    }

    @NotNull
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        if (content == null) {
            TerminalView.$$$reportNull$$$0(11);
        }
        JBTerminalWidget jBTerminalWidget = (JBTerminalWidget)Objects.requireNonNull(content.getUserData(TERMINAL_WIDGET_KEY));
        if (jBTerminalWidget == null) {
            TerminalView.$$$reportNull$$$0(12);
        }
        return jBTerminalWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalRunner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetByContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNewSession";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewTab";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class TerminalDockContainer
    implements DockContainer {
        private final ToolWindow myToolWindow;

        TerminalDockContainer(ToolWindow toolWindow) {
            this.myToolWindow = toolWindow;
        }

        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.myToolWindow.getComponent());
        }

        public RelativeRectangle getAcceptAreaFallback() {
            return this.getAcceptArea();
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                TerminalDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        public JComponent getContainerComponent() {
            return this.myToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(2);
            }
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                String name = terminalFile.getName();
                Content newContent = TerminalView.this.newTab(terminalFile.getTerminalWidget());
                newContent.setDisplayName(name);
            }
        }

        private boolean isTerminalSessionContent(DockableContent content) {
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public void closeAll() {
        }

        public void addListener(DockContainer.Listener listener, Disposable parent) {
        }

        public boolean isEmpty() {
            return false;
        }

        @Nullable
        public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Nullable
        public Image processDropOver(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(4);
            }
            return null;
        }

        public void resetDropOver(@NotNull DockableContent content) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(5);
            }
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        public void showNotify() {
        }

        public void hideNotify() {
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startDropOver";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processDropOver";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "resetDropOver";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

