/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRuntimesManagerImpl
implements DockerRuntimesManagerService.DockerRuntimesManager {
    private final DockerCloudConfiguration myDockerConfig;
    private DockerRuntimesCache myRuntimesCache;

    public DockerRuntimesManagerImpl(@NotNull DockerCloudConfiguration dockerConfig) {
        if (dockerConfig == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(0);
        }
        this.myDockerConfig = dockerConfig;
    }

    public DockerRuntimesCache serverConnected(@NotNull DockerServerRuntimeInstance serverRuntime) {
        if (serverRuntime == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myRuntimesCache == null) {
            DockerRuntimeContext context = DockerRuntimeContext.createFor(serverRuntime);
            this.myRuntimesCache = new DockerRuntimesCache(this, context);
            DockerRuntimesManagerImpl.syncPublisher().connectionChanged(this, true);
        }
        return this.myRuntimesCache;
    }

    public void serverDisconnected(@NotNull DockerServerRuntimeInstance serverRuntime) {
        if (serverRuntime == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(2);
        }
        this.myRuntimesCache = null;
        DockerRuntimesManagerImpl.syncPublisher().connectionChanged(this, false);
    }

    @Override
    public boolean isConnected() {
        return this.myRuntimesCache != null;
    }

    @Override
    @Nullable
    public DockerRuntimesManagerService.ComposeServiceStatus findComposeServiceStatus(@NotNull String project, @NotNull String service) {
        if (project == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(3);
        }
        if (service == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(4);
        }
        return Optional.ofNullable(this.myRuntimesCache).map(cache -> {
            if (project == null) {
                DockerRuntimesManagerImpl.$$$reportNull$$$0(7);
            }
            return cache.findComposeApplicationRuntime(project);
        }).map(appRt -> {
            if (service == null) {
                DockerRuntimesManagerImpl.$$$reportNull$$$0(6);
            }
            return appRt.findService(service);
        }).map(rt -> rt.getContainerStatus()).orElse(null);
    }

    @NotNull
    private static DockerRuntimesManagerService.DockerRuntimesListener syncPublisher() {
        DockerRuntimesManagerService.DockerRuntimesListener dockerRuntimesListener = (DockerRuntimesManagerService.DockerRuntimesListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DockerRuntimesManagerService.DOCKER_RUNTIMES_MANAGER_TOPIC);
        if (dockerRuntimesListener == null) {
            DockerRuntimesManagerImpl.$$$reportNull$$$0(5);
        }
        return dockerRuntimesListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverRuntime";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerRuntimesManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerRuntimesManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serverConnected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serverDisconnected";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findComposeServiceStatus";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findComposeServiceStatus$1";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findComposeServiceStatus$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

