/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import java.io.IOException;
import java.io.InputStream;
import org.nustaq.logging.FSTLogger;

public final class FSTInputStream
extends InputStream {
    public static boolean REPORT_READ_FAILS = false;
    private static final FSTLogger LOGGER = FSTLogger.getLogger(FSTInputStream.class);
    public int chunk_size = 8000;
    public static ThreadLocal<byte[]> cachedBuffer = new ThreadLocal();
    public byte[] buf;
    public int pos;
    public int count;
    InputStream in;
    boolean fullyRead = false;
    public boolean byteBacked = false;

    public FSTInputStream(InputStream in) {
        this.initFromStream(in);
    }

    public void resetForReuse(byte[] b, int length) {
        this.reset();
        this.count = length;
        this.buf = b;
        this.pos = 0;
        this.byteBacked = true;
        this.fullyRead = true;
    }

    public void initFromStream(InputStream in) {
        this.fullyRead = false;
        this.byteBacked = false;
        this.pos = 0;
        this.in = in;
        if (this.buf == null) {
            this.buf = cachedBuffer.get();
            if (this.buf == null) {
                this.buf = new byte[this.chunk_size];
                cachedBuffer.set(this.buf);
            }
        }
        this.readNextChunk(in);
    }

    public boolean isFullyRead() {
        return this.fullyRead && this.pos >= this.count;
    }

    public void readNextChunk(InputStream in) {
        try {
            int read;
            if (this.buf.length < this.count + this.chunk_size) {
                this.ensureCapacity(Math.max(Math.min(0x7FFFFFFE, this.buf.length * 2), this.count + this.chunk_size));
            }
            if ((read = in.read(this.buf, this.count, this.chunk_size)) > 0) {
                this.count += read;
            } else {
                this.fullyRead = true;
            }
        }
        catch (IOException e) {
            if (REPORT_READ_FAILS) {
                LOGGER.log(FSTLogger.Level.ERROR, "Failed to read next chunk from InputStream", e);
                throw new RuntimeException("Failed to read next chunk from InputStream", e);
            }
            this.fullyRead = true;
        }
    }

    public void ensureCapacity(int siz) {
        if (this.buf.length < siz && !this.fullyRead) {
            byte[] newBuf = new byte[siz];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
            if (siz < 0xA00000) {
                cachedBuffer.set(this.buf);
            }
        }
    }

    public FSTInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    public FSTInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
    }

    @Override
    public int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        this.readNextChunk(this.in);
        if (this.fullyRead) {
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.isFullyRead()) {
            return -1;
        }
        while (!this.fullyRead && this.pos + len >= this.count) {
            this.readNextChunk(this.in);
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
    }

    @Override
    public void reset() {
        this.count = 0;
        this.pos = 0;
        this.fullyRead = false;
        this.byteBacked = false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public void ensureReadAhead(int bytes) {
        if (this.byteBacked) {
            return;
        }
        int targetCount = this.pos + bytes;
        while (!this.fullyRead && this.count < targetCount) {
            this.readNextChunk(this.in);
        }
    }
}

