/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.text.StringUtil;
import icons.UmlIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlAddNoteAction
extends DiagramActionWithPreparation<String> {
    public UmlAddNoteAction() {
        super("Note", "", UmlIcons.AddNote);
    }

    @Nullable
    public String prepare(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(0);
        }
        return Messages.showMultilineInputDialog((Project)e.getProject(), (String)"Note text", (String)"Add a Note", (String)"", (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
    }

    public void execute(DiagramBuilder builder, String description, AnActionEvent e) {
        if (StringUtil.isEmpty((String)description)) {
            return;
        }
        DiagramDataModel model = UmlAddNoteAction.getDataModel((AnActionEvent)e);
        DiagramNode node = (DiagramNode)UmlAddNoteAction.getSelectedNodes((AnActionEvent)e).get(0);
        DiagramNoteNode note = model.addNote(node, description);
        assert (builder != null);
        builder.updateGraph();
        if (note != null) {
            Node noteNode = builder.getNode((DiagramNode)note);
            NodeRealizer realizer = builder.getGraph().getRealizer(noteNode);
            NodeRealizer target = builder.getGraph().getRealizer(builder.getNode(note.getIdentifyingElement()));
            realizer.setCenterX(target.getCenterX());
            realizer.setY(target.getY() - realizer.getHeight() - 20.0);
        }
        builder.updateGraph();
        builder.notifyOtherBuilders();
    }

    public void update(@NotNull AnActionEvent e) {
        List nodes;
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(1);
        }
        if ((nodes = UmlAddNoteAction.getSelectedNodes((AnActionEvent)e)).size() == 1) {
            DiagramNode node = (DiagramNode)nodes.get(0);
            DiagramDataModel model = UmlAddNoteAction.getDataModel((AnActionEvent)e);
            if (model != null && !(node instanceof DiagramNoteNode) && !model.getNotes().containsKey(node)) {
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    public String getActionName() {
        return "Add Note";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/core/actions/UmlAddNoteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

