/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.CPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PoolKey;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -3104731034410444060L;
    private int defaultMaxActive = 8;
    private int defaultMaxIdle = 8;
    private int defaultMaxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    Map<String, Boolean> perUserDefaultAutoCommit = null;
    Map<String, Integer> perUserDefaultTransactionIsolation = null;
    Map<String, Integer> perUserMaxActive = null;
    Map<String, Integer> perUserMaxIdle = null;
    Map<String, Integer> perUserMaxWait = null;
    Map<String, Boolean> perUserDefaultReadOnly = null;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    @Override
    public void close() {
        Iterator<PooledConnectionManager> poolIter = this.managers.values().iterator();
        while (poolIter.hasNext()) {
            try {
                ((CPDSConnectionFactory)poolIter.next()).getPool().close();
            }
            catch (Exception exception) {}
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getDefaultMaxActive() {
        return this.defaultMaxActive;
    }

    public void setDefaultMaxActive(int maxActive) {
        this.assertInitializationAllowed();
        this.defaultMaxActive = maxActive;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int defaultMaxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = defaultMaxIdle;
    }

    public int getDefaultMaxWait() {
        return this.defaultMaxWait;
    }

    public void setDefaultMaxWait(int defaultMaxWait) {
        this.assertInitializationAllowed();
        this.defaultMaxWait = defaultMaxWait;
    }

    public Boolean getPerUserDefaultAutoCommit(String key) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = this.perUserDefaultAutoCommit.get(key);
        }
        return value;
    }

    public void setPerUserDefaultAutoCommit(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap<String, Boolean>();
        }
        this.perUserDefaultAutoCommit.put(username, value);
    }

    public Integer getPerUserDefaultTransactionIsolation(String username) {
        Integer value = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            value = this.perUserDefaultTransactionIsolation.get(username);
        }
        return value;
    }

    public void setPerUserDefaultTransactionIsolation(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(username, value);
    }

    public Integer getPerUserMaxActive(String username) {
        Integer value = null;
        if (this.perUserMaxActive != null) {
            value = this.perUserMaxActive.get(username);
        }
        return value;
    }

    public void setPerUserMaxActive(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxActive == null) {
            this.perUserMaxActive = new HashMap<String, Integer>();
        }
        this.perUserMaxActive.put(username, value);
    }

    public Integer getPerUserMaxIdle(String username) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = this.perUserMaxIdle.get(username);
        }
        return value;
    }

    public void setPerUserMaxIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(username, value);
    }

    public Integer getPerUserMaxWait(String username) {
        Integer value = null;
        if (this.perUserMaxWait != null) {
            value = this.perUserMaxWait.get(username);
        }
        return value;
    }

    public void setPerUserMaxWait(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWait == null) {
            this.perUserMaxWait = new HashMap<String, Integer>();
        }
        this.perUserMaxWait.put(username, value);
    }

    public Boolean getPerUserDefaultReadOnly(String username) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = this.perUserDefaultReadOnly.get(username);
        }
        return value;
    }

    public void setPerUserDefaultReadOnly(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap<String, Boolean>();
        }
        this.perUserDefaultReadOnly.put(username, value);
    }

    public int getNumActive() {
        return this.getNumActive(null, null);
    }

    public int getNumActive(String username, String password) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null, null);
    }

    public int getNumIdle(String username, String password) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username));
        return pool == null ? 0 : pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> pool;
        PooledConnectionManager manager;
        PoolKey key = this.getPoolKey(username);
        PerUserPoolDataSource perUserPoolDataSource = this;
        synchronized (perUserPoolDataSource) {
            manager = this.managers.get(key);
            if (manager == null) {
                try {
                    this.registerPool(username, password);
                    manager = this.managers.get(key);
                }
                catch (NamingException e) {
                    throw new SQLException("RegisterPool failed", e);
                }
            }
            pool = ((CPDSConnectionFactory)manager).getPool();
        }
        PooledConnectionAndInfo info = null;
        try {
            info = pool.borrowObject();
        }
        catch (NoSuchElementException ex) {
            throw new SQLException("Could not retrieve connection info from pool", ex);
        }
        catch (Exception e) {
            try {
                this.testCPDS(username, password);
            }
            catch (Exception ex) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(ex);
            }
            manager.closePool(username);
            PerUserPoolDataSource ex = this;
            synchronized (ex) {
                this.managers.remove(key);
            }
            try {
                this.registerPool(username, password);
                pool = this.getPool(key);
            }
            catch (NamingException ne) {
                throw new SQLException("RegisterPool failed", ne);
            }
            try {
                info = pool.borrowObject();
            }
            catch (Exception ex2) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(ex2);
            }
        }
        return info;
    }

    @Override
    protected void setupDefaults(Connection con, String username) throws SQLException {
        Integer userMax;
        Boolean userMax2;
        Boolean userMax3;
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (username != null && (userMax3 = this.getPerUserDefaultAutoCommit(username)) != null) {
            defaultAutoCommit = userMax3;
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (username != null && (userMax2 = this.getPerUserDefaultReadOnly(username)) != null) {
            defaultReadOnly = userMax2;
        }
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (username != null && (userMax = this.getPerUserDefaultTransactionIsolation(username)) != null) {
            defaultTransactionIsolation = userMax;
        }
        if (con.getAutoCommit() != defaultAutoCommit) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        if (con.isReadOnly() != defaultReadOnly) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.managers.get(this.getPoolKey(upkey.getUsername()));
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }

    private PoolKey getPoolKey(String username) {
        return new PoolKey(this.getDataSourceName(), username);
    }

    private synchronized void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        Integer userMax = this.getPerUserMaxActive(username);
        int maxActive = userMax == null ? this.getDefaultMaxActive() : userMax.intValue();
        userMax = this.getPerUserMaxIdle(username);
        int maxIdle = userMax == null ? this.getDefaultMaxIdle() : userMax.intValue();
        userMax = this.getPerUserMaxWait(username);
        int maxWait = userMax == null ? this.getDefaultMaxWait() : userMax.intValue();
        GenericObjectPool<PooledConnectionAndInfo> pool = new GenericObjectPool<PooledConnectionAndInfo>(null);
        pool.setMaxActive(maxActive);
        pool.setMaxIdle(maxIdle);
        pool.setMaxWait(maxWait);
        pool.setWhenExhaustedAction(this.whenExhaustedAction(maxActive, maxWait));
        pool.setTestOnBorrow(this.getTestOnBorrow());
        pool.setTestOnReturn(this.getTestOnReturn());
        pool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        pool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        pool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        pool.setTestWhileIdle(this.getTestWhileIdle());
        CPDSConnectionFactory factory = new CPDSConnectionFactory(cpds, pool, this.getValidationQuery(), this.isRollbackAfterValidation(), username, password);
        PooledConnectionManager old = this.managers.put(this.getPoolKey(username), factory);
        if (old != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + username);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            PerUserPoolDataSource oldDS = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = oldDS.managers;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey key) {
        CPDSConnectionFactory mgr = (CPDSConnectionFactory)this.managers.get(key);
        return mgr == null ? null : mgr.getPool();
    }
}

