/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.internal.util.RegionScope;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactory;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactoryContext;
import software.amazon.awssdk.services.s3.model.S3Request;

@SdkInternalApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        boolean endpointOverridden = Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN));
        URI endpointOverride = endpointOverridden ? (URI)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT) : null;
        S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        boolean disableHostPrefixInjection = EndpointAddressInterceptor.isDisableHostPrefixInjection(executionAttributes);
        S3EndpointResolverContext resolverContext = S3EndpointResolverContext.builder().request(context.httpRequest()).originalRequest(context.request()).region((Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION)).endpointOverride(endpointOverride).serviceConfiguration(serviceConfiguration).disableHostPrefixInjection(disableHostPrefixInjection).build();
        String bucketName = context.request().getValueForField("Bucket", String.class).orElse(null);
        S3EndpointResolverFactoryContext resolverFactoryContext = S3EndpointResolverFactoryContext.builder().bucketName(bucketName).originalRequest((S3Request)context.request()).build();
        ConfiguredS3SdkHttpRequest configuredRequest = S3EndpointResolverFactory.getEndpointResolver(resolverFactoryContext).applyEndpointConfiguration(resolverContext);
        if (configuredRequest.signingRegionModification().isPresent()) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)configuredRequest.signingRegionModification().get());
        } else {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, (Object)RegionScope.GLOBAL);
        }
        configuredRequest.signingServiceModification().ifPresent(name -> executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, name));
        return configuredRequest.sdkHttpRequest();
    }

    private static boolean isDisableHostPrefixInjection(ExecutionAttributes executionAttributes) {
        return Boolean.TRUE.equals(executionAttributes.getAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION));
    }
}

