/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SortedIterable;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ImmutableSortedSet
extends ImmutableSortedSetFauxverideShim
implements SortedIterable,
NavigableSet {
    final transient Comparator comparator;
    @LazyInit
    transient ImmutableSortedSet descendingSet;

    static RegularImmutableSortedSet emptySet(Comparator comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet(ImmutableList.of(), comparator);
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator comparator, Object object, Object object2) {
        Comparator comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator iterator();

    public ImmutableSortedSet headSet(Object object) {
        return this.headSet(object, false);
    }

    public ImmutableSortedSet headSet(Object object, boolean bl) {
        return this.headSetImpl(Preconditions.checkNotNull(object), bl);
    }

    public ImmutableSortedSet subSet(Object object, Object object2) {
        return this.subSet(object, true, object2, false);
    }

    public ImmutableSortedSet subSet(Object object, boolean bl, Object object2, boolean bl2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Preconditions.checkArgument(this.comparator.compare(object, object2) <= 0);
        return this.subSetImpl(object, bl, object2, bl2);
    }

    public ImmutableSortedSet tailSet(Object object) {
        return this.tailSet(object, true);
    }

    public ImmutableSortedSet tailSet(Object object, boolean bl) {
        return this.tailSetImpl(Preconditions.checkNotNull(object), bl);
    }

    abstract ImmutableSortedSet headSetImpl(Object var1, boolean var2);

    abstract ImmutableSortedSet subSetImpl(Object var1, boolean var2, Object var3, boolean var4);

    abstract ImmutableSortedSet tailSetImpl(Object var1, boolean var2);

    public Object lower(Object object) {
        return Iterators.getNext(this.headSet(object, false).descendingIterator(), null);
    }

    public Object floor(Object object) {
        return Iterators.getNext(this.headSet(object, true).descendingIterator(), null);
    }

    public Object ceiling(Object object) {
        return Iterables.getFirst(this.tailSet(object, true), null);
    }

    public Object higher(Object object) {
        return Iterables.getFirst(this.tailSet(object, false), null);
    }

    @Override
    public Object first() {
        return this.iterator().next();
    }

    @Override
    public Object last() {
        return this.descendingIterator().next();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final Object pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final Object pollLast() {
        throw new UnsupportedOperationException();
    }

    public ImmutableSortedSet descendingSet() {
        ImmutableSortedSet immutableSortedSet = this.descendingSet;
        if (immutableSortedSet == null) {
            immutableSortedSet = this.descendingSet = this.createDescendingSet();
            immutableSortedSet.descendingSet = this;
        }
        return immutableSortedSet;
    }

    abstract ImmutableSortedSet createDescendingSet();

    @Override
    public Spliterator spliterator() {
        return new ImmutableSortedSet$1(this, this.size(), 1365);
    }

    public abstract UnmodifiableIterator descendingIterator();

    abstract int indexOf(@NullableDecl Object var1);
}

