/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.cloud.rule.ServerSnitchContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.rule.Snitch;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaAssigner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    List<Rule> rules;
    Map<String, Integer> shardVsReplicaCount;
    Map<String, Map<String, Object>> nodeVsTags;
    Map<String, HashMap<String, Integer>> shardVsNodes;
    List<String> participatingLiveNodes;
    Set<String> tagNames = new HashSet<String>();
    private Map<String, AtomicInteger> nodeVsCores = new HashMap<String, AtomicInteger>();
    public Map<String, SnitchContext> failedNodes = new HashMap<String, SnitchContext>();
    private Map<String, Object> snitchSession = new HashMap<String, Object>();

    public ReplicaAssigner(List<Rule> rules, Map<String, Integer> shardVsReplicaCount, List snitches, Map<String, Map<String, Integer>> shardVsNodes, List<String> participatingLiveNodes, SolrCloudManager cloudManager, ClusterState clusterState) {
        this.rules = rules;
        for (Rule rule : rules) {
            this.tagNames.add(rule.tag.name);
        }
        this.shardVsReplicaCount = shardVsReplicaCount;
        this.participatingLiveNodes = new ArrayList<String>(participatingLiveNodes);
        this.nodeVsTags = this.getTagsForNodes(cloudManager, snitches);
        this.shardVsNodes = Utils.getDeepCopy(shardVsNodes, (int)2);
        if (clusterState != null) {
            Map collections = clusterState.getCollectionsMap();
            for (Map.Entry entry : collections.entrySet()) {
                DocCollection coll = (DocCollection)entry.getValue();
                for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        AtomicInteger count = this.nodeVsCores.get(replica.getNodeName());
                        if (count == null) {
                            count = new AtomicInteger();
                            this.nodeVsCores.put(replica.getNodeName(), count);
                        }
                        count.incrementAndGet();
                    }
                }
            }
        }
    }

    public Map<String, Map<String, Object>> getNodeVsTags() {
        return this.nodeVsTags;
    }

    public Map<ReplicaPosition, String> getNodeMappings() {
        Map<ReplicaPosition, String> result = this.getNodeMappings0();
        if (result == null) {
            String msg = "Could not identify nodes matching the rules " + this.rules;
            if (!this.failedNodes.isEmpty()) {
                HashMap<String, String> failedNodes = new HashMap<String, String>();
                for (Map.Entry<String, SnitchContext> e : this.failedNodes.entrySet()) {
                    failedNodes.put(e.getKey(), e.getValue().getErrMsg());
                }
                msg = msg + " Some nodes where excluded from assigning replicas because tags could not be obtained from them " + failedNodes;
            }
            msg = msg + "\n tag values" + Utils.toJSONString(this.getNodeVsTags());
            if (!this.shardVsNodes.isEmpty()) {
                msg = msg + "\nInitial state for the coll : " + Utils.toJSONString(this.shardVsNodes);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return result;
    }

    Map<ReplicaPosition, String> getNodeMappings0() {
        ArrayList<String> shardNames = new ArrayList<String>(this.shardVsReplicaCount.keySet());
        int[] shardOrder = new int[shardNames.size()];
        for (int i = 0; i < shardNames.size(); ++i) {
            shardOrder[i] = i;
        }
        boolean hasFuzzyRules = false;
        int nonWildCardShardRules = 0;
        for (Rule r : this.rules) {
            if (r.isFuzzy()) {
                hasFuzzyRules = true;
            }
            if (r.shard.isWildCard()) continue;
            ++nonWildCardShardRules;
            if (shardNames.size() <= 10) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Max 10 shards allowed if there is a non wild card shard specified in rule");
        }
        Map<ReplicaPosition, String> result = this.tryAllPermutations(shardNames, shardOrder, nonWildCardShardRules, false);
        if (result == null && hasFuzzyRules) {
            result = this.tryAllPermutations(shardNames, shardOrder, nonWildCardShardRules, true);
        }
        return result;
    }

    private Map<ReplicaPosition, String> tryAllPermutations(List<String> shardNames, int[] shardOrder, int nonWildCardShardRules, boolean fuzzyPhase) {
        Iterator<int[]> shardPermutations;
        Iterator<int[]> iterator = shardPermutations = nonWildCardShardRules > 0 ? ReplicaAssigner.permutations(shardNames.size()) : Collections.singletonList(shardOrder).iterator();
        while (shardPermutations.hasNext()) {
            int[] p = shardPermutations.next();
            ArrayList<ReplicaPosition> replicaPositions = new ArrayList<ReplicaPosition>();
            for (int pos : p) {
                for (int j = 0; j < this.shardVsReplicaCount.get(shardNames.get(pos)); ++j) {
                    replicaPositions.add(new ReplicaPosition(shardNames.get(pos), j, Replica.Type.NRT));
                }
            }
            Collections.sort(replicaPositions);
            Iterator<int[]> it = ReplicaAssigner.permutations(this.rules.size());
            while (it.hasNext()) {
                int[] permutation = it.next();
                Map<ReplicaPosition, String> result = this.tryAPermutationOfRules(permutation, replicaPositions, fuzzyPhase);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Map<ReplicaPosition, String> tryAPermutationOfRules(int[] rulePermutation, List<ReplicaPosition> replicaPositions, boolean fuzzyPhase) {
        Map nodeVsTagsCopy = Utils.getDeepCopy(this.nodeVsTags, (int)2);
        LinkedHashMap<ReplicaPosition, String> result = new LinkedHashMap<ReplicaPosition, String>();
        int startPosition = 0;
        Map copyOfCurrentState = Utils.getDeepCopy(this.shardVsNodes, (int)2);
        ArrayList<String> sortedLiveNodes = new ArrayList<String>(this.participatingLiveNodes);
        Collections.sort(sortedLiveNodes, (n1, n2) -> {
            int result1 = 0;
            for (int i = 0; i < rulePermutation.length; ++i) {
                int b;
                Rule rule = this.rules.get(rulePermutation[i]);
                int val = rule.compare((String)n1, (String)n2, nodeVsTagsCopy, copyOfCurrentState);
                if (val != 0) {
                    result1 = val;
                    break;
                }
                if (result1 != 0) continue;
                AtomicInteger n1Count = this.nodeVsCores.get(n1);
                AtomicInteger n2Count = this.nodeVsCores.get(n2);
                int a = n1Count == null ? 0 : n1Count.get();
                int n = b = n2Count == null ? 0 : n2Count.get();
                result1 = a > b ? 1 : (a == b ? 0 : -1);
            }
            return result1;
        });
        block0: for (ReplicaPosition replicaPosition : replicaPositions) {
            block1: for (int j = 0; j < sortedLiveNodes.size(); ++j) {
                Integer n;
                String liveNode = (String)sortedLiveNodes.get(startPosition % sortedLiveNodes.size());
                ++startPosition;
                for (int i = 0; i < rulePermutation.length; ++i) {
                    Rule rule = this.rules.get(rulePermutation[i]);
                    Rule.MatchStatus status = rule.tryAssignNodeToShard(liveNode, copyOfCurrentState, nodeVsTagsCopy, replicaPosition.shard, fuzzyPhase ? Rule.Phase.FUZZY_ASSIGN : Rule.Phase.ASSIGN);
                    if (status == Rule.MatchStatus.CANNOT_ASSIGN_FAIL) continue block1;
                }
                result.put(replicaPosition, liveNode);
                HashMap<String, Integer> nodeNames = (HashMap<String, Integer>)copyOfCurrentState.get(replicaPosition.shard);
                if (nodeNames == null) {
                    nodeNames = new HashMap<String, Integer>();
                    copyOfCurrentState.put(replicaPosition.shard, nodeNames);
                }
                n = (n = (Integer)nodeNames.get(liveNode)) == null ? 1 : n + 1;
                nodeNames.put(liveNode, n);
                Map tagsMap = (Map)nodeVsTagsCopy.get(liveNode);
                Number coreCount = tagsMap == null ? (Number)null : (Number)((Number)tagsMap.get("cores"));
                if (coreCount == null) continue block0;
                ((Map)nodeVsTagsCopy.get(liveNode)).put("cores", coreCount.intValue() + 1);
                continue block0;
            }
            return null;
        }
        if (replicaPositions.size() > result.size()) {
            return null;
        }
        for (Map.Entry entry : result.entrySet()) {
            for (int i = 0; i < rulePermutation.length; ++i) {
                Rule rule = this.rules.get(rulePermutation[i]);
                Rule.MatchStatus matchStatus = rule.tryAssignNodeToShard((String)entry.getValue(), copyOfCurrentState, nodeVsTagsCopy, ((ReplicaPosition)entry.getKey()).shard, fuzzyPhase ? Rule.Phase.FUZZY_VERIFY : Rule.Phase.VERIFY);
                if (matchStatus == Rule.MatchStatus.NODE_CAN_BE_ASSIGNED || matchStatus == Rule.MatchStatus.NOT_APPLICABLE) continue;
                return null;
            }
        }
        return result;
    }

    public static Iterator<int[]> permutations(final int level) {
        return new Iterator<int[]>(){
            int i = 0;
            int[] next;

            @Override
            public boolean hasNext() {
                AtomicReference nthval = new AtomicReference();
                ReplicaAssigner.permute(0, new int[level], new BitSet(level), nthval, this.i, new AtomicInteger());
                ++this.i;
                this.next = (int[])nthval.get();
                return this.next != null;
            }

            @Override
            public int[] next() {
                return this.next;
            }
        };
    }

    private static void permute(int level, int[] permuted, BitSet used, AtomicReference<int[]> nthval, int requestedIdx, AtomicInteger seenSoFar) {
        if (level == permuted.length) {
            if (seenSoFar.get() == requestedIdx) {
                nthval.set(permuted);
            } else {
                seenSoFar.incrementAndGet();
            }
        } else {
            for (int i = 0; i < permuted.length; ++i) {
                if (used.get(i)) continue;
                used.set(i);
                permuted[level] = i;
                ReplicaAssigner.permute(level + 1, permuted, used, nthval, requestedIdx, seenSoFar);
                if (nthval.get() != null) break;
                used.set(i, false);
            }
        }
    }

    private Map<String, Map<String, Object>> getTagsForNodes(SolrCloudManager cloudManager, List snitchConf) {
        Map<Class, SnitchInfoImpl> snitches = ReplicaAssigner.getSnitchInfos(cloudManager, snitchConf);
        for (Class c : Snitch.WELL_KNOWN_SNITCHES) {
            if (snitches.containsKey(c)) continue;
            try {
                snitches.put(c, new SnitchInfoImpl(Collections.EMPTY_MAP, (Snitch)c.newInstance(), cloudManager));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error instantiating Snitch " + c.getName());
            }
        }
        for (String tagName : this.tagNames) {
            boolean foundProvider = false;
            for (SnitchInfoImpl snitchInfoImpl : snitches.values()) {
                if (!snitchInfoImpl.snitch.isKnownTag(tagName)) continue;
                foundProvider = true;
                snitchInfoImpl.myTags.add(tagName);
                break;
            }
            if (foundProvider) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown tag in rules " + tagName);
        }
        for (String node : this.participatingLiveNodes) {
            for (SnitchInfoImpl info : snitches.values()) {
                if (info.myTags.isEmpty()) continue;
                SnitchContext snitchContext = this.getSnitchCtx(node, info, cloudManager);
                info.nodeVsContext.put(node, snitchContext);
                try {
                    info.snitch.getTags(node, info.myTags, snitchContext);
                }
                catch (Exception e) {
                    snitchContext.exception = e;
                }
            }
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (SnitchInfoImpl info : snitches.values()) {
            for (Map.Entry entry : info.nodeVsContext.entrySet()) {
                SnitchContext context = (SnitchContext)entry.getValue();
                String node = (String)entry.getKey();
                if (context.exception != null) {
                    this.failedNodes.put(node, context);
                    this.participatingLiveNodes.remove(node);
                    log.warn("Not all tags were obtained from node {}", (Object)node, (Object)context.exception);
                    context.exception = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not all tags were obtained from node " + node);
                    continue;
                }
                HashMap tags = (HashMap)result.get(node);
                if (tags == null) {
                    tags = new HashMap();
                    result.put(node, tags);
                }
                tags.putAll(context.getTags());
            }
        }
        if (this.participatingLiveNodes.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not get all tags for any nodes");
        }
        return result;
    }

    protected SnitchContext getSnitchCtx(String node, SnitchInfoImpl info, SolrCloudManager cloudManager) {
        return new ServerSnitchContext(info, node, this.snitchSession, cloudManager);
    }

    public static void verifySnitchConf(SolrCloudManager cloudManager, List snitchConf) {
        ReplicaAssigner.getSnitchInfos(cloudManager, snitchConf);
    }

    static Map<Class, SnitchInfoImpl> getSnitchInfos(SolrCloudManager cloudManager, List snitchConf) {
        if (snitchConf == null) {
            snitchConf = Collections.emptyList();
        }
        LinkedHashMap<Class, SnitchInfoImpl> snitches = new LinkedHashMap<Class, SnitchInfoImpl>();
        for (Object o : snitchConf) {
            String klas = null;
            Map map = Collections.emptyMap();
            if (o instanceof Map) {
                map = (Map)o;
                klas = (String)map.get("class");
                if (klas == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "snitch must have  a class attribute");
                }
            } else {
                klas = o.toString();
            }
            try {
                if (klas.indexOf(46) == -1) {
                    klas = Snitch.class.getPackage().getName() + "." + klas;
                }
                Snitch inst = (Snitch)Snitch.class.getClassLoader().loadClass(klas).newInstance();
                snitches.put(inst.getClass(), new SnitchInfoImpl(map, inst, cloudManager));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return snitches;
    }

    static class SnitchInfoImpl
    extends SnitchContext.SnitchInfo {
        final Snitch snitch;
        final Set<String> myTags = new HashSet<String>();
        final Map<String, SnitchContext> nodeVsContext = new HashMap<String, SnitchContext>();
        private final SolrCloudManager cloudManager;

        SnitchInfoImpl(Map<String, Object> conf, Snitch snitch, SolrCloudManager cloudManager) {
            super(conf);
            this.snitch = snitch;
            this.cloudManager = cloudManager;
        }

        public Set<String> getTagNames() {
            return this.myTags;
        }
    }
}

