/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.openide.util.Parameters;

public class SearchScopeOptions {
    static final SearchScopeOptions DEFAULT = new DefaultSearchOptions();
    private String pattern = "";
    private boolean regexp = false;
    private boolean searchInArchives = false;
    private boolean searchInGenerated = false;
    private List<SearchFilterDefinition> filters = new LinkedList<SearchFilterDefinition>();

    private SearchScopeOptions() {
    }

    public void addFilter(@NonNull SearchFilterDefinition searchFilterDefinition) {
        Parameters.notNull((CharSequence)"filter", (Object)searchFilterDefinition);
        if (!this.filters.contains(searchFilterDefinition)) {
            this.filters.add(searchFilterDefinition);
        }
    }

    @NonNull
    public List<SearchFilterDefinition> getFilters() {
        return this.filters;
    }

    public boolean isSearchInArchives() {
        return this.searchInArchives;
    }

    public void setSearchInArchives(boolean bl) {
        this.searchInArchives = bl;
    }

    public boolean isSearchInGenerated() {
        return this.searchInGenerated;
    }

    public void setSearchInGenerated(boolean bl) {
        this.searchInGenerated = bl;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(@NullAllowed String string) {
        this.pattern = string == null ? "" : string;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public void setRegexp(boolean bl) {
        this.regexp = bl;
    }

    @NonNull
    public static SearchScopeOptions create() {
        return new SearchScopeOptions();
    }

    @NonNull
    public static SearchScopeOptions create(@NullAllowed String string, boolean bl) {
        SearchScopeOptions searchScopeOptions = SearchScopeOptions.create();
        searchScopeOptions.setPattern(string);
        searchScopeOptions.setRegexp(bl);
        return searchScopeOptions;
    }

    @NonNull
    public static SearchScopeOptions create(@NullAllowed String string, boolean bl, boolean bl2, boolean bl3, @NullAllowed List<SearchFilterDefinition> list) {
        SearchScopeOptions searchScopeOptions = SearchScopeOptions.create(string, bl);
        searchScopeOptions.setSearchInArchives(bl2);
        searchScopeOptions.setSearchInGenerated(bl3);
        if (list != null) {
            for (SearchFilterDefinition searchFilterDefinition : list) {
                searchScopeOptions.addFilter(searchFilterDefinition);
            }
        }
        return searchScopeOptions;
    }

    static class DefaultSearchOptions
    extends SearchScopeOptions {
        private static final List<SearchFilterDefinition> LIST = Collections.emptyList();

        private DefaultSearchOptions() {
        }

        @Override
        public void addFilter(SearchFilterDefinition searchFilterDefinition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SearchFilterDefinition> getFilters() {
            return LIST;
        }
    }
}

