/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class SubstanceUtils {
    public static final String FOREGROUND_COLOR = "ForegroundColor";
    public static final String ULTRA_LIGHT_COLOR = "UltraLightColor";
    public static final String EXTRA_LIGHT_COLOR = "ExtraLightColor";
    public static final String LIGHT_COLOR = "LightColor";
    public static final String MID_COLOR = "MidColor";
    public static final String DARK_COLOR = "DarkColor";
    public static final String ULTRA_DARK_COLOR = "UltraDarkColor";
    public static final String LINE_COLOR = "LineColor";
    public static final String SELECTION_BG_COLOR = "SelectionBackgroundColor";
    public static final String SELECTION_FG_COLOR = "SelectionForegroundColor";
    public static final String BACKGROUND_FILL_COLOR = "BackgroundFillColor";
    public static final String TEXT_BG_FILL_COLOR = "TextBackgroundFillColor";
    public static final String FOCUS_RING_COLOR = "FocusRingColor";
    private static final String PKG = "org.pushingpixels.substance.api.";
    private static final String LAFWIDGET_PKG = "org.pushingpixels.lafwidget.";

    public static long getAnimationSpeed() throws Exception {
        long speed = -1L;
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null) {
            String managerClassName = "org.pushingpixels.lafwidget.animation.AnimationConfigurationManager";
            Class<?> managerClazz = Class.forName(managerClassName, true, cl);
            Method m = managerClazz.getMethod("getInstance", null);
            Object manager = m.invoke(null, null);
            m = managerClazz.getMethod("getTimelineDuration", null);
            Long millis = (Long)m.invoke(manager, null);
            speed = millis;
        }
        return speed;
    }

    public static Color getSubstanceColor(String name) throws Exception {
        Class<?> clazz;
        Color color = null;
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        LookAndFeel laf = UIManager.getLookAndFeel();
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null && (clazz = Class.forName("org.pushingpixels.substance.api.SubstanceLookAndFeel", true, cl)).isInstance(laf)) {
            Class<?> skinClazz = Class.forName("org.pushingpixels.substance.api.SubstanceSkin", true, cl);
            Method m = clazz.getDeclaredMethod("getCurrentSkin", null);
            Object skin = m.invoke(null, null);
            Class<?> decAreaTypeClazz = Class.forName("org.pushingpixels.substance.api.DecorationAreaType", true, cl);
            Field decAreaTypeField = decAreaTypeClazz.getDeclaredField("GENERAL");
            Object decAreaType = decAreaTypeField.get(null);
            m = skinClazz.getDeclaredMethod("getActiveColorScheme", decAreaTypeClazz);
            Object colorScheme = m.invoke(skin, decAreaType);
            Class<?> colorSchemeClazz = Class.forName("org.pushingpixels.substance.api.SubstanceColorScheme", true, cl);
            m = colorSchemeClazz.getMethod("get" + name, null);
            color = (Color)m.invoke(colorScheme, null);
        }
        return color;
    }

    public static boolean isSubstanceInstalled() {
        return SubstanceUtils.isASubstanceLookAndFeel(UIManager.getLookAndFeel());
    }

    public static boolean isASubstanceLookAndFeel(LookAndFeel laf) {
        return SubstanceUtils.isASubstanceLookAndFeel(laf.getClass().getName());
    }

    public static boolean isASubstanceLookAndFeel(String lafName) {
        return lafName.indexOf(".Substance") > -1;
    }

    public static void setAnimationSpeed(long millis) throws Exception {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl != null) {
            String managerClassName = "org.pushingpixels.lafwidget.animation.AnimationConfigurationManager";
            Class<?> managerClazz = Class.forName(managerClassName, true, cl);
            Method m = managerClazz.getMethod("getInstance", null);
            Object manager = m.invoke(null, null);
            m = managerClazz.getMethod("setTimelineDuration", Long.TYPE);
            m.invoke(manager, new Long(millis));
        }
    }
}

