/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset;

import java.util.Arrays;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.DataSetTextArea;

public class DataSetTextAreaController {
    private static final int COLUMN_PADDING = 2;
    private DataSetTextArea _outText = new DataSetTextArea();
    private int _rowCount = 0;
    private ColumnDisplayDefinition[] _colDefs;

    public void init(ColumnDisplayDefinition[] colDefs, boolean showHeadings) {
        this._colDefs = colDefs;
        if (showHeadings) {
            int i;
            this._colDefs = colDefs;
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                String headerValue = colDefs[i].getColumnHeading();
                buf.append(this.format(headerValue, colDefs[i].getDisplayWidth(), ' '));
            }
            this.addLine(buf.toString());
            buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                buf.append(this.format("", colDefs[i].getDisplayWidth(), '-'));
            }
            this.addLine(buf.toString());
        }
    }

    public void clear() {
        this._outText.setText("");
        this._rowCount = 0;
    }

    public void addRow(Object[] row) {
        ++this._rowCount;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            String cellValue = CellComponentFactory.renderObject(row[i], this._colDefs[i]);
            buf.append(this.format(cellValue, this._colDefs[i].getDisplayWidth(), ' '));
        }
        this.addLine(buf.toString());
    }

    public void moveToTop() {
        this._outText.select(0, 0);
    }

    public JComponent getComponent() {
        return this._outText;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    private void addLine(String line) {
        this._outText.append(line);
        this._outText.append("\n");
    }

    private String format(String data, int displaySize, char fillChar) {
        int extraPadding;
        data = data.replace('\n', ' ');
        data = data.replace('\r', ' ');
        StringBuffer output = new StringBuffer(data);
        if (displaySize > 50) {
            displaySize = 50;
        }
        if (output.length() > displaySize) {
            output.setLength(displaySize);
        }
        if ((extraPadding = (displaySize += 2) - output.length()) > 0) {
            char[] padData = new char[extraPadding];
            Arrays.fill(padData, fillChar);
            output.append(padData);
        }
        return output.toString();
    }
}

