/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.StatementCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class StatementWrapper
implements StatementCallback {
    private static final ILogger s_log = LoggerController.createLogger(StatementWrapper.class);
    private boolean _maxRowsWasSet;
    private ISession _session;
    private Statement _statement;
    private ArrayList<ResultSetWrapper> _resultSetWrappers = new ArrayList();
    private boolean _hasReturnedResultSet;

    public StatementWrapper(Statement stmt) {
        this(stmt, null);
    }

    public StatementWrapper(Statement statement, ISession session) {
        this._session = session;
        this._statement = statement;
    }

    public void setMaxRows() {
        if (null == this._session || this.isContinueReadActive()) {
            return;
        }
        if (this._session.getProperties().getSQLLimitRows()) {
            this._maxRowsWasSet = true;
            try {
                this._statement.setMaxRows(this._session.getProperties().getSQLNbrRowsToShow());
            }
            catch (Exception e) {
                s_log.error("Can't Set MaxRows", e);
            }
        }
    }

    @Override
    public boolean isMaxRowsWasSet() {
        return this._maxRowsWasSet;
    }

    @Override
    public int getMaxRowsCount() {
        return this._session.getProperties().getSQLNbrRowsToShow();
    }

    public void setFetchSize() {
        if (null == this._session) {
            return;
        }
        if (this._session.getProperties().getSQLUseFetchSize() && this._session.getProperties().getSQLFetchSize() > 0) {
            try {
                this._statement.setFetchSize(this._session.getProperties().getSQLFetchSize());
            }
            catch (Exception e) {
                s_log.error("Can't Set FetchSize", e);
            }
        }
    }

    public void cancel() throws SQLException {
        this._statement.cancel();
    }

    public ResultSetWrapper getResultSetWrapper() throws SQLException {
        ResultSet resultSet = this._statement.getResultSet();
        if (null == resultSet) {
            return null;
        }
        this._hasReturnedResultSet = true;
        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(resultSet, this);
        this._resultSetWrappers.add(resultSetWrapper);
        return resultSetWrapper;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.isContinueReadActive() && this._hasReturnedResultSet) {
            return false;
        }
        return this._statement.getMoreResults();
    }

    public int getMaxRows() {
        int result;
        block2: {
            result = 0;
            try {
                result = this._statement.getMaxRows();
            }
            catch (SQLException e) {
                if (!s_log.isDebugEnabled()) break block2;
                s_log.debug("Unexpected exception: " + e.getMessage(), e);
            }
        }
        return result;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._statement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this._statement.clearWarnings();
    }

    public boolean execute(String sql) throws SQLException {
        return this._statement.execute(sql);
    }

    public int getUpdateCount() throws SQLException {
        if (this.isContinueReadActive() && this._hasReturnedResultSet) {
            return -1;
        }
        return this._statement.getUpdateCount();
    }

    @Override
    public boolean isContinueReadActive() {
        return this._session.getProperties().getSQLReadOn();
    }

    @Override
    public int getFirstBlockCount() {
        return this._session.getProperties().getSQLReadOnBlockSize();
    }

    @Override
    public int getContinueBlockCount() {
        return this._session.getProperties().getSQLReadOnBlockSize();
    }

    @Override
    public void closeStatementIfContinueReadActive() {
        if (!this.isContinueReadActive()) {
            return;
        }
        this._closeStatement();
    }

    public void closeIfContinueReadIsNotActive() throws SQLException {
        if (this.isContinueReadActive()) {
            return;
        }
        this._closeStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeStatement() {
        try {
            SQLUtilities.closeStatement(this._statement);
        }
        finally {
            this._statement = null;
        }
    }
}

