/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.recentfiles;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class RecentFilesDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentFilesDialog.class);
    public static final String PREF_KEY_RECENT_FILES_DIALOG_WIDTH = "Squirrel.RecentFilesDialogWidth";
    public static final String PREF_KEY_RECENT_FILES_DIALOG_HEIGHT = "Squirrel.RecentFilesDialogHeight";
    JTree treFiles;
    IntegerField txtNumberRecentFiles;
    JButton btnFavourites;
    JButton btnAliasFavourites;
    JCheckBox chkAppend;
    JButton btnOpenFile;
    JButton btnClose;
    JButton btnRemoveSeleted;

    public RecentFilesDialog(Frame parent, boolean isCalledFromAliasView) {
        super(parent, true);
        this.setTitle(s_stringMgr.getString("recentfiles.RecentFilesDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 5, 5), 0, 0);
        this.treFiles = new JTree();
        this.getContentPane().add((Component)new JScrollPane(this.treFiles), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createConfigPanel(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonsPanel(isCalledFromAliasView), gbc);
        this.setSize(this.getDim());
        GUIUtils.centerWithinParent(this);
        GUIUtils.enableCloseByEscape(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RecentFilesDialog.this.onWindowClosing();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RecentFilesDialog.this.onWindowClosing();
            }
        });
    }

    private void onWindowClosing() {
        Preferences.userRoot().putInt(PREF_KEY_RECENT_FILES_DIALOG_WIDTH, this.getSize().width);
        Preferences.userRoot().putInt(PREF_KEY_RECENT_FILES_DIALOG_HEIGHT, this.getSize().height);
    }

    private Dimension getDim() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_RECENT_FILES_DIALOG_WIDTH, 500), Preferences.userRoot().getInt(PREF_KEY_RECENT_FILES_DIALOG_HEIGHT, 500));
    }

    private JPanel createButtonsPanel(boolean isCalledFromAliasView) {
        GridBagConstraints gbc;
        JPanel ret = new JPanel(new GridBagLayout());
        int gridy = 0;
        if (!isCalledFromAliasView) {
            gbc = new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
            this.chkAppend = new JCheckBox(s_stringMgr.getString("recentfiles.RecentFilesDialog.append"));
            ret.add((Component)this.chkAppend, gbc);
        }
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnOpenFile = isCalledFromAliasView ? new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.openFileInNewSession")) : new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.openFile"));
        ret.add((Component)this.btnOpenFile, gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnClose = new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.close"));
        ret.add((Component)this.btnClose, gbc);
        gbc = new GridBagConstraints(0, ++gridy, 2, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JPanel createConfigPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("recentfiles.RecentFilesDialog.configurations")));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.createMaximumNumberLinePanel(), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.createAddFilesToFolderLine(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnRemoveSeleted = new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.removeSelectedFiles"));
        ret.add((Component)this.btnRemoveSeleted, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JPanel createAddFilesToFolderLine() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("recentfiles.RecentFilesDialog.addFilesTo")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnFavourites = new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.favourites"));
        ret.add((Component)this.btnFavourites, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnAliasFavourites = new JButton(s_stringMgr.getString("recentfiles.RecentFilesDialog.aliasFavourites"));
        ret.add((Component)this.btnAliasFavourites, gbc);
        return ret;
    }

    private JPanel createMaximumNumberLinePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("recentfiles.RecentFilesDialog.maxNumber")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.txtNumberRecentFiles = new IntegerField(4);
        ret.add((Component)this.txtNumberRecentFiles, gbc);
        return ret;
    }
}

