/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.tinylaf.Theme;

class TinySplitPaneDivider
extends BasicSplitPaneDivider {
    private int inset = 2;
    private Color controlColor = MetalLookAndFeel.getControl();

    public TinySplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new MetalDividerLayout());
    }

    public void paint(Graphics g) {
        g.setColor(this.controlColor);
        Rectangle clip = g.getClipBounds();
        Insets insets = this.getInsets();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension size = this.getSize();
        size.width -= this.inset * 2;
        size.height -= this.inset * 2;
        int drawX = this.inset;
        int drawY = this.inset;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            drawX += insets.left;
            drawY += insets.top;
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            public void setBorder(Border b) {
            }

            public void paint(Graphics g) {
                JSplitPane splitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane != null) {
                    int oneTouchSize = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = TinySplitPaneDivider.this.getOrientationFromSuper();
                    g.setColor(Theme.backColor.getColor());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Theme.splitPaneButtonColor.getColor());
                    if (orientation == 0) {
                        g.drawLine(2, 1, 3, 1);
                        g.drawLine(1, 2, 4, 2);
                        g.drawLine(0, 3, 5, 3);
                    } else {
                        g.drawLine(1, 2, 1, 3);
                        g.drawLine(2, 1, 2, 4);
                        g.drawLine(3, 0, 3, 5);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics g) {
                JSplitPane splitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
                if (splitPane != null) {
                    int oneTouchSize = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = TinySplitPaneDivider.this.getOrientationFromSuper();
                    g.setColor(Theme.backColor.getColor());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Theme.splitPaneButtonColor.getColor());
                    if (orientation == 0) {
                        g.drawLine(2, 3, 3, 3);
                        g.drawLine(1, 2, 4, 2);
                        g.drawLine(0, 1, 5, 1);
                    } else {
                        g.drawLine(3, 2, 3, 3);
                        g.drawLine(2, 1, 2, 4);
                        g.drawLine(1, 0, 1, 5);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public class MetalDividerLayout
    implements LayoutManager {
        public void layoutContainer(Container c) {
            JButton leftButton = TinySplitPaneDivider.this.getLeftButtonFromSuper();
            JButton rightButton = TinySplitPaneDivider.this.getRightButtonFromSuper();
            JSplitPane splitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
            int orientation = TinySplitPaneDivider.this.getOrientationFromSuper();
            int oneTouchSize = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
            int oneTouchOffset = TinySplitPaneDivider.this.getOneTouchOffsetFromSuper();
            Insets insets = TinySplitPaneDivider.this.getInsets();
            if (leftButton != null && rightButton != null && c == TinySplitPaneDivider.this) {
                if (splitPane.isOneTouchExpandable()) {
                    if (orientation == 0) {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = TinySplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(oneTouchOffset, extraY, blockSize * 2, blockSize);
                        rightButton.setBounds(oneTouchOffset + oneTouchSize * 2, extraY, blockSize * 2, blockSize);
                    } else {
                        int extraX;
                        int blockSize = TinySplitPaneDivider.this.getDividerSize();
                        int n = extraX = insets != null ? insets.left : 0;
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(extraX, oneTouchOffset, blockSize, blockSize * 2);
                        rightButton.setBounds(extraX, oneTouchOffset + oneTouchSize * 2, blockSize, blockSize * 2);
                    }
                } else {
                    leftButton.setBounds(-5, -5, 1, 1);
                    rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }
}

