/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.nondbconst;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.ContraintDisplayData;

public class ConstraintDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConstraintDataSet.class);
    private static final int DISPLAY_WIDTH = 30;
    private int _curIx = -1;
    private ColumnDisplayDefinition[] _columnDisplayDefinitions;
    private ArrayList<ContraintDisplayData> _contraintDisplayData = new ArrayList();

    public ConstraintDataSet(ConstraintView constraintView, String fkTableName, String pkTableName) {
        for (int i = 0; i < constraintView.getData().getFkColumnInfos().length; ++i) {
            ColumnInfo fkCol = constraintView.getData().getFkColumnInfos()[i];
            ColumnInfo pkCol = constraintView.getData().getPkColumnInfos()[i];
            ContraintDisplayData buf = new ContraintDisplayData(fkCol, pkCol);
            this._contraintDisplayData.add(buf);
        }
        this._columnDisplayDefinitions = new ColumnDisplayDefinition[]{new ColumnDisplayDefinition(30, s_stringMgr.getString("graph.ConstraintDataSet.LocalColumn", new Object[]{fkTableName})), new ColumnDisplayDefinition(30, s_stringMgr.getString("graph.ConstraintDataSet.ReferencingColumn", new Object[]{pkTableName}))};
    }

    public int getColumnCount() throws DataSetException {
        return this._columnDisplayDefinitions.length;
    }

    public DataSetDefinition getDataSetDefinition() throws DataSetException {
        return new DataSetDefinition(this._columnDisplayDefinitions);
    }

    public boolean next(IMessageHandler msgHandler) throws DataSetException {
        return ++this._curIx < this._contraintDisplayData.size();
    }

    public Object get(int columnIndex) throws DataSetException {
        switch (columnIndex) {
            case 0: {
                return this._contraintDisplayData.get(this._curIx).getFkCol();
            }
            case 1: {
                return this._contraintDisplayData.get(this._curIx).getPkCol();
            }
        }
        throw new IndexOutOfBoundsException("Invalid column index " + columnIndex);
    }

    public ArrayList<ContraintDisplayData> removeRows(int[] rows) {
        if (0 == rows.length) {
            return new ArrayList<ContraintDisplayData>();
        }
        ArrayList<ContraintDisplayData> toRemove = new ArrayList<ContraintDisplayData>();
        for (int row : rows) {
            if (row >= this._contraintDisplayData.size()) continue;
            toRemove.add(this._contraintDisplayData.get(row));
        }
        this._contraintDisplayData.removeAll(toRemove);
        this._curIx = -1;
        return toRemove;
    }

    public void addRow(ColumnInfo fkCol, ColumnInfo pkCol) {
        this._contraintDisplayData.add(new ContraintDisplayData(fkCol, pkCol));
        this._curIx = -1;
    }

    public void writeConstraintView(ConstraintView constraintView, TableFrameController fkFrameOriginatingFrom, TableFrameController pkFramePointingTo) {
        constraintView.getData().removeAllColumns();
        ArrayList<ColumnInfo> pkCols = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> fkCols = new ArrayList<ColumnInfo>();
        for (ContraintDisplayData contraintDisplayData : this._contraintDisplayData) {
            fkCols.add(contraintDisplayData.getFkCol());
            pkCols.add(contraintDisplayData.getPkCol());
        }
        constraintView.getData().setColumnInfos(pkCols, fkCols);
    }

    public boolean isEmpty() {
        return this._contraintDisplayData.isEmpty();
    }
}

