/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.IntelliJProjectConfiguration;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoriesConfiguration;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryDescription;
import org.jetbrains.jps.model.jarRepository.JpsRemoteRepositoryService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration;", "", "()V", "moduleLibraries", "", "", "Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "projectHome", "Lorg/jetbrains/annotations/NotNull;", "projectLibraries", "remoteRepositoryDescriptions", "", "Lorg/jetbrains/jps/model/jarRepository/JpsRemoteRepositoryDescription;", "Companion", "LibraryRoots", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nIntelliJProjectConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProjectConfiguration.kt\ncom/intellij/project/IntelliJProjectConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1208#2,2:124\n1238#2,2:126\n1241#2:129\n1208#2,2:130\n1238#2,4:132\n1#3:128\n*S KotlinDebug\n*F\n+ 1 IntelliJProjectConfiguration.kt\ncom/intellij/project/IntelliJProjectConfiguration\n*L\n45#1:124,2\n45#1:126,2\n45#1:129\n37#1:130,2\n37#1:132,4\n*E\n"})
public final class IntelliJProjectConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectHome;
    @NotNull
    private final Map<String, LibraryRoots> projectLibraries;
    @NotNull
    private final Map<String, Map<String, LibraryRoots>> moduleLibraries;
    @NotNull
    private final List<JpsRemoteRepositoryDescription> remoteRepositoryDescriptions;
    @NotNull
    private static final Lazy<IntelliJProjectConfiguration> instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);

    /*
     * WARNING - void declaration
     */
    public IntelliJProjectConfiguration() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        String string = PathManager.getHomePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath()");
        this.projectHome = string;
        JpsProject project2 = Companion.loadIntelliJProject(this.projectHome);
        JpsLibraryCollection jpsLibraryCollection = project2.getLibraryCollection();
        Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryCollection, (String)"project.libraryCollection");
        this.projectLibraries = IntelliJProjectConfiguration._init_$extractLibrariesRoots(jpsLibraryCollection);
        List list = project2.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.modules");
        Iterable iterable = list;
        IntelliJProjectConfiguration intelliJProjectConfiguration = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string2;
            Map map;
            Map libraries;
            JpsModule it;
            JpsModule jpsModule = (JpsModule)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"it.name");
            it = (JpsModule)element$iv$iv;
            boolean bl2 = false;
            JpsLibraryCollection jpsLibraryCollection2 = it.getLibraryCollection();
            Intrinsics.checkNotNullExpressionValue((Object)jpsLibraryCollection2, (String)"it.libraryCollection");
            Map map3 = libraries = IntelliJProjectConfiguration._init_$extractLibrariesRoots(jpsLibraryCollection2);
            if (map3.isEmpty()) {
                boolean bl3 = false;
                map = MapsKt.emptyMap();
            } else {
                map = map3;
            }
            Map map4 = map;
            map2.put(string2, map4);
        }
        intelliJProjectConfiguration.moduleLibraries = destination$iv$iv;
        JpsRemoteRepositoriesConfiguration jpsRemoteRepositoriesConfiguration = JpsRemoteRepositoryService.getInstance().getRemoteRepositoriesConfiguration(project2);
        Intrinsics.checkNotNull((Object)jpsRemoteRepositoriesConfiguration);
        List list2 = jpsRemoteRepositoriesConfiguration.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance().getRemoteR\u2026n(project)!!.repositories");
        this.remoteRepositoryDescriptions = list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, LibraryRoots> _init_$extractLibrariesRoots(JpsLibraryCollection collection) {
        void $this$associateByTo$iv$iv;
        List list = collection.getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collection.libraries");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string;
            JpsLibrary it;
            JpsLibrary jpsLibrary = (JpsLibrary)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"it.name");
            it = (JpsLibrary)element$iv$iv;
            boolean bl2 = false;
            List list2 = List.copyOf(it.getFiles(JpsOrderRootType.COMPILED));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(it.getFiles(JpsOrderRootType.COMPILED))");
            List list3 = List.copyOf(it.getFiles(JpsOrderRootType.SOURCES));
            Intrinsics.checkNotNullExpressionValue(list3, (String)"copyOf(it.getFiles(JpsOrderRootType.SOURCES))");
            LibraryRoots libraryRoots = new LibraryRoots(list2, list3);
            map.put(string, libraryRoots);
        }
        return destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<JpsRemoteRepositoryDescription> getRemoteRepositoryDescriptions() {
        return Companion.getRemoteRepositoryDescriptions();
    }

    @JvmStatic
    @NotNull
    public static final List<String> getProjectLibraryClassesRootPaths(@NotNull String libraryName) {
        return Companion.getProjectLibraryClassesRootPaths(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getProjectLibraryClassesRootUrls(@NotNull String libraryName) {
        return Companion.getProjectLibraryClassesRootUrls(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final LibraryRoots getProjectLibrary(@NotNull String libraryName) {
        return Companion.getProjectLibrary(libraryName);
    }

    @JvmStatic
    @NotNull
    public static final LibraryRoots getModuleLibrary(@NotNull String moduleName, @NotNull String libraryName) {
        return Companion.getModuleLibrary(moduleName, libraryName);
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getJarFromSingleJarProjectLibrary(@NotNull String projectLibraryName) {
        return Companion.getJarFromSingleJarProjectLibrary(projectLibraryName);
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getVirtualFile(@NotNull LibraryRoots lib) {
        return Companion.getVirtualFile(lib);
    }

    @JvmStatic
    @NotNull
    public static final Path getJarPathFromSingleJarProjectLibrary(@NotNull String libName) {
        return Companion.getJarPathFromSingleJarProjectLibrary(libName);
    }

    @JvmStatic
    @NotNull
    public static final JpsProject loadIntelliJProject(@NotNull String projectHome) {
        return Companion.loadIntelliJProject(projectHome);
    }

    @JvmStatic
    @NotNull
    public static final Path getLocalMavenRepo() {
        return Companion.getLocalMavenRepo();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0012H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration$Companion;", "", "()V", "instance", "Lcom/intellij/project/IntelliJProjectConfiguration;", "getInstance", "()Lcom/intellij/project/IntelliJProjectConfiguration;", "instance$delegate", "Lkotlin/Lazy;", "getJarFromSingleJarProjectLibrary", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectLibraryName", "", "getJarPathFromSingleJarProjectLibrary", "Ljava/nio/file/Path;", "libName", "getLocalMavenRepo", "getModuleLibrary", "Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "moduleName", "libraryName", "getProjectLibrary", "getProjectLibraryClassesRootPaths", "", "getProjectLibraryClassesRootUrls", "getRemoteRepositoryDescriptions", "Lorg/jetbrains/jps/model/jarRepository/JpsRemoteRepositoryDescription;", "getVirtualFile", "lib", "loadIntelliJProject", "Lorg/jetbrains/jps/model/JpsProject;", "projectHome", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        private final IntelliJProjectConfiguration getInstance() {
            Lazy lazy = instance$delegate;
            return (IntelliJProjectConfiguration)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final List<JpsRemoteRepositoryDescription> getRemoteRepositoryDescriptions() {
            return this.getInstance().remoteRepositoryDescriptions;
        }

        @JvmStatic
        @NotNull
        public final List<String> getProjectLibraryClassesRootPaths(@NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            return this.getProjectLibrary(libraryName).getClassesPaths();
        }

        @JvmStatic
        @NotNull
        public final List<String> getProjectLibraryClassesRootUrls(@NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            return this.getProjectLibrary(libraryName).getClassesUrls();
        }

        @JvmStatic
        @NotNull
        public final LibraryRoots getProjectLibrary(@NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            LibraryRoots libraryRoots = (LibraryRoots)this.getInstance().projectLibraries.get(libraryName);
            if (libraryRoots == null) {
                throw new IllegalArgumentException("Cannot find project library '" + libraryName + "' in " + this.getInstance().projectHome);
            }
            return libraryRoots;
        }

        @JvmStatic
        @NotNull
        public final LibraryRoots getModuleLibrary(@NotNull String moduleName, @NotNull String libraryName) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Map map = (Map)this.getInstance().moduleLibraries.get(moduleName);
            if (map == null) {
                throw new IllegalArgumentException("Cannot find module '" + moduleName + "' in " + this.getInstance().projectHome);
            }
            Map moduleLibraries = map;
            LibraryRoots libraryRoots = (LibraryRoots)moduleLibraries.get(libraryName);
            if (libraryRoots == null) {
                throw new IllegalArgumentException("Cannot find module library '" + libraryName + "' in " + moduleName);
            }
            return libraryRoots;
        }

        @JvmStatic
        @NotNull
        public final VirtualFile getJarFromSingleJarProjectLibrary(@NotNull String projectLibraryName) {
            Intrinsics.checkNotNullParameter((Object)projectLibraryName, (String)"projectLibraryName");
            return this.getVirtualFile(this.getProjectLibrary(projectLibraryName));
        }

        @JvmStatic
        @NotNull
        public final VirtualFile getVirtualFile(@NotNull LibraryRoots lib) {
            Intrinsics.checkNotNullParameter((Object)lib, (String)"lib");
            String url = (String)CollectionsKt.single(lib.getClassesUrls());
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
            if (virtualFile == null) {
                throw new IllegalStateException("Cannot find virtual file by " + url + " (nio file exists: " + ((File)CollectionsKt.single(lib.getClasses())).exists() + ")");
            }
            return virtualFile;
        }

        @JvmStatic
        @NotNull
        public final Path getJarPathFromSingleJarProjectLibrary(@NotNull String libName) {
            Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
            Path path = ((File)CollectionsKt.single(this.getProjectLibrary(libName).getClasses())).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectLibrary(libNam\u2026classes.single().toPath()");
            return path;
        }

        @JvmStatic
        @NotNull
        public final JpsProject loadIntelliJProject(@NotNull String projectHome) {
            Intrinsics.checkNotNullParameter((Object)projectHome, (String)"projectHome");
            String m2Repo = PathKt.getSystemIndependentPath((Path)this.getLocalMavenRepo());
            JpsProject jpsProject = JpsSerializationManager.getInstance().loadProject(projectHome, MapsKt.mapOf((Pair)TuplesKt.to((Object)"MAVEN_REPOSITORY", (Object)m2Repo)), true);
            Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"getInstance().loadProjec\u2026OSITORY to m2Repo), true)");
            return jpsProject;
        }

        @JvmStatic
        @NotNull
        public final Path getLocalMavenRepo() {
            String[] stringArray = new String[]{".m2/repository"};
            Path path = Paths.get(SystemProperties.getUserHome(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(SystemProperties.get\u2026Home(), \".m2/repository\")");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/project/IntelliJProjectConfiguration$LibraryRoots;", "", "classes", "", "Ljava/io/File;", "sources", "(Ljava/util/List;Ljava/util/List;)V", "getClasses", "()Ljava/util/List;", "classesPaths", "", "getClassesPaths", "classesUrls", "getClassesUrls", "getSources", "sourcesUrls", "getSourcesUrls", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nIntelliJProjectConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJProjectConfiguration.kt\ncom/intellij/project/IntelliJProjectConfiguration$LibraryRoots\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n1549#2:132\n1620#2,3:133\n*S KotlinDebug\n*F\n+ 1 IntelliJProjectConfiguration.kt\ncom/intellij/project/IntelliJProjectConfiguration$LibraryRoots\n*L\n114#1:124\n114#1:125,3\n117#1:128\n117#1:129,3\n120#1:132\n120#1:133,3\n*E\n"})
    public static final class LibraryRoots {
        @NotNull
        private final List<File> classes;
        @NotNull
        private final List<File> sources;

        public LibraryRoots(@NotNull List<? extends File> classes, @NotNull List<? extends File> sources) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            this.classes = classes;
            this.sources = sources;
        }

        @NotNull
        public final List<File> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<File> getSources() {
            return this.sources;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getClassesPaths() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.classes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.toSystemIndependentName((String)it.getAbsolutePath()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getClassesUrls() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.classes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JpsPathUtil.getLibraryRootUrl((File)it));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getSourcesUrls() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.sources;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JpsPathUtil.getLibraryRootUrl((File)it));
            }
            return (List)destination$iv$iv;
        }
    }
}

