/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMixedListInfo;
import com.intellij.ide.actions.searcheverywhere.SearchRestartReason;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.searchEverywhereMl.SearchEverywhereMlExperiment;
import com.intellij.searchEverywhereMl.ranking.FeaturesLoggingRandomisation;
import com.intellij.searchEverywhereMl.ranking.SearchEverywhereFoundElementInfoWithMl;
import com.intellij.searchEverywhereMl.ranking.SearchEverywhereMLContextInfo;
import com.intellij.searchEverywhereMl.ranking.SearchEverywhereMLStatisticsCollector;
import com.intellij.searchEverywhereMl.ranking.SearchEverywhereMlSearchState;
import com.intellij.searchEverywhereMl.ranking.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.features.FeaturesProviderCacheDataProvider;
import com.intellij.searchEverywhereMl.ranking.features.statistician.SearchEverywhereContributorStatistician;
import com.intellij.searchEverywhereMl.ranking.features.statistician.SearchEverywhereStatisticianService;
import com.intellij.searchEverywhereMl.ranking.id.SearchEverywhereMlOrderedItemIdProvider;
import com.intellij.searchEverywhereMl.ranking.model.SearchEverywhereModelProvider;
import com.intellij.searchEverywhereMl.ranking.performance.PerformanceTracker;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u0004\u0018\u00010\u0011J\u0006\u0010#\u001a\u00020$JJ\u0010%\u001a\u00020$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+2\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000+0/J,\u00101\u001a\u00020$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000+0/Jn\u00102\u001a\u00020$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020-2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u0002062\u0012\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000+0/2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020-R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLSearchSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "mixedListInfo", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "sessionId", "", "loggingRandomisation", "Lcom/intellij/searchEverywhereMl/ranking/FeaturesLoggingRandomisation;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;ILcom/intellij/searchEverywhereMl/ranking/FeaturesLoggingRandomisation;)V", "cachedContextInfo", "Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLContextInfo;", "getCachedContextInfo", "()Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLContextInfo;", "currentSearchState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereMlSearchState;", "itemIdProvider", "Lcom/intellij/searchEverywhereMl/ranking/id/SearchEverywhereMlOrderedItemIdProvider;", "getItemIdProvider", "()Lcom/intellij/searchEverywhereMl/ranking/id/SearchEverywhereMlOrderedItemIdProvider;", "logger", "Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLStatisticsCollector;", "getMixedListInfo", "()Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereMixedListInfo;", "modelProviderWithCache", "Lcom/intellij/searchEverywhereMl/ranking/model/SearchEverywhereModelProvider;", "performanceTracker", "Lcom/intellij/searchEverywhereMl/ranking/performance/PerformanceTracker;", "providersCache", "Lcom/intellij/searchEverywhereMl/ranking/features/FeaturesProviderCache;", "sessionStartTime", "", "getCurrentSearchState", "notifySearchResultsUpdated", "", "onItemSelected", "experimentStrategy", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "indexes", "", "selectedItems", "", "closePopup", "", "elementsProvider", "Lkotlin/Function0;", "Lcom/intellij/searchEverywhereMl/ranking/SearchEverywhereFoundElementInfoWithMl;", "onSearchFinished", "onSearchRestart", "reason", "Lcom/intellij/ide/actions/searcheverywhere/SearchRestartReason;", "tabId", "", "orderByMl", "keysTyped", "backspacesTyped", "searchQuery", "previousElementsProvider", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "intellij.searchEverywhereMl.ranking"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMLSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLSearchSession\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n43#2,3:139\n1855#3,2:142\n1855#3,2:144\n1#4:146\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMLSearchSession.kt\ncom/intellij/searchEverywhereMl/ranking/SearchEverywhereMLSearchSession\n*L\n87#1:139,3\n88#1:142,2\n93#1:144,2\n*E\n"})
public final class SearchEverywhereMLSearchSession {
    @NotNull
    private final SearchEverywhereMixedListInfo mixedListInfo;
    private final int sessionId;
    @NotNull
    private final FeaturesLoggingRandomisation loggingRandomisation;
    @NotNull
    private final SearchEverywhereMlOrderedItemIdProvider itemIdProvider;
    private final long sessionStartTime;
    @Nullable
    private final FeaturesProviderCache providersCache;
    @NotNull
    private final SearchEverywhereModelProvider modelProviderWithCache;
    @NotNull
    private final SearchEverywhereMLContextInfo cachedContextInfo;
    @NotNull
    private final AtomicReference<SearchEverywhereMlSearchState> currentSearchState;
    @NotNull
    private final SearchEverywhereMLStatisticsCollector logger;
    @NotNull
    private final PerformanceTracker performanceTracker;

    public SearchEverywhereMLSearchSession(@Nullable Project project, @NotNull SearchEverywhereMixedListInfo mixedListInfo, int sessionId, @NotNull FeaturesLoggingRandomisation loggingRandomisation) {
        Intrinsics.checkNotNullParameter((Object)mixedListInfo, (String)"mixedListInfo");
        Intrinsics.checkNotNullParameter((Object)loggingRandomisation, (String)"loggingRandomisation");
        this.mixedListInfo = mixedListInfo;
        this.sessionId = sessionId;
        this.loggingRandomisation = loggingRandomisation;
        this.itemIdProvider = new SearchEverywhereMlOrderedItemIdProvider();
        this.sessionStartTime = System.currentTimeMillis();
        this.providersCache = new FeaturesProviderCacheDataProvider().getDataToCache(project);
        this.modelProviderWithCache = new SearchEverywhereModelProvider();
        this.cachedContextInfo = new SearchEverywhereMLContextInfo(project);
        this.currentSearchState = new AtomicReference();
        this.logger = new SearchEverywhereMLStatisticsCollector();
        this.performanceTracker = new PerformanceTracker();
    }

    @NotNull
    public final SearchEverywhereMixedListInfo getMixedListInfo() {
        return this.mixedListInfo;
    }

    @NotNull
    public final SearchEverywhereMlOrderedItemIdProvider getItemIdProvider() {
        return this.itemIdProvider;
    }

    @NotNull
    public final SearchEverywhereMLContextInfo getCachedContextInfo() {
        return this.cachedContextInfo;
    }

    public final void onSearchRestart(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull SearchRestartReason reason, @NotNull String tabId, boolean orderByMl, int keysTyped, int backspacesTyped, @NotNull String searchQuery, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> previousElementsProvider, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(previousElementsProvider, (String)"previousElementsProvider");
        int prevTimeToResult = this.performanceTracker.getTimeElapsed();
        SearchEverywhereMlSearchState prevState = this.currentSearchState.getAndUpdate(arg_0 -> SearchEverywhereMLSearchSession.onSearchRestart$lambda$1(reason, experimentStrategy, project, this, tabId, orderByMl, keysTyped, backspacesTyped, searchQuery, searchScope, isSearchEverywhere, arg_0));
        if (prevState != null && experimentStrategy.isLoggingEnabledForTab(prevState.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(prevState.getTabId());
            this.logger.onSearchRestarted$intellij_searchEverywhereMl_ranking(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, this.cachedContextInfo, prevState, prevTimeToResult, this.mixedListInfo, previousElementsProvider);
        }
    }

    public final void onItemSelected(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull int[] indexes, @NotNull List<? extends Object> selectedItems, boolean closePopup, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            if (project != null) {
                Object it;
                boolean $i$f$service = false;
                Class<SearchEverywhereStatisticianService> serviceClass$iv = SearchEverywhereStatisticianService.class;
                Iterator iterator = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (iterator == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                SearchEverywhereStatisticianService statisticianService = (SearchEverywhereStatisticianService)((Object)iterator);
                Iterable $this$forEach$iv = selectedItems;
                boolean $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator.next();
                    boolean bl = false;
                    statisticianService.increaseUseCount(it);
                }
                if (Intrinsics.areEqual((Object)state.getTabId(), (Object)"SearchEverywhereContributor.All")) {
                    $this$forEach$iv = CollectionsKt.slice((List)((List)elementsProvider.invoke()), (Iterable)ArraysKt.asIterable((int[])indexes));
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (SearchEverywhereFoundElementInfoWithMl)((Object)element$iv);
                        boolean bl = false;
                        String string = ((SearchEverywhereFoundElementInfoWithMl)((Object)it)).contributor.getSearchProviderId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.contributor.searchProviderId");
                        SearchEverywhereContributorStatistician.Companion.increaseUseCount(string);
                    }
                }
            }
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onItemSelected$intellij_searchEverywhereMl_ranking(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, indexes, selectedItems, closePopup, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
    }

    public final void onSearchFinished(@Nullable Project project, @NotNull SearchEverywhereMlExperiment experimentStrategy, @NotNull Function0<? extends List<? extends SearchEverywhereFoundElementInfoWithMl>> elementsProvider) {
        Intrinsics.checkNotNullParameter((Object)experimentStrategy, (String)"experimentStrategy");
        Intrinsics.checkNotNullParameter(elementsProvider, (String)"elementsProvider");
        SearchEverywhereMlSearchState state = this.getCurrentSearchState();
        if (state != null && experimentStrategy.isLoggingEnabledForTab(state.getTabId())) {
            boolean shouldLogFeatures = this.loggingRandomisation.shouldLogFeatures(state.getTabId());
            this.logger.onSearchFinished$intellij_searchEverywhereMl_ranking(project, this.sessionId, shouldLogFeatures, this.itemIdProvider, state, this.performanceTracker.getTimeElapsed(), this.mixedListInfo, elementsProvider);
        }
    }

    public final void notifySearchResultsUpdated() {
        this.performanceTracker.stop();
    }

    @Nullable
    public final SearchEverywhereMlSearchState getCurrentSearchState() {
        return this.currentSearchState.get();
    }

    private static final SearchEverywhereMlSearchState onSearchRestart$lambda$1(SearchRestartReason $reason, SearchEverywhereMlExperiment $experimentStrategy, Project $project, SearchEverywhereMLSearchSession this$0, String $tabId, boolean $orderByMl, int $keysTyped, int $backspacesTyped, String $searchQuery, ScopeDescriptor $searchScope, boolean $isSearchEverywhere, SearchEverywhereMlSearchState prevState) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        Intrinsics.checkNotNullParameter((Object)$experimentStrategy, (String)"$experimentStrategy");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tabId, (String)"$tabId");
        Intrinsics.checkNotNullParameter((Object)$searchQuery, (String)"$searchQuery");
        long startTime = System.currentTimeMillis();
        SearchRestartReason searchReason = prevState == null ? SearchRestartReason.SEARCH_STARTED : $reason;
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = prevState;
        int nextSearchIndex = (searchEverywhereMlSearchState != null ? searchEverywhereMlSearchState.getSearchIndex() : 0) + 1;
        int experimentGroup = $experimentStrategy.getExperimentGroup();
        Project project = $project;
        if (project != null) {
            Project it = project;
            boolean bl2 = false;
            bl = DumbService.Companion.isDumb(it);
        } else {
            bl = null;
        }
        Boolean projectIsDumb = bl;
        this$0.performanceTracker.start();
        return new SearchEverywhereMlSearchState(this$0.sessionStartTime, startTime, nextSearchIndex, searchReason, $tabId, experimentGroup, $orderByMl, $keysTyped, $backspacesTyped, $searchQuery, this$0.modelProviderWithCache, this$0.providersCache, projectIsDumb, $searchScope, $isSearchEverywhere);
    }
}

